/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.aggregation.impl;

import java.io.File;

public class TempDir {
    private static TempDir instance;
    private String path;

    private TempDir(String path) {
        this.path = path;
    }

    public static void createInstance(String path) {
        instance = new TempDir(path);
    }

    public static TempDir getInstance() {
        return instance;
    }

    public String getPath() {
        return this.path;
    }

    public static void release() {
        if (instance != null) {
            File f = new File(instance.getPath());
            if (f.exists()) {
                TempDir.deleteDirectory(f);
            }
            instance = null;
        }
    }

    private static void deleteDirectory(File dir) {
        File[] subFiles = dir.listFiles();
        if (subFiles != null) {
            int i = 0;
            while (i < subFiles.length) {
                if (subFiles[i].isDirectory()) {
                    TempDir.deleteDirectory(subFiles[i]);
                } else {
                    TempDir.safeDelete(subFiles[i]);
                }
                ++i;
            }
        }
        TempDir.safeDelete(dir);
    }

    private static void safeDelete(File file) {
        if (!file.delete()) {
            file.deleteOnExit();
        }
    }
}

