/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.aggregation.impl.rank;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.birt.data.aggregation.i18n.Messages;
import org.eclipse.birt.data.aggregation.impl.AggrFunction;
import org.eclipse.birt.data.aggregation.impl.Constants;
import org.eclipse.birt.data.aggregation.impl.ParameterDefn;
import org.eclipse.birt.data.aggregation.impl.RunningAccumulator;
import org.eclipse.birt.data.aggregation.impl.SupportedDataTypes;
import org.eclipse.birt.data.aggregation.impl.rank.RankAggregationUtil;
import org.eclipse.birt.data.engine.api.aggregation.Accumulator;
import org.eclipse.birt.data.engine.api.aggregation.IParameterDefn;
import org.eclipse.birt.data.engine.core.DataException;

public class TotalRank
extends AggrFunction {
    public String getName() {
        return "RANK";
    }

    public int getType() {
        return 1;
    }

    public int getDataType() {
        return 2;
    }

    public IParameterDefn[] getParameterDefn() {
        return new IParameterDefn[]{new ParameterDefn("Expression", Constants.EXPRESSION_DISPLAY_NAME, false, true, SupportedDataTypes.CALCULATABLE, ""), new ParameterDefn("ascending", Messages.getString("TotalRank.param.ascending"), true, false, SupportedDataTypes.ANY, "")};
    }

    public int getNumberOfPasses() {
        return 2;
    }

    public Accumulator newAccumulator() {
        return new MyAccumulator();
    }

    public String getDescription() {
        return Messages.getString("TotalRank.description");
    }

    public String getDisplayName() {
        return Messages.getString("TotalRank.displayName");
    }

    private class MyAccumulator
    extends RunningAccumulator {
        private Integer sum;
        private List cachedValues;
        private boolean asc;
        private boolean hasInitialized;
        private int passCount = 0;
        private RankObjComparator comparator;

        private MyAccumulator() {
        }

        public void start() {
            if (this.passCount == 0) {
                this.cachedValues = new ArrayList();
                this.sum = 0;
                this.asc = true;
                this.hasInitialized = false;
                this.comparator = new RankObjComparator();
            }
            ++this.passCount;
        }

        public void onRow(Object[] args) throws DataException {
            assert (args.length > 0);
            if (this.passCount == 1) {
                if (args[0] != null) {
                    this.cachedValues.add(args[0]);
                } else {
                    this.cachedValues.add(RankAggregationUtil.getNullObject());
                }
                if (!this.hasInitialized && args[1] != null) {
                    this.hasInitialized = true;
                    this.asc = args[1].toString().equals("false") ? false : !(args[1] instanceof Double) || !((Double)args[1]).equals(new Double(0.0));
                }
            } else {
                Object compareValue = args[0] != null ? args[0] : RankAggregationUtil.getNullObject();
                this.sum = this.getRank(compareValue);
            }
        }

        public void finish() throws DataException {
            if (this.passCount == 1) {
                Collections.sort(this.cachedValues, this.comparator);
            }
        }

        private int getRank(Object key) {
            int index = Collections.binarySearch(this.cachedValues, key, this.comparator);
            if (index < 0) {
                return -1;
            }
            if (this.asc) {
                int i = index - 1;
                while (i >= 0) {
                    if (!this.cachedValues.get(i).equals(key)) {
                        return i + 2;
                    }
                    --i;
                }
            } else {
                int i = index + 1;
                while (i < this.cachedValues.size()) {
                    if (!this.cachedValues.get(i).equals(key)) {
                        return this.cachedValues.size() - i + 1;
                    }
                    ++i;
                }
            }
            return 1;
        }

        public Object getValue() throws DataException {
            return this.sum;
        }
    }

    static class RankObjComparator
    implements Comparator {
        RankObjComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof Comparable) {
                if (o2 instanceof Comparable) {
                    Comparable obj1 = (Comparable)o1;
                    Comparable obj2 = (Comparable)o2;
                    return obj1.compareTo(obj2);
                }
                return 1;
            }
            if (o2 instanceof Comparable) {
                return -1;
            }
            return 0;
        }
    }
}

