/*
 * Decompiled with CFR 0.152.
 */
package com.hand.mas.ant.service;

import com.hand.mas.ant.exception.LogErrorException;
import com.hand.mas.ant.exception.LogWarnException;
import com.hand.mas.ant.service.AbstractService;
import com.hand.mas.ant.util.LogUtil;
import com.hand.mas.ant.util.SysExcUtil;
import com.hand.mas.ant.util.TimeoutMonitor;
import java.util.Scanner;
import org.apache.tools.ant.Task;

public class SqlPlusService
implements AbstractService {
    private Long timeOut = 60000L;
    private Task task;
    private Runtime rt = Runtime.getRuntime();
    private String command;
    private boolean isLinux;
    Boolean errorFlag = false;
    Boolean appExitFlag = false;

    public SqlPlusService(Task owner, Long timeOut) {
        this.timeOut = timeOut;
        this.task = owner;
        this.isLinux = true;
    }

    public SqlPlusService(Task owner) {
        this.task = owner;
        this.isLinux = true;
    }

    @Override
    public void run() throws Exception {
        try {
            Process proc = null;
            proc = this.isLinux ? this.rt.exec(this.command) : this.rt.exec(SysExcUtil.getCmd(this.command));
            this.processPrint(proc);
            this.task.log(String.valueOf(this.command) + "\n---------------------------------------------ok");
        }
        catch (LogErrorException e) {
            this.task.log(String.valueOf(this.command) + "\n---------------------------------------------failure");
            LogUtil.logError(String.valueOf(this.command) + "\u65e0\u6cd5\u6267\u884c");
            LogUtil.logError("============================================");
            throw e;
        }
        catch (LogWarnException e) {
            this.task.log(String.valueOf(this.command) + "\n---------------------------------------------warn");
            LogUtil.logWarn(String.valueOf(this.command) + "\u6267\u884c\u5e26\u6709\u8b66\u544a\u6216\u9519\u8bef");
            LogUtil.logWarn("============================================");
            throw e;
        }
    }

    private void processPrint(Process proc) throws Exception {
        boolean hasWarn = false;
        TimeoutMonitor tm = new TimeoutMonitor(this.timeOut, proc);
        Thread deamon = new Thread(tm);
        deamon.start();
        Scanner sc = new Scanner(proc.getInputStream());
        while (sc.hasNextLine()) {
            String outStr = sc.nextLine();
            if (!hasWarn) {
                hasWarn = this.hasWarn(outStr);
            }
            System.out.print(" ");
            if (!hasWarn) continue;
            LogUtil.logWarn(outStr);
        }
        deamon.interrupt();
        if (!tm.successFlag) {
            throw new LogErrorException("\u6587\u4ef6\u6267\u884c\u9519\u8bef");
        }
        if (hasWarn) {
            throw new LogWarnException("\u6587\u4ef6\u6267\u884c\u5b58\u5728\u8b66\u544a");
        }
    }

    public boolean hasWarn(String testStr) {
        return testStr.contains("ORA") || testStr.contains("\u9519\u8bef") || testStr.contains("ERROR") || testStr.contains("\\*");
    }

    public void setTimeOut(Long timeOut) {
        this.timeOut = timeOut;
    }

    public void setCommands(String command) {
        this.command = command;
    }

    public void setErrorFlag(Boolean errorFlag) {
        this.errorFlag = errorFlag;
    }

    public void setAppExitFlag(Boolean appExitFlag) {
        this.appExitFlag = appExitFlag;
    }
}

