/*
 * Decompiled with CFR 0.152.
 */
package com.hand.mas.ant.task;

import com.hand.mas.ant.service.SqlPlusService;
import com.hand.mas.ant.util.LogUtil;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class SqlPlusTask
extends Task {
    private File file = null;
    private File dir = null;
    private Long timeout = 30000L;
    private Vector filesets = new Vector();
    private String dbuser = null;
    private String dbpass = null;
    private String tnsname = null;
    private String logOn = null;
    private String dupexec = null;
    private String dupexectime = null;
    private boolean isDupExec = false;
    private int dupTime = 3;
    private String logFilePath = null;
    private File logFile = null;

    public void init() {
        Project project = this.getProject();
        if (project == null) {
            throw new BuildException("No Project Define!");
        }
        this.logFilePath = project.getProperty("LogFilePath");
        this.logFile = new File(String.valueOf(project.getBaseDir().getAbsolutePath()) + "/" + this.logFilePath);
    }

    public void execute() {
        if (this.dbuser == null || this.dbpass == null || this.tnsname == null) {
            throw new BuildException("the dbHost or dbPort or dbuser or dbpass is not defined!");
        }
        this.logOn = String.valueOf(this.dbuser) + "/" + this.dbpass + "@" + this.tnsname;
        if (this.file == null && this.dir == null && this.filesets == null) {
            throw new BuildException("No Files or Dir exists");
        }
        if (this.dupexec != null && this.dupexec.equals("true")) {
            this.isDupExec = true;
            if (this.dupexectime != null) {
                try {
                    this.dupTime = Integer.parseInt(this.dupexectime);
                }
                catch (NumberFormatException e) {
                    this.log("\u591a\u6b21\u6267\u884c\u6b21\u6570\u8f93\u5165\u9519\u8bef\uff0c\u8f93\u5165\u5e76\u975e\u6570\u5b57\uff0c\u8bf7\u68c0\u67e5\uff01");
                    this.dupTime = 3;
                }
            }
        }
        if (this.file != null) {
            if (this.file.isDirectory()) {
                throw new BuildException("The file is a directory");
            }
            if (this.file.length() == 0L) {
                throw new BuildException("The file length is 0,please check the file!");
            }
            String command = "sqlplus " + this.logOn + " @" + this.file.getAbsolutePath();
            SqlPlusService sps = new SqlPlusService(this);
            sps.setCommands(command);
            try {
                sps.run();
            }
            catch (Exception exception) {}
        } else if (this.dir != null) {
            HashSet<String> errFileSet = new HashSet<String>();
            if (!this.file.isDirectory()) {
                throw new BuildException("The file is not directory");
            }
            File[] fs = this.dir.listFiles();
            SqlPlusService sps = new SqlPlusService(this);
            File[] fileArray = fs;
            int n = fs.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                String command2 = "sqlplus " + this.logOn + " @" + f.getAbsolutePath();
                sps.setCommands(command2);
                try {
                    sps.run();
                }
                catch (Exception e) {
                    errFileSet.add(String.valueOf(this.dir.getAbsolutePath()) + "/" + f.getAbsolutePath());
                }
                ++n2;
            }
            if (this.isDupExec) {
                int dt = 0;
                while (dt < this.dupTime) {
                    Iterator iterator = errFileSet.iterator();
                    while (iterator.hasNext()) {
                        String fileName = (String)iterator.next();
                        String command = "sqlplus " + this.logOn + " @" + fileName;
                        sps.setCommands(command);
                        try {
                            sps.run();
                            iterator.remove();
                        }
                        catch (Exception command2) {
                            // empty catch block
                        }
                    }
                    ++dt;
                }
                try {
                    for (String fileName : errFileSet) {
                        LogUtil.logError(String.valueOf(fileName) + "\u65e0\u6cd5\u6267\u884c");
                        LogUtil.logError("============================================");
                    }
                }
                catch (Exception e) {
                    this.log(e.getMessage());
                }
            }
        } else if (this.filesets != null) {
            HashSet<String> errFileSet = new HashSet<String>();
            for (Object o : this.filesets) {
                FileSet fileset = (FileSet)o;
                File dir = fileset.getDir();
                DirectoryScanner sc = fileset.getDirectoryScanner();
                String[] files = sc.getIncludedFiles();
                if (!dir.isDirectory()) {
                    throw new BuildException("The file is not directory");
                }
                File[] fs = dir.listFiles();
                SqlPlusService sps = new SqlPlusService(this);
                String[] stringArray = files;
                int n = files.length;
                int n3 = 0;
                while (n3 < n) {
                    String f = stringArray[n3];
                    try {
                        String command = "sqlplus " + this.logOn + " @" + dir.getAbsolutePath() + "/" + f;
                        sps.setCommands(command);
                        sps.run();
                    }
                    catch (Exception e) {
                        errFileSet.add(String.valueOf(dir.getAbsolutePath()) + "/" + f);
                    }
                    ++n3;
                }
                if (!this.isDupExec) continue;
                int dt = 0;
                while (dt < this.dupTime) {
                    Iterator iterator = errFileSet.iterator();
                    while (iterator.hasNext()) {
                        String fileName = (String)iterator.next();
                        String command = "sqlplus " + this.logOn + " @" + fileName;
                        sps.setCommands(command);
                        try {
                            sps.run();
                            iterator.remove();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    ++dt;
                }
                try {
                    for (String fileName : errFileSet) {
                        LogUtil.logError(String.valueOf(fileName) + "\u65e0\u6cd5\u6267\u884c");
                        LogUtil.logError("============================================");
                    }
                }
                catch (Exception e) {
                    this.log(e.getMessage());
                }
            }
        }
    }

    public void addFileSet(FileSet fileset) {
        this.filesets.add(fileset);
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setDir(File dir) {
        this.dir = dir;
    }

    public void setTimeout(Long timeout) {
        this.timeout = timeout;
    }

    public void setDbuser(String dbuser) {
        this.dbuser = dbuser;
    }

    public void setDbpass(String dbpass) {
        this.dbpass = dbpass;
    }

    public void setTnsname(String tnsname) {
        this.tnsname = tnsname;
    }

    public void setDupexec(String dupexec) {
        this.dupexec = dupexec;
    }

    public void setDupexectime(String dupexectime) {
        this.dupexectime = dupexectime;
    }
}

