/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IRenderTask;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.ITOCTree;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.api.impl.EngineTask;
import org.eclipse.birt.report.engine.api.impl.IInternalReportDocument;
import org.eclipse.birt.report.engine.api.impl.LogicalPageSequence;
import org.eclipse.birt.report.engine.api.impl.PageSequenceParse;
import org.eclipse.birt.report.engine.api.impl.ReportEngine;
import org.eclipse.birt.report.engine.api.impl.ReportRunnable;
import org.eclipse.birt.report.engine.api.impl.VisiblePageFilter;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.EngineExtensionManager;
import org.eclipse.birt.report.engine.executor.IReportExecutor;
import org.eclipse.birt.report.engine.executor.PageVariable;
import org.eclipse.birt.report.engine.executor.ReportExtensionExecutor;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.extension.engine.IContentProcessor;
import org.eclipse.birt.report.engine.extension.engine.IRenderExtension;
import org.eclipse.birt.report.engine.internal.document.PageHintReader;
import org.eclipse.birt.report.engine.internal.document.ReportPageExecutor;
import org.eclipse.birt.report.engine.internal.document.ReportletExecutor;
import org.eclipse.birt.report.engine.internal.document.v4.PageRangeIterator;
import org.eclipse.birt.report.engine.internal.executor.dup.SuppressDuplciateReportExecutor;
import org.eclipse.birt.report.engine.internal.executor.l18n.LocalizedReportExecutor;
import org.eclipse.birt.report.engine.internal.presentation.ReportDocumentInfo;
import org.eclipse.birt.report.engine.ir.MasterPageDesign;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.layout.ILayoutPageHandler;
import org.eclipse.birt.report.engine.layout.IReportLayoutEngine;
import org.eclipse.birt.report.engine.layout.html.HTMLLayoutContext;
import org.eclipse.birt.report.engine.layout.html.HTMLReportLayoutEngine;
import org.eclipse.birt.report.engine.layout.pdf.emitter.LayoutEngineContext;
import org.eclipse.birt.report.engine.nLayout.LayoutEngine;
import org.eclipse.birt.report.engine.parser.ReportParser;
import org.eclipse.birt.report.engine.presentation.IPageHint;
import org.eclipse.birt.report.engine.toc.ITOCReader;
import org.eclipse.birt.report.engine.toc.ITreeNode;
import org.eclipse.birt.report.engine.toc.TOCView;
import org.eclipse.birt.report.model.api.ReportDesignHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderTask
extends EngineTask
implements IRenderTask {
    protected IReportDocument reportDocument;
    protected IReportRunnable reportRunnable;
    protected InnerRender innerRender;
    protected long outputPageCount;
    protected ITOCReader tocReader;
    protected boolean designLoaded = false;
    protected boolean variablesLoaded = false;
    boolean renderExtensionLoaded;
    ArrayList<IRenderExtension> renderExtensions;
    boolean visiblePageLoaded;
    LogicalPageSequence logicalPageSequence;

    public RenderTask(ReportEngine engine, IReportDocument reportDocument) {
        this(engine, null, reportDocument);
    }

    public RenderTask(ReportEngine engine, IReportRunnable runnable, IReportDocument reportDoc) {
        super(engine, 2);
        this.reportDocument = reportDoc;
        this.reportRunnable = runnable;
        this.initRenderTask();
    }

    protected void initRenderTask() {
        this.executionContext.setFactoryMode(false);
        this.executionContext.setPresentationMode(true);
        this.executionContext.setReportDocument(this.reportDocument);
        assert (this.reportDocument instanceof IInternalReportDocument);
        IInternalReportDocument internalReportDoc = (IInternalReportDocument)this.reportDocument;
        if (this.reportDocument != null && this.reportRunnable == null) {
            IReportRunnable documentRunnable = this.getOnPreparedRunnable(this.reportDocument);
            this.setReportRunnable(documentRunnable);
            Report reportIR = internalReportDoc.getReportIR((ReportDesignHandle)documentRunnable.getDesignHandle());
            this.executionContext.setReport(reportIR);
        } else {
            this.setReportRunnable(this.reportRunnable);
            Report reportIR = new ReportParser().parse((ReportDesignHandle)this.reportRunnable.getDesignHandle());
            this.executionContext.setReport(reportIR);
        }
    }

    protected void loadDocument() {
        if (!this.variablesLoaded) {
            IInternalReportDocument documentReader = (IInternalReportDocument)this.reportDocument;
            try {
                ClassLoader classLoader = this.executionContext.getApplicationClassLoader();
                this.setParameters(documentReader.loadParameters(classLoader));
                this.usingParameterValues();
                this.executionContext.registerGlobalBeans(documentReader.loadVariables(classLoader));
                this.tocReader = documentReader.getTOCReader(classLoader);
            }
            catch (EngineException e) {
                this.log.log(Level.SEVERE, e.getLocalizedMessage(), (Throwable)((Object)e));
            }
            this.variablesLoaded = true;
        }
    }

    protected void loadReportVariable() throws IOException {
        PageHintReader hintsReader = new PageHintReader(this.reportDocument);
        try {
            Collection<PageVariable> vars = hintsReader.getPageVariables();
            if (vars != null) {
                this.executionContext.addPageVariables(vars);
            }
        }
        finally {
            hintsReader.close();
        }
    }

    @Override
    public void render(long pageNumber) throws EngineException {
        this.setPageNumber(pageNumber);
        this.render();
    }

    @Override
    public void close() {
        this.designLoaded = false;
        this.unloadRenderExtensions();
        this.unloadVisiblePages();
        if (this.tocReader != null) {
            try {
                this.tocReader.close();
            }
            catch (IOException iOException) {}
        }
        super.close();
    }

    @Override
    public void render(String pageRange) throws EngineException {
        this.setPageRange(pageRange);
        this.render();
    }

    @Override
    public void render(InstanceID iid) throws EngineException {
        this.setInstanceID(iid);
        this.render();
    }

    @Override
    public void render() throws EngineException {
        if (this.progressMonitor != null) {
            this.progressMonitor.onProgress(1, 2);
        }
        try {
            try {
                this.switchToOsgiClassLoader();
                this.changeStatusToRunning();
                if (this.renderOptions == null) {
                    throw new EngineException("Error.RenderOptionError");
                }
                this.loadDocument();
                this.loadReportVariable();
                ReportRunnable runnable = this.executionContext.getRunnable();
                if (runnable == null) {
                    throw new EngineException("Error.ReportDesignNotFoundError", new Object[]{this.reportDocument.getName()});
                }
                if (!this.designLoaded) {
                    this.loadDesign();
                    String version = this.reportDocument.getVersion();
                    Report report = this.executionContext.getReport();
                    report.updateVersion(version);
                    this.designLoaded = true;
                }
                this.updateRtLFlag();
                if (this.innerRender == null) {
                    this.innerRender = new PageRangeRender(new long[]{1L, this.getTotalPage()});
                }
                this.innerRender.render();
            }
            catch (EngineException e) {
                this.log.log(Level.SEVERE, "An error happened while running the report. Cause:", (Throwable)((Object)e));
                throw e;
            }
            catch (Exception ex) {
                this.log.log(Level.SEVERE, "An error happened while running the report. Cause:", ex);
                throw new EngineException("Error.ReportRunError", ex);
            }
            catch (OutOfMemoryError err) {
                this.log.log(Level.SEVERE, "There is insufficient memory to execute this report.");
                throw err;
            }
            catch (Throwable t) {
                this.log.log(Level.SEVERE, "Error happened while running the report.", t);
                throw new EngineException("Error.ReportRunError", t);
            }
        }
        finally {
            this.changeStatusToStopped();
            this.switchClassLoaderBack();
            if (this.progressMonitor != null) {
                this.progressMonitor.onProgress(2, 2);
            }
        }
    }

    @Override
    public long getPageCount() throws EngineException {
        if (this.runningStatus != 2) {
            throw new EngineException("Error.RenderTaskNotFinishedError");
        }
        return this.outputPageCount;
    }

    @Override
    public void setPageNumber(long pageNumber) throws EngineException {
        long totalVisiblePageCount = this.getTotalPage();
        if (pageNumber <= 0L || pageNumber > totalVisiblePageCount) {
            throw new EngineException("Error.PageNotFounddError", pageNumber);
        }
        this.innerRender = new PageRangeRender(new long[]{pageNumber, pageNumber});
    }

    @Override
    public void setInstanceID(String iid) throws EngineException {
        this.setInstanceID(InstanceID.parse(iid));
    }

    @Override
    public void setInstanceID(InstanceID iid) throws EngineException {
        long offset = this.reportDocument.getInstanceOffset(iid);
        if (offset == -1L) {
            throw new EngineException("Error.InvalidInstanceIDError", iid);
        }
        this.innerRender = new ReportletRender(offset);
    }

    @Override
    public void setReportlet(String bookmark) throws EngineException {
        long offset = this.reportDocument.getBookmarkOffset(bookmark);
        if (offset == -1L) {
            throw new EngineException("Error.InvalidBookmarkError", bookmark);
        }
        this.innerRender = new ReportletRender(offset);
    }

    @Override
    public void setPageRange(String pageRange) throws EngineException {
        long totalVisiblePageCount = this.getTotalPage();
        List list = PageSequenceParse.parsePageSequence(pageRange, totalVisiblePageCount);
        this.innerRender = new PageRangeRender(list);
    }

    @Override
    public void setBookmark(String bookmark) throws EngineException {
        long pageNumber = this.getPageNumber(bookmark);
        if (pageNumber <= 0L) {
            throw new EngineException("Error.BookmarkNotFoundError", bookmark);
        }
        this.innerRender = new PageRangeRender(new long[]{pageNumber, pageNumber});
    }

    @Override
    public long getPageNumber(String bookmark) throws EngineException {
        int physicalPageNumber = (int)this.executionContext.getReportDocument().getPageNumber(bookmark);
        return this.getLogicalPageNumber(physicalPageNumber);
    }

    @Override
    public ITOCTree getTOCTree() throws EngineException {
        String renderFormat;
        this.loadDocument();
        IReportDocument document = this.executionContext.getReportDocument();
        String format = "html";
        if (this.renderOptions != null && (renderFormat = this.renderOptions.getOutputFormat()) != null) {
            format = renderFormat;
        }
        ULocale ulocale = this.getULocale();
        TimeZone timeZone = this.getTimeZone();
        ReportDesignHandle design = this.executionContext.getReportDesign();
        if (document instanceof IInternalReportDocument) {
            ITreeNode tocTree = null;
            if (this.tocReader != null) {
                try {
                    tocTree = this.tocReader.readTree();
                }
                catch (IOException e) {
                    throw new EngineException("Error.FailedToLoadTOCTree", e);
                }
            }
            if (tocTree != null) {
                LogicalPageSequence visiblePages = this.loadVisiblePages();
                if (visiblePages != null) {
                    return new TOCView(tocTree, design, ulocale, timeZone, format, new VisiblePageFilter(document, visiblePages));
                }
                return new TOCView(tocTree, design, ulocale, timeZone, format);
            }
        }
        return TOCView.EMPTY_TOC_VIEW;
    }

    public ITreeNode getRawTOCTree() {
        this.loadDocument();
        ITreeNode tocTree = null;
        if (this.tocReader != null) {
            try {
                tocTree = this.tocReader.readTree();
            }
            catch (IOException e) {
                this.log.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
        }
        return tocTree;
    }

    @Override
    public long getTotalPage() throws EngineException {
        LogicalPageSequence visiblePages = this.loadVisiblePages();
        if (visiblePages != null) {
            return visiblePages.getTotalVisiblePageCount();
        }
        return this.reportDocument.getPageCount();
    }

    @Override
    public HashMap getParameterValues() {
        this.loadDocument();
        return (HashMap)this.executionContext.getParameterValues();
    }

    @Override
    public String getParameterDisplayText(String name) {
        this.loadDocument();
        return this.executionContext.getParameterDisplayText(name);
    }

    private long getDocumentTotalPage() {
        return this.reportDocument.getPageCount();
    }

    private long getLogicalPageNumber(long physicalPageNumber) throws EngineException {
        LogicalPageSequence visiblePages = this.loadVisiblePages();
        if (visiblePages != null) {
            return visiblePages.getLogicalPageNumber(physicalPageNumber);
        }
        return physicalPageNumber;
    }

    private ArrayList<long[]> getPhysicalPageSequence(ArrayList<long[]> logicalPages) throws EngineException {
        LogicalPageSequence visiblePages = this.loadVisiblePages();
        if (visiblePages != null) {
            long[][] pages = visiblePages.getPhysicalPageNumbers((long[][])logicalPages.toArray((T[])new long[logicalPages.size()][]));
            ArrayList<long[]> physicalPages = new ArrayList<long[]>(pages.length);
            int i = 0;
            while (i < pages.length) {
                physicalPages.add(pages[i]);
                ++i;
            }
            return physicalPages;
        }
        return logicalPages;
    }

    private ArrayList<IRenderExtension> loadRenderExtensions() throws EngineException {
        String[] extensions;
        if (!this.renderExtensionLoaded && (extensions = this.executionContext.getEngineExtensions()) != null) {
            this.renderExtensions = new ArrayList();
            EngineExtensionManager manager = this.executionContext.getEngineExtensionManager();
            String[] stringArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                String extName = stringArray[n2];
                IRenderExtension renderExtension = manager.getRenderExtension(extName);
                if (renderExtension != null) {
                    this.renderExtensions.add(renderExtension);
                }
                ++n2;
            }
        }
        return this.renderExtensions;
    }

    private void unloadRenderExtensions() {
        if (this.renderExtensions != null) {
            for (IRenderExtension renderExtension : this.renderExtensions) {
                renderExtension.close();
            }
            this.renderExtensions = null;
        }
        this.renderExtensionLoaded = false;
    }

    private LogicalPageSequence loadVisiblePages() throws EngineException {
        if (!this.visiblePageLoaded) {
            ArrayList<IRenderExtension> renderExtensions = this.loadRenderExtensions();
            if (renderExtensions != null) {
                ArrayList<long[][]> pages = new ArrayList<long[][]>();
                for (IRenderExtension renderExtension : renderExtensions) {
                    long[][] visiblePages = renderExtension.getVisiblePages();
                    if (visiblePages == null) continue;
                    pages.add(visiblePages);
                }
                if (!pages.isEmpty()) {
                    long physicalTotalPage = this.reportDocument.getPageCount();
                    this.logicalPageSequence = new LogicalPageSequence(pages, physicalTotalPage);
                }
            }
            this.visiblePageLoaded = true;
        }
        return this.logicalPageSequence;
    }

    private void unloadVisiblePages() {
        this.visiblePageLoaded = false;
        this.logicalPageSequence = null;
    }

    protected IReportExecutor createRenderExtensionExecutor(IReportExecutor executor) throws EngineException {
        ArrayList<IRenderExtension> renderExtensions = this.loadRenderExtensions();
        if (renderExtensions != null) {
            ArrayList<IContentProcessor> processors = new ArrayList<IContentProcessor>();
            for (IRenderExtension extension : renderExtensions) {
                IContentProcessor processor = extension.getRenderProcessor();
                if (processor == null) continue;
                processors.add(processor);
            }
            if (!processors.isEmpty()) {
                return new ReportExtensionExecutor(this.executionContext, executor, processors.toArray(new IContentProcessor[processors.size()]));
            }
        }
        return executor;
    }

    static /* synthetic */ ArrayList access$0(RenderTask renderTask, ArrayList arrayList) throws EngineException {
        return renderTask.getPhysicalPageSequence(arrayList);
    }

    private static interface InnerRender {
        public void render() throws Exception;
    }

    private class LayoutPageHandler
    implements ILayoutPageHandler {
        private HTMLLayoutContext context;

        public LayoutPageHandler(HTMLLayoutContext context) {
            this.context = context;
        }

        public void onPage(long pageNumber, Object context) {
            if (RenderTask.this.pageHandler != null) {
                long totalPage = RenderTask.this.reportDocument.getPageCount();
                boolean finished = false;
                if (context instanceof HTMLLayoutContext) {
                    HTMLLayoutContext layoutContext = (HTMLLayoutContext)context;
                    finished = layoutContext.isFinished();
                } else if (context instanceof LayoutEngineContext) {
                    LayoutEngineContext layoutEngineContext = (LayoutEngineContext)context;
                    finished = this.context.isFinished() && layoutEngineContext.isFinished();
                }
                ReportDocumentInfo reportDocumentInfo = new ReportDocumentInfo(RenderTask.this.executionContext, totalPage, finished);
                RenderTask.this.pageHandler.onPage((int)pageNumber, false, reportDocumentInfo);
            }
            RenderTask.this.executionContext.getProgressMonitor().onProgress(4, (int)pageNumber);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class PageRangeRender
    implements InnerRender {
        protected ArrayList<long[]> pageSequences;

        public PageRangeRender(long[] arrayRange) {
            this.pageSequences = new ArrayList();
            this.pageSequences.add(arrayRange);
        }

        public PageRangeRender(List<long[]> pageRange) {
            this.pageSequences = new ArrayList<long[]>(pageRange);
        }

        protected boolean needPagedExecutor(List<long[]> pageSequences) {
            if ("paper-size-pagination".equals(RenderTask.this.pagination)) {
                long[] pages;
                if (pageSequences == null) {
                    return false;
                }
                return pageSequences.size() != 1 || (pages = pageSequences.get(0))[0] != 1L || pages[1] != RenderTask.this.reportDocument.getPageCount();
            }
            int pageCount = this.getPageCount();
            if (pageCount == 1) {
                return true;
            }
            IRenderOption renderOption = RenderTask.this.executionContext.getRenderOption();
            HTMLRenderOption htmlRenderOption = new HTMLRenderOption(renderOption);
            boolean htmlPagination = htmlRenderOption.getHtmlPagination();
            return htmlPagination;
        }

        protected int getPageCount() {
            int pageCount = 0;
            for (long[] pageSeg : this.pageSequences) {
                long start = pageSeg[0];
                long end = pageSeg[1];
                pageCount = (int)((long)pageCount + (end - start + 1L));
            }
            return pageCount;
        }

        protected IPageHint getPageHint(ReportPageExecutor executor, long pageNumber) {
            try {
                return executor.getLayoutPageHint(pageNumber);
            }
            catch (IOException ex) {
                RenderTask.this.executionContext.addException(new EngineException("Error.PageHintLoadingError", ex));
                return null;
            }
        }

        protected void supportHtmlPagination() {
            boolean htmlPagination;
            Object htmlPaginationObj;
            if ("paper-size-pagination".equals(RenderTask.this.pagination) && (htmlPaginationObj = RenderTask.this.renderOptions.getOption("htmlPagination")) != null && htmlPaginationObj instanceof Boolean && (htmlPagination = ((Boolean)htmlPaginationObj).booleanValue())) {
                if (RenderTask.this.renderOptions.getOption("pdfRenderOption.fitToPage") == null) {
                    RenderTask.this.renderOptions.setOption("pdfRenderOption.fitToPage", Boolean.TRUE);
                }
                RenderTask.this.renderOptions.setOption("pdfRenderOption.pagebreakPaginationOnly", Boolean.TRUE);
            }
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void render() throws Exception {
            block10: {
                block11: {
                    block9: {
                        RenderTask.this.setupRenderOption();
                        emitter = RenderTask.this.createContentEmitter();
                        this.supportHtmlPagination();
                        physicalPageSequences = RenderTask.access$0(RenderTask.this, this.pageSequences);
                        filteredTotalPage = RenderTask.this.getTotalPage();
                        totalPage = RenderTask.this.reportDocument.getPageCount();
                        if (filteredTotalPage != totalPage) {
                            RenderTask.this.executionContext.setFilteredTotalPage(filteredTotalPage);
                        }
                        iter = new PageRangeIterator(physicalPageSequences);
                        RenderTask.this.initializeContentEmitter(emitter);
                        paged = this.needPagedExecutor(physicalPageSequences);
                        pagesExecutor = new ReportPageExecutor(RenderTask.this.executionContext, physicalPageSequences, paged);
                        executor = RenderTask.this.createRenderExtensionExecutor(pagesExecutor);
                        executor = new SuppressDuplciateReportExecutor(executor);
                        executor = new LocalizedReportExecutor(RenderTask.this.executionContext, executor);
                        RenderTask.this.executionContext.setExecutor(executor);
                        layoutEngine = RenderTask.this.createReportLayoutEngine(RenderTask.this.pagination, RenderTask.this.renderOptions);
                        layoutEngine.setLocale(RenderTask.this.executionContext.getLocale());
                        layoutPageHandler = new LayoutPageHandler(((HTMLReportLayoutEngine)layoutEngine).getContext());
                        design = RenderTask.this.executionContext.getReportDesign();
                        if ("fixed layout".equals(design.getLayoutPreference())) {
                            ((HTMLReportLayoutEngine)layoutEngine).getContext().setFixedLayout(true);
                        }
                        if ("paper-size-pagination".equals(RenderTask.this.pagination)) {
                            pdfEmitter = new LayoutEngine(executor, ((HTMLReportLayoutEngine)layoutEngine).getContext(), emitter, RenderTask.this.renderOptions, RenderTask.this.executionContext, RenderTask.access$1(RenderTask.this));
                            pdfEmitter.setPageHandler(layoutPageHandler);
                            emitter = pdfEmitter;
                            RenderTask.this.initializeContentEmitter(emitter);
                        } else {
                            layoutEngine.setPageHandler(layoutPageHandler);
                        }
                        RenderTask.this.startRender();
                        report = executor.execute();
                        emitter.start(report);
                        layoutEngine.setTotalPageCount(RenderTask.this.getTotalPage());
                        if (!"paper-size-pagination".equals(RenderTask.this.pagination)) break block9;
                        if (paged) ** GOTO lbl50
                        pageNumber = iter.next();
                        if (pageNumber != 1L) {
                            layoutEngine.setLayoutPageHint(this.getPageHint(pagesExecutor, pageNumber));
                        }
                        this.setFilteredPageNumber(filteredTotalPage, totalPage, pageNumber);
                        layoutEngine.layout(executor, report, emitter, true);
                        break block10;
lbl-1000:
                        // 1 sources

                        {
                            pageNumber = iter.next();
                            pageHint = this.getPageHint(pagesExecutor, pageNumber);
                            layoutEngine.setLayoutPageHint(pageHint);
                            pageExecutor = executor.getNextChild();
                            if (pageExecutor == null) continue;
                            this.setFilteredPageNumber(filteredTotalPage, totalPage, pageNumber);
                            pExecutor = new ReportExecutorWrapper(pageExecutor, executor);
                            layoutEngine.layout(pExecutor, report, emitter, false);
lbl50:
                            // 3 sources

                            ** while (iter.hasNext())
                        }
lbl51:
                        // 1 sources

                        break block10;
                    }
                    if (!"page-break-pagination".equals(RenderTask.this.pagination)) break block11;
                    if (paged) ** GOTO lbl69
                    pageNumber = iter.next();
                    if (pageNumber != 1L) {
                        layoutEngine.setLayoutPageHint(this.getPageHint(pagesExecutor, pageNumber));
                    }
                    this.setFilteredPageNumber(filteredTotalPage, totalPage, pageNumber);
                    layoutEngine.layout(executor, report, emitter, false);
                    break block10;
lbl-1000:
                    // 1 sources

                    {
                        pageNumber = iter.next();
                        pageHint = this.getPageHint(pagesExecutor, pageNumber);
                        layoutEngine.setLayoutPageHint(pageHint);
                        pageExecutor = executor.getNextChild();
                        if (pageExecutor == null) continue;
                        this.setFilteredPageNumber(filteredTotalPage, totalPage, pageNumber);
                        pExecutor = new ReportExecutorWrapper(pageExecutor, executor);
                        layoutEngine.layout(pExecutor, report, emitter, false);
lbl69:
                        // 3 sources

                        ** while (iter.hasNext())
                    }
lbl70:
                    // 1 sources

                    break block10;
                }
                if ("no-pagination".equals(RenderTask.this.pagination)) {
                    layoutEngine.layout(executor, report, emitter, false);
                }
            }
            RenderTask.this.outputPageCount = layoutEngine.getPageCount();
            layoutEngine.close();
            emitter.end(report);
            RenderTask.this.closeRender();
            executor.close();
        }

        private void setFilteredPageNumber(long filteredTotalPage, long totalPage, long pageNumber) throws EngineException {
            if (filteredTotalPage != totalPage) {
                long filteredPageNumber = RenderTask.this.getLogicalPageNumber(pageNumber);
                RenderTask.this.executionContext.setFilteredPageNumber(filteredPageNumber);
            }
        }
    }

    private static class ReportExecutorWrapper
    implements IReportExecutor {
        IReportItemExecutor executor;
        IReportExecutor reportExecutor;

        ReportExecutorWrapper(IReportItemExecutor itemExecutor, IReportExecutor reportExecutor) {
            this.executor = itemExecutor;
            this.reportExecutor = reportExecutor;
        }

        public void close() throws BirtException {
            this.executor.close();
        }

        public IReportItemExecutor createPageExecutor(long pageNumber, MasterPageDesign pageDesign) throws BirtException {
            return this.reportExecutor.createPageExecutor(pageNumber, pageDesign);
        }

        public IReportContent execute() throws BirtException {
            return this.reportExecutor.execute();
        }

        public IReportItemExecutor getNextChild() throws BirtException {
            return this.executor.getNextChild();
        }

        public boolean hasNextChild() throws BirtException {
            return this.executor.hasNextChild();
        }
    }

    protected class ReportletRender
    implements InnerRender {
        private long offset;

        ReportletRender(long offset) {
            this.offset = offset;
        }

        public void render() throws Exception {
            RenderTask.this.setupRenderOption();
            IContentEmitter emitter = RenderTask.this.createContentEmitter();
            IReportExecutor executor = new ReportletExecutor(RenderTask.this.executionContext, this.offset);
            executor = RenderTask.this.createRenderExtensionExecutor(executor);
            executor = new SuppressDuplciateReportExecutor(executor);
            executor = new LocalizedReportExecutor(RenderTask.this.executionContext, executor);
            RenderTask.this.executionContext.setExecutor(executor);
            RenderTask.this.initializeContentEmitter(emitter);
            IReportLayoutEngine layoutEngine = RenderTask.this.createReportLayoutEngine(RenderTask.this.pagination, RenderTask.this.renderOptions);
            layoutEngine.setPageHandler(new LayoutPageHandler(((HTMLReportLayoutEngine)layoutEngine).getContext()));
            layoutEngine.setLocale(RenderTask.this.executionContext.getLocale());
            if ("paper-size-pagination".equals(RenderTask.this.pagination)) {
                emitter = new LayoutEngine(executor, ((HTMLReportLayoutEngine)layoutEngine).getContext(), emitter, RenderTask.this.renderOptions, RenderTask.this.executionContext, RenderTask.this.getDocumentTotalPage());
            }
            RenderTask.this.startRender();
            IReportContent report = executor.execute();
            emitter.start(report);
            layoutEngine.layout(executor, report, emitter, false);
            layoutEngine.close();
            emitter.end(report);
            RenderTask.this.closeRender();
            executor.close();
            RenderTask.this.outputPageCount = layoutEngine.getPageCount();
        }
    }
}

