/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.compound.IArchiveFile;
import org.eclipse.birt.core.framework.URLClassLoader;
import org.eclipse.birt.report.engine.api.DataExtractionFormatInfo;
import org.eclipse.birt.report.engine.api.EmitterInfo;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IDataExtractionTask;
import org.eclipse.birt.report.engine.api.IDatasetPreviewTask;
import org.eclipse.birt.report.engine.api.IDocumentWriter;
import org.eclipse.birt.report.engine.api.IEngineTask;
import org.eclipse.birt.report.engine.api.IGetParameterDefinitionTask;
import org.eclipse.birt.report.engine.api.IRenderTask;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.IRunTask;
import org.eclipse.birt.report.engine.api.IRunnable;
import org.eclipse.birt.report.engine.api.IStatusHandler;
import org.eclipse.birt.report.engine.api.impl.EngineLogger;
import org.eclipse.birt.report.engine.api.impl.LinkedObjectManager;
import org.eclipse.birt.report.engine.api.impl.ReportDocumentReader;
import org.eclipse.birt.report.engine.api.impl.ReportEngineHelper;
import org.eclipse.birt.report.engine.api.impl.ReportRunnable;
import org.eclipse.birt.report.engine.data.DataEngineFactory;
import org.eclipse.birt.report.engine.extension.engine.IReportEngineExtension;
import org.eclipse.birt.report.engine.extension.engine.IReportEngineExtensionFactory;
import org.eclipse.birt.report.engine.util.SecurityUtil;
import org.eclipse.birt.report.model.api.IResourceLocator;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.mozilla.javascript.ScriptableObject;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportEngine
implements IReportEngine {
    public static final String PROPERTYSEPARATOR = File.pathSeparator;
    protected static Logger logger = Logger.getLogger(ReportEngine.class.getName());
    protected EngineConfig config;
    protected ReportEngineHelper helper;
    protected ScriptableObject rootScope;
    protected URLClassLoader engineClassLoader;
    private LinkedObjectManager<ReportDocumentReader> openedDocuments;
    private EngineExtensionManager extensionManager = new EngineExtensionManager();
    private String version;
    private Map<String, Object> beans;

    public ReportEngine(EngineConfig config) {
        if (config == null) {
            throw new NullPointerException("config is null");
        }
        this.config = config;
        this.beans = new HashMap<String, Object>();
        this.mergeConfigToAppContext();
        this.intializeLogger();
        logger.log(Level.FINE, "ReportEngine created. EngineConfig: {0} ", config);
        this.helper = new ReportEngineHelper(this);
        this.openedDocuments = new LinkedObjectManager();
        IStatusHandler handler = config.getStatusHandler();
        if (handler != null) {
            handler.initialize();
        }
    }

    private void mergeConfigToAppContext() {
        this.mergeConfigProperty("PARENT_CLASSLOADER");
        this.mergeSystemProperty("webapplication.projectclasspath");
        this.mergeSystemProperty("user.projectclasspath");
        this.mergeSystemProperty("workspace.projectclasspath");
    }

    private void mergeConfigProperty(String property) {
        Object value;
        HashMap appContext = this.config.getAppContext();
        if (!appContext.containsKey(property) && (value = this.config.getProperty(property)) != null) {
            appContext.put(property, value);
        }
    }

    private void mergeSystemProperty(String property) {
        HashMap appContext = this.config.getAppContext();
        if (!appContext.containsKey(property)) {
            Object value = this.config.getProperty(property);
            if (value == null) {
                value = SecurityUtil.getSystemProperty(property);
            }
            if (value != null) {
                appContext.put(property, value);
            }
        }
    }

    private void intializeLogger() {
        Logger logger = null;
        String dest = null;
        String file = null;
        Level level = null;
        int rollingSize = 0;
        int maxBackupIndex = 1;
        if (this.config != null) {
            logger = this.config.getLogger();
            dest = this.config.getLogDirectory();
            file = this.config.getLogFile();
            level = this.config.getLogLevel();
            rollingSize = this.config.getLogRollingSize();
            maxBackupIndex = this.config.getLogMaxBackupIndex();
        }
        EngineLogger.startEngineLogging(logger, dest, file, level, rollingSize, maxBackupIndex);
    }

    @Override
    public Object getRootScope() {
        return this.rootScope;
    }

    private void registerBeans(Map<String, Object> map) {
        Set<Map.Entry<String, Object>> attributes = map.entrySet();
        for (Map.Entry<String, Object> attribute : attributes) {
            if (attribute.getKey() == null) continue;
            this.beans.put(attribute.getKey(), attribute.getValue());
        }
    }

    @Override
    public void changeLogLevel(Level newLevel) {
        EngineLogger.changeLogLevel(newLevel);
    }

    @Override
    public EngineConfig getConfig() {
        return this.config;
    }

    @Override
    public IReportRunnable openReportDesign(String designName) throws EngineException {
        logger.log(Level.FINE, "ReportEngine.openReportDesign: designName={0} ", designName);
        IResourceLocator locator = this.config.getResourceLocator();
        return this.helper.openReportDesign(designName, locator);
    }

    @Override
    public IReportRunnable openReportDesign(ReportDesignHandle designHandle) throws EngineException {
        logger.log(Level.FINE, "ReportEngine.openReportDesign: designHandle={0} ", designHandle);
        return this.helper.openReportDesign(designHandle);
    }

    @Override
    public IReportRunnable openReportDesign(InputStream designStream) throws EngineException {
        logger.log(Level.FINE, "ReportEngine.openReportDesign: designStream={0} ", designStream);
        return this.helper.openReportDesign(designStream);
    }

    @Override
    public IReportRunnable openReportDesign(String name, InputStream designStream) throws EngineException {
        logger.log(Level.FINE, "ReportEngine.openReportDesign: name={0}, designStream={1} ", new Object[]{name, designStream});
        return this.helper.openReportDesign(name, designStream);
    }

    @Override
    public IRunAndRenderTask createRunAndRenderTask(IReportRunnable reportRunnable) {
        logger.log(Level.FINE, "ReportEngine.createRunAndRenderTask: reportRunnable={0} ", reportRunnable);
        return this.helper.createRunAndRenderTask(reportRunnable);
    }

    @Override
    public IGetParameterDefinitionTask createGetParameterDefinitionTask(IRunnable reportRunnable) {
        logger.log(Level.FINE, "ReportEngine.createGetParameterDefinitionTask: reportRunnable={0} ", reportRunnable);
        return this.helper.createGetParameterDefinitionTask((ReportRunnable)reportRunnable);
    }

    @Override
    public IGetParameterDefinitionTask createGetParameterDefinitionTask(IReportRunnable reportRunnable) {
        logger.log(Level.FINE, "ReportEngine.createGetParameterDefinitionTask: reportRunnable={0} ", reportRunnable);
        return this.helper.createGetParameterDefinitionTask((ReportRunnable)reportRunnable);
    }

    @Override
    public String[] getSupportedFormats() {
        return this.helper.getSupportedFormats();
    }

    @Override
    public EmitterInfo[] getEmitterInfo() {
        return this.helper.getEmitterInfo();
    }

    @Override
    public String getMIMEType(String format) {
        return this.helper.getMIMEType(format);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        logger.fine("ReportEngine.destroy");
        this.rootScope = null;
        this.helper = null;
        LinkedObjectManager<ReportDocumentReader> linkedObjectManager = this.openedDocuments;
        synchronized (linkedObjectManager) {
            for (ReportDocumentReader document : this.openedDocuments) {
                logger.log(Level.WARNING, "{0} is not closed.", document.getName());
                document.setEngineCacheEntry(null);
                document.close();
            }
            this.openedDocuments.clear();
        }
        IStatusHandler handler = this.config.getStatusHandler();
        if (handler != null) {
            handler.finish();
        }
        if (this.extensionManager != null) {
            this.extensionManager.close();
            this.extensionManager = null;
        }
        EngineLogger.stopEngineLogging();
        if (this.engineClassLoader != null) {
            this.engineClassLoader.close();
        }
    }

    @Override
    public IRunTask createRunTask(IReportRunnable reportRunnable) {
        logger.log(Level.FINE, "ReportEngine.createRunTask: reportRunnable={0} ", reportRunnable);
        return this.helper.createRunTask(reportRunnable);
    }

    @Override
    public IRenderTask createRenderTask(IReportDocument reportDocument) {
        logger.log(Level.FINE, "ReportEngine.createRenderTask: reportDocument={0} ", reportDocument);
        return this.helper.createRenderTask(reportDocument);
    }

    @Override
    public IRenderTask createRenderTask(IReportDocument reportDocument, IReportRunnable reportRunnable) {
        logger.log(Level.FINE, "ReportEngine.createRenderTask: reportDocument={0}, runnable={1}", new Object[]{reportDocument, reportRunnable});
        return this.helper.createRenderTask(reportDocument, reportRunnable);
    }

    @Override
    public IReportDocument openReportDocument(String fileName) throws EngineException {
        logger.log(Level.FINE, "ReportEngine.openReportDocument: fileName={0} ", fileName);
        return this.helper.openReportDocument(fileName);
    }

    @Override
    public IDataExtractionTask createDataExtractionTask(IReportDocument reportDocument) {
        logger.log(Level.FINE, "ReportEngine.createDataExtractionTask: reportDocument={0} ", reportDocument);
        return this.helper.createDataExtractionTask(reportDocument);
    }

    @Override
    public void shutdown() {
        this.destroy();
    }

    @Override
    public IReportDocument openReportDocument(String systemId, String fileName) throws EngineException {
        logger.log(Level.FINE, "ReportEngine.openReportDocument: systemID={0}, file={1} ", new Object[]{systemId, fileName});
        return this.openReportDocument(systemId, fileName, (IResourceLocator)null);
    }

    @Override
    public IReportRunnable openReportDesign(String designName, IResourceLocator locator) throws EngineException {
        logger.log(Level.FINE, "ReportEngine.openReportDesign: design={0}, locator={1} ", new Object[]{designName, locator});
        return this.helper.openReportDesign(designName, locator);
    }

    @Override
    public IReportRunnable openReportDesign(String name, InputStream designStream, IResourceLocator locator) throws EngineException {
        logger.log(Level.FINE, "ReportEngine.openReportDesign: name={0}, designStream={1}, locator={2} ", new Object[]{name, designStream, locator});
        return this.helper.openReportDesign(name, designStream, locator);
    }

    @Override
    public IReportRunnable openReportDesign(String name, InputStream designStream, Map options) throws EngineException {
        logger.log(Level.FINE, "ReportEngine.openReportDesign: name={0}, designStream={1}, options={3} ", new Object[]{name, designStream, options});
        return this.helper.openReportDesign(name, designStream, options);
    }

    @Override
    public IReportDocument openReportDocument(String fileName, IResourceLocator locator) throws EngineException {
        logger.log(Level.FINE, "ReportEngine.openReportDocument: file={0}, locator={1} ", new Object[]{fileName, locator});
        return this.openReportDocument(fileName, fileName, locator);
    }

    @Override
    public IReportDocument openReportDocument(String systemId, String fileName, IResourceLocator locator) throws EngineException {
        logger.log(Level.FINE, "ReportEngine.openReportDocument: systemId={0}, file={1}, locator={2} ", new Object[]{systemId, fileName, locator});
        return this.helper.openReportDocument(systemId, fileName, locator);
    }

    @Override
    public IReportDocument openReportDocument(String systemId, String fileName, Map options) throws EngineException {
        logger.log(Level.FINE, "ReportEngine.openReportDocument: systemId={0}, file={1}, options={2} ", new Object[]{systemId, fileName, options});
        return this.helper.openReportDocument(systemId, fileName, options);
    }

    @Override
    public IReportDocument openReportDocument(String systemId, IDocArchiveReader reader, Map options) throws EngineException {
        logger.log(Level.FINE, "ReportEngine.openReportDocument: systemId={0}, reader={1}, options={2} ", new Object[]{systemId, reader, options});
        return this.helper.openReportDocument(systemId, reader, options);
    }

    @Override
    public IDocumentWriter openDocumentWriter(IArchiveFile file) throws EngineException {
        logger.log(Level.FINE, "ReportEngine.openDocumentWriter: archive={0} ", new Object[]{file});
        return this.helper.openDocumentWriter(file);
    }

    @Override
    public Logger getLogger() {
        return logger;
    }

    @Override
    public void setLogger(Logger logger) {
        if (logger != null) {
            EngineLogger.setLogger(logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoader getEngineClassLoader() {
        if (this.engineClassLoader != null) {
            return this.engineClassLoader;
        }
        ReportEngine reportEngine = this;
        synchronized (reportEngine) {
            if (this.engineClassLoader == null) {
                this.engineClassLoader = this.createEngineClassLoader();
            }
        }
        return this.engineClassLoader;
    }

    private URLClassLoader createEngineClassLoader() {
        ArrayList<URL> urls = new ArrayList<URL>();
        String[] CLASS_PATHES = new String[]{"webapplication.projectclasspath", "user.projectclasspath", "workspace.projectclasspath"};
        HashMap appContext = this.getAppContext();
        int i = 0;
        while (i < CLASS_PATHES.length) {
            String[] jars;
            String classPath;
            String classPathName = CLASS_PATHES[i];
            Object propValue = appContext.get(classPathName);
            if (propValue instanceof String && (classPath = (String)propValue).length() != 0 && (jars = classPath.split(PROPERTYSEPARATOR, -1)) != null && jars.length != 0) {
                int j = 0;
                while (j < jars.length) {
                    File file = new File(jars[j]);
                    try {
                        urls.add(file.toURI().toURL());
                    }
                    catch (MalformedURLException e) {
                        logger.log(Level.WARNING, e.getMessage(), e);
                    }
                    ++j;
                }
            }
            ++i;
        }
        ClassLoader appContextClassLoader = this.getAppContextClassLoader();
        return new URLClassLoader(urls.toArray(new URL[urls.size()]), appContextClassLoader);
    }

    private HashMap getAppContext() {
        return this.config.getAppContext();
    }

    private ClassLoader getAppContextClassLoader() {
        HashMap appContext = this.getAppContext();
        Object appLoader = appContext.get("PARENT_CLASSLOADER");
        if (appLoader instanceof ClassLoader) {
            return (ClassLoader)appLoader;
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return IReportEngine.class.getClassLoader();
            }
        });
    }

    @Override
    public DataExtractionFormatInfo[] getDataExtractionFormatInfo() {
        return this.helper.getDataExtractionFormatInfo();
    }

    public IReportEngineExtension getEngineExtension(String name) {
        if (this.extensionManager != null) {
            return this.extensionManager.getExtension(name);
        }
        return null;
    }

    public String[] getEngineExtensions(ReportRunnable runnable) {
        if (this.extensionManager != null) {
            return this.extensionManager.getExtensions(runnable);
        }
        return null;
    }

    public Iterator<ReportDocumentReader> getOpenedDocuments() {
        return this.openedDocuments.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cacheOpenedDocument(ReportDocumentReader document) {
        LinkedObjectManager<ReportDocumentReader> linkedObjectManager = this.openedDocuments;
        synchronized (linkedObjectManager) {
            LinkedObjectManager.LinkedEntry<ReportDocumentReader> entry = this.openedDocuments.add(document);
            document.setEngineCacheEntry(entry);
        }
    }

    @Override
    public String getVersion() {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.birt.report.engine");
        return bundle.getVersion().toString();
    }

    @Override
    public IEngineTask createEngineTask(String taskName) throws EngineException {
        IReportEngineExtension extension;
        String extName = taskName;
        int index = taskName.lastIndexOf(46);
        if (index != -1) {
            extName = taskName.substring(0, index);
            taskName = taskName.substring(index + 1);
        }
        if ((extension = this.extensionManager.getExtension(extName)) != null) {
            return extension.createEngineTask(taskName);
        }
        return null;
    }

    public DataEngineFactory getDataEngineFactory() {
        return DataEngineFactory.getInstance();
    }

    @Override
    public IDatasetPreviewTask createDatasetPreviewTask() throws EngineException {
        logger.log(Level.FINE, "createDatasetPreviewTask");
        return this.helper.createDatasetPreviewTask();
    }

    private class EngineExtensionManager {
        HashMap<String, IReportEngineExtension> exts = new HashMap();

        EngineExtensionManager() {
            IExtension[] extensions;
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.birt.core.FactoryService");
            IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    String type = element.getAttribute("type");
                    if ("org.eclipse.birt.report.engine.extension".equals(type)) {
                        try {
                            Object factoryObject = element.createExecutableExtension("class");
                            if (factoryObject instanceof IReportEngineExtensionFactory) {
                                IReportEngineExtensionFactory factory = (IReportEngineExtensionFactory)factoryObject;
                                IReportEngineExtension engineExtension = factory.createExtension(ReportEngine.this);
                                this.exts.put(engineExtension.getExtensionName(), engineExtension);
                            }
                        }
                        catch (CoreException ex) {
                            logger.log(Level.WARNING, "can not load the engine extension factory", ex);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }

        IReportEngineExtension getExtension(String name) {
            if (this.exts.containsKey(name)) {
                return this.exts.get(name);
            }
            return null;
        }

        String[] getExtensions(IReportRunnable runnable) {
            ArrayList<String> extensions = new ArrayList<String>();
            for (Map.Entry<String, IReportEngineExtension> entry : this.exts.entrySet()) {
                String extName = entry.getKey();
                IReportEngineExtension ext = entry.getValue();
                if (!ext.needExtension(runnable)) continue;
                extensions.add(extName);
            }
            return extensions.toArray(new String[extensions.size()]);
        }

        void close() {
            for (IReportEngineExtension ext : this.exts.values()) {
                if (ext == null) continue;
                ext.close();
            }
            this.exts.clear();
        }
    }
}

