/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.data.dte;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBasePreparedQuery;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IBaseQueryResults;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.querydefn.BaseQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.ICubeQueryResults;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.data.DataEngineFactory;
import org.eclipse.birt.report.engine.data.IDataEngine;
import org.eclipse.birt.report.engine.data.dte.AbstractDataEngine;
import org.eclipse.birt.report.engine.data.dte.CubeResultSet;
import org.eclipse.birt.report.engine.data.dte.QueryResultSet;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.ir.Report;

public class DteDataEngine
extends AbstractDataEngine {
    private boolean needCache;
    protected HashMap<String, String> rsetRelations = new HashMap();
    protected HashMap<String, String> rsetRelations2 = new HashMap();
    private StringBuffer keyBuffer = new StringBuffer();

    public DteDataEngine(DataEngineFactory factory, ExecutionContext context, boolean needCache) throws BirtException {
        super(factory, context);
        this.needCache = needCache;
        try {
            DataSessionContext dteSessionContext = new DataSessionContext(3, context.getDesign(), context.getScriptContext(), context.getApplicationClassLoader());
            dteSessionContext.setAppContext(context.getAppContext());
            DataEngineContext dteEngineContext = dteSessionContext.getDataEngineContext();
            dteEngineContext.setLocale(context.getLocale());
            dteEngineContext.setTimeZone(context.getTimeZone());
            String tempDir = this.getTempDir(context);
            if (tempDir != null) {
                dteEngineContext.setTmpdir(tempDir);
            }
            this.dteSession = DataRequestSession.newSession((DataSessionContext)dteSessionContext);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "can not create the DTE data engine", ex);
        }
    }

    protected DteDataEngine(DataEngineFactory factory, ExecutionContext context, Object obj) throws BirtException {
        super(factory, context);
    }

    protected IBaseResultSet doExecuteQuery(IBaseResultSet parentResultSet, IQueryDefinition query, Object queryOwner, boolean useCache) throws BirtException {
        IPreparedQuery pQuery = (IPreparedQuery)this.queryMap.get(query);
        if (pQuery == null) {
            return null;
        }
        ScriptContext scriptContext = this.context.getScriptContext();
        IBaseQueryResults dteResults = null;
        boolean needExecute = this.queryCache.needExecute(query, queryOwner, useCache);
        if (!needExecute) {
            dteResults = this.getCachedQueryResult((IBaseQueryDefinition)query, parentResultSet);
        }
        if (dteResults == null) {
            if (this.needCache) {
                ((BaseQueryDefinition)query).setCacheQueryResults(true);
            }
            dteResults = parentResultSet == null ? this.dteSession.execute((IBasePreparedQuery)pQuery, null, scriptContext) : this.dteSession.execute((IBasePreparedQuery)pQuery, parentResultSet.getQueryResults(), scriptContext);
            this.queryCache.putCachedQuery(query, dteResults.getID());
        }
        QueryResultSet resultSet = parentResultSet == null ? new QueryResultSet(this, this.context, query, (IQueryResults)dteResults) : new QueryResultSet(this, this.context, parentResultSet, query, (IQueryResults)dteResults);
        if (this.needCache) {
            this.cacheResultID(parentResultSet, (IDataQueryDefinition)query, resultSet);
        }
        return resultSet;
    }

    protected IBaseResultSet doExecuteCube(IBaseResultSet parentResultSet, ICubeQueryDefinition query, Object queryOwner, boolean useCache) throws BirtException {
        CubeResultSet resultSet;
        ICubeQueryResults dteResults;
        IBasePreparedQuery pQuery;
        if (useCache) {
            Object obj = this.cachedQueryToResults.get(query);
            String rsetId = obj == null ? null : String.valueOf(obj);
            query.setQueryResultsID(rsetId);
        } else {
            query.setQueryResultsID(null);
        }
        if (this.needCache) {
            ICubeQueryDefinition cubeQuery = query;
            cubeQuery.setCacheQueryResults(true);
            cubeQuery.setNeedAccessFactTable(true);
        }
        if ((pQuery = (IBasePreparedQuery)this.queryMap.get(query)) == null) {
            throw new EngineException("Error.PreparedQueryNotFoundError", query);
        }
        ScriptContext scriptContext = this.context.getScriptContext();
        if (parentResultSet == null) {
            dteResults = (ICubeQueryResults)this.dteSession.execute(pQuery, null, scriptContext);
            resultSet = new CubeResultSet(this, this.context, query, dteResults);
        } else {
            dteResults = (ICubeQueryResults)this.dteSession.execute(pQuery, parentResultSet.getQueryResults(), scriptContext);
            resultSet = new CubeResultSet((IDataEngine)this, this.context, parentResultSet, query, dteResults);
        }
        this.cachedQueryToResults.put(query, dteResults.getID());
        if (this.needCache) {
            this.cacheResultID(parentResultSet, (IDataQueryDefinition)query, resultSet);
        }
        return resultSet;
    }

    protected void doPrepareQuery(Report report, Map appContext) {
        this.queryIDMap.putAll(report.getQueryIDs());
        super.doPrepareQuery(report, appContext);
    }

    protected void cacheResultID(IBaseResultSet parentResultSet, IDataQueryDefinition query, IBaseResultSet resultSet) throws BirtException {
        String pRsetId = null;
        String rawId = "-1";
        String rowId = "-1";
        if (parentResultSet != null) {
            if (parentResultSet instanceof QueryResultSet) {
                QueryResultSet qrs = (QueryResultSet)parentResultSet;
                pRsetId = qrs.getQueryResultsID();
                rowId = String.valueOf(qrs.getRowIndex());
            } else {
                CubeResultSet crs = (CubeResultSet)parentResultSet;
                pRsetId = crs.getQueryResultsID();
                rowId = crs.getCellIndex();
            }
            rawId = parentResultSet.getRawID();
        }
        String queryID = (String)this.queryIDMap.get(query);
        this.addResultID(pRsetId, rawId, queryID, resultSet.getQueryResults().getID(), rowId);
    }

    protected void addResultID(String pRsetId, String rawId, String queryId, String rsetId, String rowId) {
        this.keyBuffer.setLength(0);
        this.keyBuffer.append(pRsetId);
        this.keyBuffer.append(".");
        this.keyBuffer.append(rawId);
        this.keyBuffer.append(".");
        this.keyBuffer.append(queryId);
        this.rsetRelations.put(this.keyBuffer.toString(), rsetId);
        this.keyBuffer.setLength(0);
        this.keyBuffer.append(pRsetId);
        this.keyBuffer.append(".");
        this.keyBuffer.append(rowId);
        this.keyBuffer.append(".");
        this.keyBuffer.append(queryId);
        this.rsetRelations2.put(this.keyBuffer.toString(), rsetId);
    }

    public String getResultID(String parent, String rawId, String queryId) {
        this.keyBuffer.setLength(0);
        this.keyBuffer.append(parent);
        this.keyBuffer.append(".");
        this.keyBuffer.append(rawId);
        this.keyBuffer.append(".");
        this.keyBuffer.append(queryId);
        String rsetId = this.rsetRelations.get(this.keyBuffer.toString());
        return rsetId;
    }

    public String getResultIDByRowID(String parent, String rowId, String queryId) {
        this.keyBuffer.setLength(0);
        this.keyBuffer.append(parent);
        this.keyBuffer.append(".");
        this.keyBuffer.append(rowId);
        this.keyBuffer.append(".");
        this.keyBuffer.append(queryId);
        String rsetId = this.rsetRelations2.get(this.keyBuffer.toString());
        return rsetId;
    }
}

