/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.nLayout.area.style;

import com.lowagie.text.Image;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.birt.report.engine.nLayout.area.style.AreaConstants;
import org.eclipse.birt.report.engine.util.ResourceLocatorWrapper;
import org.eclipse.birt.report.engine.util.SvgFile;
import org.w3c.dom.css.CSSValue;

public class BackgroundImageInfo
extends AreaConstants {
    protected int xOffset = 0;
    protected int yOffset = 0;
    protected int repeatedMode;
    protected int width = 0;
    protected int height = 0;
    protected String url;
    protected byte[] imageData;
    private Image image;
    private ResourceLocatorWrapper rl = null;

    public BackgroundImageInfo(String url, int repeatedMode, int xOffset, int yOffset, int height, int width, ResourceLocatorWrapper rl) {
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.repeatedMode = repeatedMode;
        this.width = width;
        this.height = height;
        this.url = url;
        this.rl = rl;
        this.prepareImageByteArray();
    }

    public BackgroundImageInfo(BackgroundImageInfo bgi) {
        this.xOffset = bgi.xOffset;
        this.yOffset = bgi.yOffset;
        this.repeatedMode = bgi.repeatedMode;
        this.width = bgi.width;
        this.height = bgi.height;
        this.url = bgi.url;
        this.imageData = bgi.imageData;
        this.image = bgi.image;
        this.rl = bgi.rl;
    }

    public BackgroundImageInfo(String url, CSSValue mode, int xOffset, int yOffset, int height, int width, ResourceLocatorWrapper rl) {
        this(url, (Integer)repeatMap.get(mode), xOffset, yOffset, height, width, rl);
    }

    public BackgroundImageInfo(String url, int height, int width, ResourceLocatorWrapper rl) {
        this(url, 0, 0, 0, height, width, rl);
    }

    public void setResourceLocator(ResourceLocatorWrapper rl) {
        this.rl = rl;
    }

    private void prepareImageByteArray() {
        if (this.rl == null) {
            InputStream in = null;
            try {
                try {
                    in = new URL(this.url).openStream();
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    byte[] buffer = new byte[1024];
                    int size = in.read(buffer);
                    while (size != -1) {
                        out.write(buffer, 0, size);
                        size = in.read(buffer);
                    }
                    this.imageData = out.toByteArray();
                    out.close();
                }
                catch (IOException iOException) {
                    this.imageData = null;
                    this.image = null;
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    return;
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        } else {
            try {
                this.imageData = this.rl.findResource(new URL(this.url));
            }
            catch (MalformedURLException malformedURLException) {
                this.imageData = null;
                this.image = null;
                return;
            }
        }
        try {
            this.image = Image.getInstance((byte[])this.imageData);
        }
        catch (Exception exception) {
            try {
                this.imageData = SvgFile.transSvgToArray(new ByteArrayInputStream(this.imageData));
                this.image = Image.getInstance((byte[])this.imageData);
            }
            catch (Exception exception2) {
                this.imageData = null;
                this.image = null;
            }
        }
    }

    public Image getImageInstance() {
        return this.image;
    }

    public int getXOffset() {
        return this.xOffset;
    }

    public void setYOffset(int y) {
        this.yOffset = y;
    }

    public void setXOffset(int x) {
        this.xOffset = x;
    }

    public int getYOffset() {
        return this.yOffset;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getRepeatedMode() {
        return this.repeatedMode;
    }

    public String getUrl() {
        return this.url;
    }

    public byte[] getImageData() {
        return this.imageData;
    }
}

