/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.script.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.script.IBaseDataSetEventHandler;
import org.eclipse.birt.data.engine.api.script.IDataRow;
import org.eclipse.birt.data.engine.api.script.IDataSetInstanceHandle;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.script.eventhandler.IDataSetEventHandler;
import org.eclipse.birt.report.engine.api.script.eventhandler.IScriptedDataSetEventHandler;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.script.internal.DataSetRow;
import org.eclipse.birt.report.engine.script.internal.DtEScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.ScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.ScriptTextUtil;
import org.eclipse.birt.report.engine.script.internal.instance.DataSetInstance;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ModuleUtil;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public class DataSetScriptExecutor
extends DtEScriptExecutor
implements IBaseDataSetEventHandler {
    private static final String ON_FETCH = "onFetch";
    protected DataSetHandle dataSetHandle;
    protected IDataSetEventHandler eventHandler;
    private boolean useOnFetchEventHandler = false;
    private boolean useAfterCloseEventHandler = false;
    private boolean useAfterOpenEventHandler = false;
    private boolean useBeforeOpenEventHandler = false;
    private boolean useBeforeCloseEventHandler = false;
    private final String beforeOpenMethodID;
    private final String beforeCloseMethodID;
    private final String afterOpenMethodID;
    private final String afterCloseMethodID;
    private final String onFetchMethodID;
    private static Map<IDataSetInstanceHandle, Scriptable> scopeCache = new HashMap<IDataSetInstanceHandle, Scriptable>();

    public DataSetScriptExecutor(DataSetHandle dataSetHandle, ExecutionContext context) throws BirtException {
        super(context);
        this.dataSetHandle = dataSetHandle;
        String className = dataSetHandle.getEventHandlerClass();
        this.initEventHandler(className);
        this.useOnFetchEventHandler = ScriptTextUtil.isNullOrComments(dataSetHandle.getOnFetch());
        this.useAfterCloseEventHandler = ScriptTextUtil.isNullOrComments(dataSetHandle.getAfterClose());
        this.useAfterOpenEventHandler = ScriptTextUtil.isNullOrComments(dataSetHandle.getAfterOpen());
        this.useBeforeOpenEventHandler = ScriptTextUtil.isNullOrComments(dataSetHandle.getBeforeOpen());
        this.useBeforeCloseEventHandler = ScriptTextUtil.isNullOrComments(dataSetHandle.getBeforeClose());
        this.beforeOpenMethodID = ModuleUtil.getScriptUID((Object)dataSetHandle.getPropertyHandle("beforeOpen"));
        this.beforeCloseMethodID = ModuleUtil.getScriptUID((Object)dataSetHandle.getPropertyHandle("beforeClose"));
        this.afterOpenMethodID = ModuleUtil.getScriptUID((Object)dataSetHandle.getPropertyHandle("afterOpen"));
        this.afterCloseMethodID = ModuleUtil.getScriptUID((Object)dataSetHandle.getPropertyHandle("afterClose"));
        this.onFetchMethodID = ModuleUtil.getScriptUID((Object)dataSetHandle.getPropertyHandle(ON_FETCH));
    }

    protected void initEventHandler(String className) {
        if (className != null) {
            try {
                this.eventHandler = (IDataSetEventHandler)DataSetScriptExecutor.getInstance(className, this.context);
            }
            catch (ClassCastException e) {
                DataSetScriptExecutor.addClassCastException(this.context, e, (DesignElementHandle)this.dataSetHandle, IScriptedDataSetEventHandler.class);
            }
            catch (EngineException e) {
                DataSetScriptExecutor.addException(this.context, (Exception)((Object)e), (DesignElementHandle)this.dataSetHandle);
            }
        }
    }

    public void handleBeforeOpen(IDataSetInstanceHandle dataSet) {
        if (this.reportContext == null) {
            return;
        }
        try {
            Scriptable scope;
            ScriptExecutor.ScriptStatus status;
            if (!this.useBeforeOpenEventHandler && (status = this.handleJS(scope = this.getScriptScope(dataSet), dataSet.getName(), "beforeOpen", this.dataSetHandle.getBeforeOpen(), this.beforeOpenMethodID)).didRun()) {
                return;
            }
            if (this.eventHandler != null) {
                this.eventHandler.beforeOpen(new DataSetInstance(dataSet), this.reportContext);
            }
        }
        catch (Exception e) {
            DataSetScriptExecutor.addException(this.context, e);
        }
    }

    public void handleBeforeClose(IDataSetInstanceHandle dataSet) {
        if (this.reportContext == null) {
            return;
        }
        try {
            Scriptable scope;
            ScriptExecutor.ScriptStatus status;
            if (!this.useBeforeCloseEventHandler && (status = this.handleJS(scope = this.getScriptScope(dataSet), dataSet.getName(), "beforeClose", this.dataSetHandle.getBeforeClose(), this.beforeCloseMethodID)).didRun()) {
                return;
            }
            if (this.eventHandler != null) {
                this.eventHandler.beforeClose(new DataSetInstance(dataSet), this.reportContext);
            }
        }
        catch (Exception e) {
            DataSetScriptExecutor.addException(this.context, e);
        }
    }

    public void handleAfterOpen(IDataSetInstanceHandle dataSet) {
        if (this.reportContext == null) {
            return;
        }
        try {
            Scriptable scope;
            ScriptExecutor.ScriptStatus status;
            if (!this.useAfterOpenEventHandler && (status = this.handleJS(scope = this.getScriptScope(dataSet), dataSet.getName(), "afterOpen", this.dataSetHandle.getAfterOpen(), this.afterOpenMethodID)).didRun()) {
                return;
            }
            if (this.eventHandler != null) {
                this.eventHandler.afterOpen(new DataSetInstance(dataSet), this.reportContext);
            }
        }
        catch (Exception e) {
            DataSetScriptExecutor.addException(this.context, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Scriptable getScriptScope(IDataSetInstanceHandle dataSet) throws DataException {
        Scriptable scope = scopeCache.get(dataSet);
        if (scope != null) {
            return scope;
        }
        Map<IDataSetInstanceHandle, Scriptable> map = scopeCache;
        synchronized (map) {
            Scriptable shared = this.scope;
            scope = (Scriptable)Context.javaToJS((Object)new DataSetInstance(dataSet), (Scriptable)shared);
            scope.setParentScope(shared);
            scope.setPrototype(dataSet.getScriptScope());
            scopeCache.put(dataSet, scope);
        }
        return scope;
    }

    public void handleAfterClose(IDataSetInstanceHandle dataSet) {
        if (this.reportContext == null) {
            return;
        }
        try {
            Scriptable scope;
            ScriptExecutor.ScriptStatus status;
            if (!this.useAfterCloseEventHandler && (status = this.handleJS(scope = this.getScriptScope(dataSet), dataSet.getName(), "afterClose", this.dataSetHandle.getAfterClose(), this.afterCloseMethodID)).didRun()) {
                return;
            }
            if (this.eventHandler != null) {
                this.eventHandler.afterClose(this.reportContext);
            }
        }
        catch (Exception e) {
            DataSetScriptExecutor.addException(this.context, e);
        }
    }

    public void handleOnFetch(IDataSetInstanceHandle dataSet, IDataRow row) {
        if (this.reportContext == null) {
            return;
        }
        try {
            Scriptable scope;
            ScriptExecutor.ScriptStatus status;
            if (!this.useOnFetchEventHandler && (status = this.handleJS(scope = this.getScriptScope(dataSet), dataSet.getName(), ON_FETCH, this.dataSetHandle.getOnFetch(), this.onFetchMethodID)).didRun()) {
                return;
            }
            if (this.eventHandler != null) {
                this.eventHandler.onFetch(new DataSetInstance(dataSet), new DataSetRow(row), this.reportContext);
            }
        }
        catch (Exception e) {
            DataSetScriptExecutor.addException(this.context, e);
        }
    }

    protected ScriptExecutor.ScriptStatus handleJS(Scriptable scope, String name, String method, String script, String id) {
        return this.handleJS(scope, "DataSet", name, method, script, id);
    }
}

