/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached;

import java.util.Arrays;

public final class CachedData {
    public static final int MAX_SIZE = 0x1400000;
    private final int flags;
    private final byte[] data;

    public CachedData(int f, byte[] d, int max_size) {
        if (d.length > max_size) {
            throw new IllegalArgumentException("Cannot cache data larger than " + max_size + " bytes (you tried to cache a " + d.length + " byte object)");
        }
        this.flags = f;
        this.data = d;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getFlags() {
        return this.flags;
    }

    public String toString() {
        return "{CachedData flags=" + this.flags + " data=" + Arrays.toString(this.data) + "}";
    }
}

