/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.compat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import net.spy.memcached.compat.SpyThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyncThread<T>
extends SpyThread {
    private final Callable<T> callable;
    private final CyclicBarrier barrier;
    private final CountDownLatch latch;
    private Throwable throwable = null;
    private T rv = null;

    public SyncThread(CyclicBarrier b, Callable<T> c) {
        super("SyncThread");
        this.setDaemon(true);
        this.callable = c;
        this.barrier = b;
        this.latch = new CountDownLatch(1);
        this.start();
    }

    @Override
    public void run() {
        try {
            this.barrier.await();
            this.rv = this.callable.call();
        }
        catch (Throwable t) {
            this.throwable = t;
        }
        this.latch.countDown();
    }

    public T getResult() throws Throwable {
        this.latch.await();
        if (this.throwable != null) {
            throw this.throwable;
        }
        return this.rv;
    }

    public static <T> Collection<SyncThread<T>> getCompletedThreads(int num, Callable<T> callable) throws InterruptedException {
        ArrayList<SyncThread<T>> rv = new ArrayList<SyncThread<T>>(num);
        CyclicBarrier barrier = new CyclicBarrier(num);
        for (int i = 0; i < num; ++i) {
            rv.add(new SyncThread<T>(barrier, callable));
        }
        for (SyncThread syncThread : rv) {
            syncThread.join();
        }
        return rv;
    }

    public static <T> int getDistinctResultCount(int num, Callable<T> callable) throws Throwable {
        IdentityHashMap<T, Object> found = new IdentityHashMap<T, Object>();
        Collection<SyncThread<T>> threads = SyncThread.getCompletedThreads(num, callable);
        for (SyncThread<T> s : threads) {
            found.put(s.getResult(), new Object());
        }
        return found.size();
    }
}

