/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.internal;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import net.spy.memcached.MemcachedConnection;
import net.spy.memcached.internal.CheckedOperationTimeoutException;
import net.spy.memcached.ops.Operation;
import net.spy.memcached.ops.OperationState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationFuture<T>
implements Future<T> {
    private final CountDownLatch latch;
    private final AtomicReference<T> objRef;
    private final long timeout;
    private Operation op;

    public OperationFuture(CountDownLatch l, long opTimeout) {
        this(l, new AtomicReference<Object>(null), opTimeout);
    }

    public OperationFuture(CountDownLatch l, AtomicReference<T> oref, long opTimeout) {
        this.latch = l;
        this.objRef = oref;
        this.timeout = opTimeout;
    }

    @Override
    public boolean cancel(boolean ign) {
        assert (this.op != null) : "No operation";
        this.op.cancel();
        return this.op.getState() == OperationState.WRITING;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        try {
            return this.get(this.timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            throw new RuntimeException("Timed out waiting for operation", e);
        }
    }

    @Override
    public T get(long duration, TimeUnit units) throws InterruptedException, TimeoutException, ExecutionException {
        if (!this.latch.await(duration, units)) {
            MemcachedConnection.opTimedOut(this.op);
            if (this.op != null) {
                this.op.timeOut();
            }
            throw new CheckedOperationTimeoutException("Timed out waiting for operation", this.op);
        }
        MemcachedConnection.opSucceeded(this.op);
        if (this.op != null && this.op.hasErrored()) {
            throw new ExecutionException(this.op.getException());
        }
        if (this.isCancelled()) {
            throw new ExecutionException(new RuntimeException("Cancelled"));
        }
        if (this.op != null && this.op.isTimedOut()) {
            throw new ExecutionException(new CheckedOperationTimeoutException("Operation timed out.", this.op));
        }
        return this.objRef.get();
    }

    public void set(T o) {
        this.objRef.set(o);
    }

    public void setOperation(Operation to) {
        this.op = to;
    }

    @Override
    public boolean isCancelled() {
        assert (this.op != null) : "No operation";
        return this.op.isCancelled();
    }

    @Override
    public boolean isDone() {
        assert (this.op != null) : "No operation";
        return this.latch.getCount() == 0L || this.op.isCancelled() || this.op.getState() == OperationState.COMPLETE;
    }
}

