/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.binary;

import java.util.Collection;
import java.util.Collections;
import net.spy.memcached.ops.GetAndTouchOperation;
import net.spy.memcached.ops.GetOperation;
import net.spy.memcached.ops.GetlOperation;
import net.spy.memcached.ops.GetsOperation;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.protocol.binary.OperationImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GetOperationImpl
extends OperationImpl
implements GetOperation,
GetsOperation,
GetlOperation,
GetAndTouchOperation {
    static final int GET_CMD = 0;
    static final int GETL_CMD = 148;
    static final int GAT_CMD = 29;
    static final int EXTRA_HDR_LEN = 4;
    private final String key;
    private final int exp;
    private final int cmd;

    public GetOperationImpl(String k, GetOperation.Callback cb) {
        super(0, GetOperationImpl.generateOpaque(), cb);
        this.key = k;
        this.exp = 0;
        this.cmd = 0;
    }

    public GetOperationImpl(String k, GetsOperation.Callback cb) {
        super(0, GetOperationImpl.generateOpaque(), cb);
        this.key = k;
        this.exp = 0;
        this.cmd = 0;
    }

    public GetOperationImpl(String k, int e, GetlOperation.Callback cb) {
        super(148, GetOperationImpl.generateOpaque(), cb);
        this.key = k;
        this.exp = e;
        this.cmd = 148;
    }

    public GetOperationImpl(String k, int e, GetAndTouchOperation.Callback cb) {
        super(29, GetOperationImpl.generateOpaque(), cb);
        this.key = k;
        this.exp = e;
        this.cmd = 29;
    }

    @Override
    public void initialize() {
        if (this.cmd == 148) {
            this.prepareBuffer(this.key, 0L, EMPTY_BYTES, 0, this.exp);
        } else if (this.cmd == 29) {
            this.prepareBuffer(this.key, 0L, EMPTY_BYTES, this.exp);
        } else {
            this.prepareBuffer(this.key, 0L, EMPTY_BYTES, new Object[0]);
        }
    }

    @Override
    protected void decodePayload(byte[] pl) {
        int flags = GetOperationImpl.decodeInt(pl, 0);
        byte[] data = new byte[pl.length - 4];
        System.arraycopy(pl, 4, data, 0, pl.length - 4);
        OperationCallback cb = this.getCallback();
        if (cb instanceof GetOperation.Callback) {
            GetOperation.Callback gcb = (GetOperation.Callback)cb;
            gcb.gotData(this.key, flags, data);
        } else if (cb instanceof GetsOperation.Callback) {
            GetsOperation.Callback gcb = (GetsOperation.Callback)cb;
            gcb.gotData(this.key, flags, this.responseCas, data);
        } else if (cb instanceof GetlOperation.Callback) {
            byte[] value = new byte[data.length - this.key.length()];
            System.arraycopy(data, this.key.length(), value, 0, data.length - this.key.length());
            GetlOperation.Callback gcb = (GetlOperation.Callback)cb;
            gcb.gotData(this.key, flags, this.responseCas, value);
        } else if (cb instanceof GetAndTouchOperation.Callback) {
            GetAndTouchOperation.Callback gcb = (GetAndTouchOperation.Callback)cb;
            gcb.gotData(this.key, flags, this.responseCas, data);
        } else {
            throw new ClassCastException("Couldn't convert " + cb + "to a relevent op");
        }
        this.getCallback().receivedStatus(STATUS_OK);
    }

    @Override
    protected OperationStatus getStatusForErrorCode(int errCode, byte[] errPl) {
        OperationStatus baseStatus = super.getStatusForErrorCode(errCode, errPl);
        if (baseStatus != null) {
            return baseStatus;
        }
        return errCode == 1 ? NOT_FOUND_STATUS : null;
    }

    @Override
    public Collection<String> getKeys() {
        return Collections.singleton(this.key);
    }
}

