/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.binary;

import java.util.Collection;
import java.util.Collections;
import net.spy.memcached.ops.CASOperation;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.ops.StoreOperation;
import net.spy.memcached.ops.StoreType;
import net.spy.memcached.protocol.binary.OperationImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StoreOperationImpl
extends OperationImpl
implements StoreOperation,
CASOperation {
    private static final int SET = 1;
    private static final int ADD = 2;
    private static final int REPLACE = 3;
    static final int SETQ = 17;
    static final int ADDQ = 18;
    static final int REPLACEQ = 19;
    static final int EXTRA_LEN = 8;
    private final String key;
    private final StoreType storeType;
    private final int flags;
    private final int exp;
    private final long cas;
    private final byte[] data;

    private static int cmdMap(StoreType t) {
        int rv = -1;
        switch (t) {
            case set: {
                rv = 1;
                break;
            }
            case add: {
                rv = 2;
                break;
            }
            case replace: {
                rv = 3;
            }
        }
        assert (rv != -1) : "Unhandled store type:  " + (Object)((Object)t);
        return rv;
    }

    public StoreOperationImpl(StoreType t, String k, int f, int e, byte[] d, long c, OperationCallback cb) {
        super(StoreOperationImpl.cmdMap(t), StoreOperationImpl.generateOpaque(), cb);
        this.key = k;
        this.flags = f;
        this.exp = e;
        this.data = d;
        this.cas = c;
        this.storeType = t;
    }

    @Override
    public void initialize() {
        this.prepareBuffer(this.key, this.cas, this.data, this.flags, this.exp);
    }

    @Override
    protected OperationStatus getStatusForErrorCode(int errCode, byte[] errPl) {
        OperationStatus baseStatus = super.getStatusForErrorCode(errCode, errPl);
        if (baseStatus != null) {
            return baseStatus;
        }
        OperationStatus rv = null;
        switch (errCode) {
            case 2: {
                rv = EXISTS_STATUS;
                break;
            }
            case 1: {
                rv = NOT_FOUND_STATUS;
                break;
            }
            case 134: {
                rv = TEMP_FAIL;
            }
        }
        return rv;
    }

    @Override
    public Collection<String> getKeys() {
        return Collections.singleton(this.key);
    }

    @Override
    public byte[] getBytes() {
        return this.data;
    }

    @Override
    public long getCasValue() {
        return this.cas;
    }

    @Override
    public int getExpiration() {
        return this.exp;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    @Override
    public StoreType getStoreType() {
        return this.storeType;
    }
}

