/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.vbucket;

import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.NodeLocator;
import net.spy.memcached.compat.SpyObject;
import net.spy.memcached.vbucket.config.Config;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VBucketNodeLocator
extends SpyObject
implements NodeLocator {
    private Map<String, MemcachedNode> nodesMap;
    private Config config;

    public VBucketNodeLocator(List<MemcachedNode> nodes, Config jsonConfig) {
        this.setNodes(nodes);
        this.setConfig(jsonConfig);
    }

    @Override
    public MemcachedNode getPrimary(String k) {
        int vbucket = this.config.getVbucketByKey(k);
        int serverNumber = this.config.getMaster(vbucket);
        String server = this.config.getServer(serverNumber);
        MemcachedNode pNode = this.nodesMap.get(server);
        if (pNode == null) {
            this.getLogger().error("The node locator does not have a primary for key %s.", k);
            Collection<MemcachedNode> nodes = this.nodesMap.values();
            this.getLogger().error("MemcachedNode has %s entries:", this.nodesMap.size());
            for (MemcachedNode node : nodes) {
                this.getLogger().error(node);
            }
        }
        assert (pNode != null);
        return pNode;
    }

    @Override
    public Iterator<MemcachedNode> getSequence(String k) {
        return this.nodesMap.values().iterator();
    }

    @Override
    public Collection<MemcachedNode> getAll() {
        return this.nodesMap.values();
    }

    @Override
    public NodeLocator getReadonlyCopy() {
        return this;
    }

    public void updateLocator(List<MemcachedNode> nodes, Config config) {
        this.setNodes(nodes);
        this.setConfig(config);
    }

    public int getVBucketIndex(String key) {
        return this.config.getVbucketByKey(key);
    }

    private void setNodes(Collection<MemcachedNode> nodes) {
        HashMap<String, MemcachedNode> vbnodesMap = new HashMap<String, MemcachedNode>();
        this.getLogger().debug("Updating nodesMap in VBucketNodeLocator.");
        for (MemcachedNode node : nodes) {
            InetSocketAddress addr = (InetSocketAddress)node.getSocketAddress();
            String address = addr.getAddress().getHostName() + ":" + addr.getPort();
            String hostname = addr.getAddress().getHostAddress() + ":" + addr.getPort();
            this.getLogger().debug("Adding node with hostname %s and address %s.", hostname, address);
            this.getLogger().debug("Node added is %s.", node);
            vbnodesMap.put(address, node);
            vbnodesMap.put(hostname, node);
        }
        this.nodesMap = vbnodesMap;
    }

    private void setConfig(Config config) {
        this.config = config;
    }

    public MemcachedNode getAlternative(String k, Collection<MemcachedNode> notMyVbucketNodes) {
        Collection<MemcachedNode> nodes = this.nodesMap.values();
        nodes.removeAll(notMyVbucketNodes);
        if (nodes.isEmpty()) {
            return null;
        }
        return nodes.iterator().next();
    }
}

