/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.group.interceptors;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.ChannelMessage;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.group.ChannelInterceptorBase;
import org.apache.catalina.tribes.group.InterceptorPayload;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class GzipInterceptor
extends ChannelInterceptorBase {
    private static final Log log = LogFactory.getLog(GzipInterceptor.class);
    public static final int DEFAULT_BUFFER_SIZE = 2048;

    @Override
    public void sendMessage(Member[] destination, ChannelMessage msg, InterceptorPayload payload) throws ChannelException {
        try {
            byte[] data = GzipInterceptor.compress(msg.getMessage().getBytes());
            msg.getMessage().trim(msg.getMessage().getLength());
            msg.getMessage().append(data, 0, data.length);
            this.getNext().sendMessage(destination, msg, payload);
        }
        catch (IOException x) {
            log.error((Object)"Unable to compress byte contents");
            throw new ChannelException(x);
        }
    }

    @Override
    public void messageReceived(ChannelMessage msg) {
        try {
            byte[] data = GzipInterceptor.decompress(msg.getMessage().getBytes());
            msg.getMessage().trim(msg.getMessage().getLength());
            msg.getMessage().append(data, 0, data.length);
            this.getPrevious().messageReceived(msg);
        }
        catch (IOException x) {
            log.error((Object)"Unable to decompress byte contents", (Throwable)x);
        }
    }

    public static byte[] compress(byte[] data) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        GZIPOutputStream gout = new GZIPOutputStream(bout);
        gout.write(data);
        gout.flush();
        gout.close();
        return bout.toByteArray();
    }

    public static byte[] decompress(byte[] data) throws IOException {
        ByteArrayInputStream bin = new ByteArrayInputStream(data);
        GZIPInputStream gin = new GZIPInputStream(bin);
        byte[] tmp = new byte[2048];
        int length = gin.read(tmp);
        byte[] result = new byte[length];
        System.arraycopy(tmp, 0, result, 0, length);
        return result;
    }

    public static void main(String[] arg) throws Exception {
        byte[] data = new byte[1024];
        Arrays.fill(data, (byte)1);
        byte[] compress = GzipInterceptor.compress(data);
        GzipInterceptor.decompress(compress);
        System.out.println("Debug test");
    }
}

