/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.excel;

import java.math.RoundingMode;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NumberFormatValue {
    private int fractionDigits;
    private String format;
    private RoundingMode roundingMode;
    private static Pattern pattern = Pattern.compile("^(.*?)\\{RoundingMode=(.*?)\\}", 2);

    private NumberFormatValue() {
    }

    public static NumberFormatValue getInstance(String numberFormat) {
        if (numberFormat != null) {
            NumberFormatValue value = new NumberFormatValue();
            Matcher matcher = pattern.matcher(numberFormat);
            if (matcher.matches()) {
                String m;
                String f = matcher.group(1);
                if (f != null && f.length() > 0) {
                    value.format = f;
                    int index = f.lastIndexOf(46);
                    if (index > 0) {
                        int end = f.length();
                        int i = index + 1;
                        while (i < f.length()) {
                            if (f.charAt(i) != '0') {
                                end = i;
                                break;
                            }
                            ++i;
                        }
                        value.fractionDigits = end - 1 - index;
                    }
                    char lastChar = f.charAt(f.length() - 1);
                    switch (lastChar) {
                        case '%': {
                            value.fractionDigits += 2;
                            break;
                        }
                        case '\u2030': {
                            value.fractionDigits += 3;
                            break;
                        }
                        case '\u2031': {
                            value.fractionDigits += 4;
                        }
                    }
                }
                if ((m = matcher.group(2)) != null) {
                    value.roundingMode = RoundingMode.valueOf(m);
                }
            } else {
                value.format = numberFormat;
            }
            return value;
        }
        return null;
    }

    public int getFractionDigits() {
        return this.fractionDigits;
    }

    public void setFractionDigits(int fractionDigits) {
        this.fractionDigits = fractionDigits;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public RoundingMode getRoundingMode() {
        return this.roundingMode;
    }

    public void setRoundingMode(RoundingMode roundingMode) {
        this.roundingMode = roundingMode;
    }
}

