/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.script;

import java.util.Map;
import org.eclipse.birt.core.i18n.CoreMessages;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Scriptable;

public class NativeJavaMap
extends NativeJavaObject {
    private static final long serialVersionUID = -3988584321233636629L;

    public NativeJavaMap() {
    }

    public NativeJavaMap(Scriptable scope, Object javaObject, Class staticType) {
        super(scope, javaObject, staticType);
    }

    public boolean has(String name, Scriptable start) {
        return ((Map)this.javaObject).containsKey(name);
    }

    public Object get(String name, Scriptable start) {
        if ("length".equals(name)) {
            return ((Map)this.javaObject).size();
        }
        if (this.has(name, start)) {
            return ((Map)this.javaObject).get(name);
        }
        String errorMessage = CoreMessages.getFormattedString("birt.core.Javascript.nativeNotFound", name);
        throw new JavaScriptException((Object)errorMessage, "<unknown>", -1);
    }

    public void put(String name, Scriptable start, Object value) {
        ((Map)this.javaObject).put(name, value);
    }

    public void delete(String name) {
        ((Map)this.javaObject).remove(name);
    }

    public Object get(int index, Scriptable start) {
        String key = String.valueOf(index);
        if (this.has(key, start)) {
            return ((Map)this.javaObject).get(key);
        }
        String errorMessage = CoreMessages.getFormattedString("birt.core.Javascript.nativeNotFound", index);
        throw new JavaScriptException((Object)errorMessage, "<unknown>", -1);
    }

    public void put(int index, Scriptable start, Object value) {
        ((Map)this.javaObject).put(String.valueOf(index), value);
    }

    public Object[] getIds() {
        return ((Map)this.javaObject).keySet().toArray();
    }
}

