/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.script;

import java.util.Map;
import org.eclipse.birt.core.i18n.CoreMessages;
import org.eclipse.birt.core.script.BaseScriptable;
import org.eclipse.birt.core.script.ParameterAttribute;
import org.eclipse.birt.core.script.ScriptableParameter;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Wrapper;

public class ScriptableParameters
extends BaseScriptable {
    private Map parameters;
    private static final String JS_CLASS_NAME = "ScriptableParameters";

    public ScriptableParameters(Map parameters, Scriptable scope) {
        this.setParentScope(scope);
        this.parameters = parameters;
    }

    public Object get(String name, Scriptable start) {
        ScriptableParameter result = this.getScriptableParameter(name);
        if (result == null) {
            String errorMessage = CoreMessages.getFormattedString("birt.core.Javascript.parameterNotExist", name);
            throw new JavaScriptException((Object)errorMessage, "<unknown>", -1);
        }
        return result;
    }

    public Object get(int index, Scriptable start) {
        return this.get(String.valueOf(index), start);
    }

    private ScriptableParameter getScriptableParameter(String name) {
        if (this.parameters.containsKey(name)) {
            return new ScriptableParameter(this.parameters, name, this.getParentScope());
        }
        return null;
    }

    public boolean has(String name, Scriptable start) {
        return this.parameters.get(name) != null;
    }

    public void put(String name, Scriptable start, Object value) {
        ParameterAttribute entry = (ParameterAttribute)this.parameters.get(name);
        if (entry == null) {
            entry = new ParameterAttribute();
            this.parameters.put(name, entry);
        }
        if (value instanceof ScriptableParameter) {
            ScriptableParameter scriptableParameter = (ScriptableParameter)value;
            Object paramValue = scriptableParameter.get("value", (Scriptable)this);
            String displayText = (String)scriptableParameter.get("displayText", (Scriptable)this);
            entry.setValue(paramValue);
            entry.setDisplayText(displayText);
            return;
        }
        if (value instanceof Wrapper) {
            value = ((Wrapper)value).unwrap();
        }
        if (value instanceof ParameterAttribute) {
            ParameterAttribute param = (ParameterAttribute)value;
            entry.setValue(param.getValue());
            entry.setDisplayText(param.getDisplayText());
        } else {
            entry.setValue(value);
        }
    }

    public String getClassName() {
        return JS_CLASS_NAME;
    }
}

