/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.css;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.css.CssStyleSheet;
import org.eclipse.birt.report.model.elements.ICssStyleSheetOperation;
import org.eclipse.birt.report.model.util.ResourceLocatorImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CssStyleSheetAdapter
implements ICssStyleSheetOperation {
    private List<CssStyleSheet> csses = null;

    public static CssStyleSheet getCssStyleSheetByLocation(Module module, List<CssStyleSheet> csses, URL url) {
        if (url == null || csses == null) {
            return null;
        }
        ResourceLocatorImpl locator = new ResourceLocatorImpl();
        int i = 0;
        while (i < csses.size()) {
            CssStyleSheet css = csses.get(i);
            String tmpFileName = css.getFileName();
            URL tmpurl = locator.findResource((ModuleHandle)module.getHandle(module), tmpFileName, 3);
            if (tmpurl != null && url.equals(tmpurl)) {
                return css;
            }
            ++i;
        }
        return null;
    }

    public static int getPositionOfCssStyleSheet(Module module, List<CssStyleSheet> csses, String location) {
        if (location == null || csses == null) {
            return -1;
        }
        URL targetUrl = module.findResource(location, 3);
        String fileLocation = location;
        if (targetUrl != null) {
            fileLocation = targetUrl.getFile();
        }
        int i = 0;
        while (i < csses.size()) {
            URL url;
            CssStyleSheet css = csses.get(i);
            String tmpFileName = css.getFileName();
            if (targetUrl != null && (url = module.findResource(tmpFileName, 3)) != null) {
                tmpFileName = url.getFile();
            }
            if (fileLocation.equalsIgnoreCase(tmpFileName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int dropCss(CssStyleSheet css) {
        assert (this.csses != null);
        assert (this.csses.contains(css));
        int posn = this.csses.indexOf(css);
        if (posn != -1) {
            this.csses.remove(posn);
        }
        return posn;
    }

    @Override
    public void addCss(CssStyleSheet css) {
        if (this.csses == null) {
            this.csses = new ArrayList<CssStyleSheet>();
        }
        this.csses.add(css);
    }

    @Override
    public void insertCss(CssStyleSheet css, int index) {
        if (this.csses == null) {
            this.csses = new ArrayList<CssStyleSheet>();
        }
        if (index < 0 || index > this.csses.size()) {
            return;
        }
        this.csses.add(index, css);
    }

    @Override
    public List<CssStyleSheet> getCsses() {
        if (this.csses == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.csses);
    }
}

