/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.util;

import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.elements.structures.Action;
import org.eclipse.birt.report.model.api.elements.structures.FilterCondition;
import org.eclipse.birt.report.model.api.elements.structures.HideRule;
import org.eclipse.birt.report.model.api.elements.structures.HighlightRule;
import org.eclipse.birt.report.model.api.elements.structures.MapRule;
import org.eclipse.birt.report.model.api.elements.structures.ParamBinding;
import org.eclipse.birt.report.model.api.elements.structures.SearchKey;
import org.eclipse.birt.report.model.api.elements.structures.SortKey;
import org.eclipse.birt.report.model.api.elements.structures.StyleRule;
import org.eclipse.birt.report.model.api.elements.structures.TOC;
import org.eclipse.birt.report.model.api.extension.ICompatibleReportItem;
import org.eclipse.birt.report.model.api.extension.IReportItem;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.elements.Cell;
import org.eclipse.birt.report.model.elements.DataItem;
import org.eclipse.birt.report.model.elements.ExtendedItem;
import org.eclipse.birt.report.model.elements.GridItem;
import org.eclipse.birt.report.model.elements.GroupElement;
import org.eclipse.birt.report.model.elements.ImageItem;
import org.eclipse.birt.report.model.elements.Label;
import org.eclipse.birt.report.model.elements.ListGroup;
import org.eclipse.birt.report.model.elements.ListItem;
import org.eclipse.birt.report.model.elements.ListingElement;
import org.eclipse.birt.report.model.elements.ReportItem;
import org.eclipse.birt.report.model.elements.ScalarParameter;
import org.eclipse.birt.report.model.elements.TableColumn;
import org.eclipse.birt.report.model.elements.TableGroup;
import org.eclipse.birt.report.model.elements.TableItem;
import org.eclipse.birt.report.model.elements.TableRow;
import org.eclipse.birt.report.model.elements.TemplateReportItem;
import org.eclipse.birt.report.model.elements.TextDataItem;
import org.eclipse.birt.report.model.elements.TextItem;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.util.BoundDataColumnUtil;
import org.eclipse.birt.report.model.util.LevelContentIterator;

public abstract class BoundColumnsMgr {
    protected void dealReportItem(ReportItem element, Module module) {
        List hideRules;
        List paramBindings;
        String value;
        this.dealStyle(element, module);
        TOC toc = (TOC)element.getLocalProperty(module, "toc");
        if (toc != null) {
            this.handleBoundsForValue(element, module, toc.getExpression());
        }
        if ((value = BoundColumnsMgr.getLocalStringProperty(module, element, "bookmark")) != null) {
            this.handleBoundsForValue(element, module, value);
        }
        if ((value = (String)element.getLocalProperty(module, "onCreate")) != null) {
            this.handleBoundsForValue(element, module, value);
        }
        if ((paramBindings = (List)element.getLocalProperty(module, "paramBindings")) != null && paramBindings.size() > 0) {
            int i = 0;
            while (i < paramBindings.size()) {
                ParamBinding paramValue = (ParamBinding)paramBindings.get(i);
                this.handleBoundsForParamBinding(element, module, paramValue.getExpression());
                ++i;
            }
        }
        if ((hideRules = (List)element.getLocalProperty(module, "visibility")) != null && hideRules.size() > 0) {
            int i = 0;
            while (i < hideRules.size()) {
                HideRule paramValue = (HideRule)hideRules.get(i);
                this.handleBoundsForValue(element, module, paramValue.getExpression());
                ++i;
            }
        }
    }

    protected void dealDataContainerReportItem(ListingElement element, Module module) {
        if (element instanceof TableItem) {
            this.dealTable((TableItem)element, module);
        } else if (element instanceof ListItem) {
            this.dealList((ListItem)element, module);
        }
    }

    protected void dealNonDataContainerReportItem(ReportItem element, Module module) {
        if (element instanceof TextDataItem) {
            this.dealTextData((TextDataItem)element, module);
        }
        if (element instanceof Label) {
            this.dealLabel((Label)element, module);
        }
        if (element instanceof DataItem) {
            this.dealData((DataItem)element, module);
        }
        if (element instanceof ImageItem) {
            this.dealImage((ImageItem)element, module);
        }
        if (element instanceof GridItem) {
            this.dealGrid((GridItem)element, module);
        }
        if (element instanceof ExtendedItem) {
            this.dealExtendedItem((ExtendedItem)element, module);
        }
    }

    protected void dealExtendedItem(ExtendedItem element, Module module) {
        IReportItem reportItem;
        Object value;
        this.dealReportItem(element, module);
        List values = (List)element.getLocalProperty(module, "filter");
        if (values != null && !values.isEmpty() && (value = values.get(0)) instanceof FilterCondition) {
            int i = 0;
            while (i < values.size()) {
                FilterCondition struct = (FilterCondition)values.get(i);
                this.handleBoundsForValue(element, module, struct.getExpr());
                this.handleBoundsForValue(element, module, struct.getValue1());
                this.handleBoundsForValue(element, module, struct.getValue2());
                ++i;
            }
        }
        if ((reportItem = element.getExtendedElement()) != null && reportItem instanceof ICompatibleReportItem) {
            List jsExprs = ((ICompatibleReportItem)((Object)reportItem)).getRowExpressions();
            int i = 0;
            while (i < jsExprs.size()) {
                this.handleBoundsForValue(element, module, (String)jsExprs.get(i));
                ++i;
            }
            Map<String, String> updatedExprs = BoundDataColumnUtil.handleJavaExpression((List<String>)jsExprs, element, module, null);
            ((ICompatibleReportItem)((Object)reportItem)).updateRowExpressions(updatedExprs);
        }
    }

    private void dealListingGroup(GroupElement element, Module module) {
        Structure struct;
        int i;
        List values;
        TOC toc;
        String value = BoundColumnsMgr.getLocalStringProperty(module, element, "keyExpr");
        if (value != null) {
            this.handleBoundsForValue(element, module, value);
        }
        if ((toc = (TOC)element.getLocalProperty(module, "toc")) != null) {
            this.handleBoundsForValue(element, module, toc.getExpression());
        }
        if ((values = (List)element.getLocalProperty(module, "filter")) != null && values.size() >= 1) {
            i = 0;
            while (i < values.size()) {
                struct = (FilterCondition)values.get(i);
                this.handleBoundsForValue(element, module, ((FilterCondition)struct).getExpr());
                this.handleBoundsForValue(element, module, ((FilterCondition)struct).getValue1());
                this.handleBoundsForValue(element, module, ((FilterCondition)struct).getValue2());
                ++i;
            }
        }
        if ((values = (List)element.getLocalProperty(module, "sort")) != null && values.size() >= 1) {
            i = 0;
            while (i < values.size()) {
                struct = (SortKey)values.get(i);
                this.handleBoundsForValue(element, module, ((SortKey)struct).getKey());
                ++i;
            }
        }
    }

    private void dealListing(ListingElement element, Module module) {
        Structure struct;
        int i;
        this.dealReportItem(element, module);
        List values = (List)element.getLocalProperty(module, "filter");
        if (values != null && values.size() >= 1) {
            i = 0;
            while (i < values.size()) {
                struct = (FilterCondition)values.get(i);
                this.handleBoundsForValue(element, module, ((FilterCondition)struct).getExpr());
                this.handleBoundsForValue(element, module, ((FilterCondition)struct).getValue1());
                this.handleBoundsForValue(element, module, ((FilterCondition)struct).getValue2());
                ++i;
            }
        }
        if ((values = (List)element.getLocalProperty(module, "sort")) != null && values.size() >= 1) {
            i = 0;
            while (i < values.size()) {
                struct = (SortKey)values.get(i);
                this.handleBoundsForValue(element, module, ((SortKey)struct).getKey());
                ++i;
            }
        }
    }

    protected void dealGrid(GridItem element, Module module) {
        this.dealReportItem(element, module);
        LevelContentIterator contents = new LevelContentIterator(module, element, 3);
        while (contents.hasNext()) {
            DesignElement child = contents.next();
            if (child instanceof TableColumn) {
                this.dealColumn((TableColumn)child, module);
            }
            if (child instanceof TableRow) {
                this.dealRow((TableRow)child, module);
            }
            if (child instanceof ReportItem) {
                if (child instanceof ListingElement) {
                    this.dealListing((ListingElement)child, module);
                } else {
                    this.dealNonDataContainerReportItem((ReportItem)child, module);
                }
            }
            if (!(child instanceof Cell)) continue;
            this.dealCell((Cell)child, module);
        }
    }

    protected void dealList(ListItem element, Module module) {
        this.dealListing(element, module);
        LevelContentIterator contents = new LevelContentIterator(module, element, 1);
        while (contents.hasNext()) {
            DesignElement child = contents.next();
            if (child instanceof ListGroup) {
                this.dealListingGroup((ListGroup)child, module);
                LevelContentIterator grandChildren = new LevelContentIterator(module, child, 1);
                while (grandChildren.hasNext()) {
                    DesignElement grandChild = grandChildren.next();
                    if (grandChild instanceof ListingElement) {
                        this.dealListing((ListingElement)grandChild, module);
                        continue;
                    }
                    this.dealNonDataContainerReportItem((ReportItem)grandChild, module);
                }
            }
            if (!(child instanceof ReportItem)) continue;
            if (child instanceof ListingElement) {
                this.dealListing((ListingElement)child, module);
                continue;
            }
            this.dealNonDataContainerReportItem((ReportItem)child, module);
        }
    }

    protected void dealTable(TableItem element, Module module) {
        this.dealListing(element, module);
        int i = 0;
        while (i < element.getDefn().getSlotCount()) {
            int level = 3;
            if (i == 1) {
                level = 1;
            }
            LevelContentIterator contents = new LevelContentIterator(module, element, level);
            while (contents.hasNext()) {
                DesignElement child = contents.next();
                if (child instanceof TableGroup) {
                    this.dealListingGroup((TableGroup)child, module);
                    LevelContentIterator grandChildren = new LevelContentIterator(module, child, 3);
                    while (grandChildren.hasNext()) {
                        DesignElement grandChild = grandChildren.next();
                        if (grandChild instanceof TableRow) {
                            this.dealRow((TableRow)grandChild, module);
                        }
                        if (grandChild instanceof Cell) {
                            this.dealCell((Cell)grandChild, module);
                        }
                        if (!(grandChild instanceof ReportItem)) continue;
                        if (grandChild instanceof ListingElement) {
                            this.dealListing((ListingElement)grandChild, module);
                            continue;
                        }
                        this.dealNonDataContainerReportItem((ReportItem)grandChild, module);
                    }
                }
                if (child instanceof TableColumn) {
                    this.dealColumn((TableColumn)child, module);
                }
                if (child instanceof TableRow) {
                    this.dealRow((TableRow)child, module);
                }
                if (child instanceof ReportItem) {
                    if (child instanceof ListingElement) {
                        this.dealListing((ListingElement)child, module);
                    } else {
                        this.dealNonDataContainerReportItem((ReportItem)child, module);
                    }
                }
                if (!(child instanceof Cell)) continue;
                this.dealCell((Cell)child, module);
            }
            ++i;
        }
    }

    private void dealRow(TableRow element, Module module) {
        List hideRules;
        String value = BoundColumnsMgr.getLocalStringProperty(module, element, "bookmark");
        if (value != null) {
            this.handleBoundsForValue(element, module, value);
        }
        if ((value = (String)element.getLocalProperty(module, "onCreate")) != null) {
            this.handleBoundsForValue(element, module, value);
        }
        if ((hideRules = (List)element.getLocalProperty(module, "visibility")) == null || hideRules.size() < 1) {
            return;
        }
        int i = 0;
        while (i < hideRules.size()) {
            HideRule paramValue = (HideRule)hideRules.get(i);
            this.handleBoundsForValue(element, module, paramValue.getExpression());
            ++i;
        }
    }

    private void dealCell(Cell element, Module module) {
        String value = (String)element.getLocalProperty(module, "onCreate");
        if (value != null) {
            this.handleBoundsForValue(element, module, value);
        }
    }

    protected void dealImage(ImageItem element, Module module) {
        this.dealReportItem(element, module);
        String value = BoundColumnsMgr.getLocalStringProperty(module, element, "uri");
        if (value != null) {
            this.handleBoundsForValue(element, module, value);
        }
        if ((value = BoundColumnsMgr.getLocalStringProperty(module, element, "valueExpr")) != null) {
            this.handleBoundsForValue(element, module, value);
        }
        if ((value = BoundColumnsMgr.getLocalStringProperty(module, element, "typeExpr")) != null) {
            this.handleBoundsForValue(element, module, value);
        }
        List actions = (List)element.getLocalProperty(module, "action");
        this.dealAction(element, module, actions);
    }

    protected void dealLabel(Label element, Module module) {
        this.dealReportItem(element, module);
        List actions = (List)element.getLocalProperty(module, "action");
        this.dealAction(element, module, actions);
    }

    protected void dealData(DataItem element, Module module) {
        this.dealReportItem(element, module);
        List actions = (List)element.getLocalProperty(module, "action");
        this.dealAction(element, module, actions);
    }

    private void dealAction(ReportItem element, Module module, List actions) {
        if (actions == null || actions.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < actions.size()) {
            List searchKeys;
            List paramBindings;
            Action action = (Action)actions.get(i);
            String value = action.getStringProperty(module, "uri");
            if (value != null) {
                this.handleBoundsForValue(element, module, value);
            }
            if ((value = action.getStringProperty(module, "targetBookmark")) != null) {
                this.handleBoundsForValue(element, module, value);
            }
            if ((paramBindings = (List)action.getLocalProperty(module, "paramBindings")) != null && paramBindings.size() > 0) {
                int j = 0;
                while (j < paramBindings.size()) {
                    ParamBinding paramValue = (ParamBinding)paramBindings.get(j);
                    this.handleBoundsForParamBinding(element, module, paramValue.getExpression());
                    ++j;
                }
            }
            if ((searchKeys = (List)action.getLocalProperty(module, "search")) == null || searchKeys.size() < 1) {
                return;
            }
            int j = 0;
            while (j < searchKeys.size()) {
                SearchKey searchKey = (SearchKey)searchKeys.get(j);
                this.handleBoundsForValue(element, module, searchKey.getExpression());
                ++j;
            }
            ++i;
        }
    }

    private void dealStyle(ReportItem element, Module module) {
        StyleRule struct;
        int i;
        List values = (List)element.getLocalProperty(module, "mapRules");
        if (values != null) {
            i = 0;
            while (i < values.size()) {
                struct = (MapRule)values.get(i);
                this.handleBoundsForValue(element, module, struct.getTestExpression());
                this.handleBoundsForValue(element, module, struct.getValue1());
                this.handleBoundsForValue(element, module, struct.getValue2());
                ++i;
            }
        }
        if ((values = (List)element.getLocalProperty(module, "highlightRules")) != null) {
            i = 0;
            while (i < values.size()) {
                struct = (HighlightRule)values.get(i);
                this.handleBoundsForValue(element, module, struct.getTestExpression());
                this.handleBoundsForValue(element, module, struct.getValue1());
                this.handleBoundsForValue(element, module, struct.getValue2());
                ++i;
            }
        }
    }

    protected void dealTextData(TextDataItem element, Module module) {
        this.dealReportItem(element, module);
        String value = BoundColumnsMgr.getLocalStringProperty(module, element, "valueExpr");
        if (value != null) {
            this.handleBoundsForValue(element, module, value);
        }
    }

    protected void dealText(TextItem element, Module module) {
        this.dealReportItem(element, module);
        String content = BoundColumnsMgr.getLocalStringProperty(module, element, "content");
        if (StringUtil.isBlank(content)) {
            return;
        }
        List jsExprs = BoundDataColumnUtil.getExpressions(content, element, module);
        BoundDataColumnUtil.handleJavaExpression(jsExprs, element, module, null);
    }

    protected void dealScalarParameter(ScalarParameter element, Module module) {
        Expression tmpValue = (Expression)element.getLocalProperty(module, "valueExpr");
        String value = null;
        if (tmpValue != null) {
            value = tmpValue.getStringExpression();
        }
        if (value != null) {
            this.handleBoundsForValue(element, module, value);
        }
        tmpValue = (Expression)element.getLocalProperty(module, "labelExpr");
        value = null;
        if (tmpValue != null) {
            value = tmpValue.getStringExpression();
        }
        if (value != null) {
            this.handleBoundsForValue(element, module, value);
        }
    }

    protected void dealTemplateReportItem(TemplateReportItem element, Module module) {
        List hideRules = (List)element.getLocalProperty(module, "visibility");
        if (hideRules == null || hideRules.size() < 1) {
            return;
        }
        int i = 0;
        while (i < hideRules.size()) {
            HideRule paramValue = (HideRule)hideRules.get(i);
            this.handleBoundsForValue(element, module, paramValue.getExpression());
            ++i;
        }
    }

    private void dealColumn(TableColumn element, Module module) {
        List hideRules = (List)element.getLocalProperty(module, "visibility");
        if (hideRules == null || hideRules.size() < 1) {
            return;
        }
        int i = 0;
        while (i < hideRules.size()) {
            HideRule paramValue = (HideRule)hideRules.get(i);
            this.handleBoundsForValue(element, module, paramValue.getExpression());
            ++i;
        }
    }

    protected abstract void handleBoundsForValue(DesignElement var1, Module var2, String var3);

    protected abstract void handleBoundsForParamBinding(DesignElement var1, Module var2, String var3);

    protected static String getLocalStringProperty(Module module, DesignElement tmpElement, String propName) {
        ElementPropertyDefn prop = tmpElement.getPropertyDefn(propName);
        if (prop == null) {
            return null;
        }
        Object value = tmpElement.getLocalProperty(module, prop);
        return prop.getStringValue(module, value);
    }
}

