/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.birt.report.model.util.XMLParserPool;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class XMLParserPoolImpl
implements XMLParserPool {
    private static final int SAXPARSER_DEFAULT_SIZE = 300;
    private static Logger logger = Logger.getLogger(XMLParserPoolImpl.class.getName());
    private final Map<Set<?>, List<SAXParser>> parserCache = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SAXParser get(Map<String, ?> properties) throws ParserConfigurationException, SAXException {
        Set<String> keys = null;
        if (properties != null) {
            keys = properties.keySet();
        }
        XMLParserPoolImpl xMLParserPoolImpl = this;
        synchronized (xMLParserPoolImpl) {
            List<SAXParser> list = this.parserCache.get(keys);
            if (list != null) {
                int size = list.size();
                if (size > 0) {
                    return list.remove(size - 1);
                }
            } else {
                this.parserCache.put(keys, new ArrayList());
            }
        }
        return this.createParser(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void release(SAXParser parser, Map<String, ?> properties) {
        assert (parser != null);
        Set<String> keys = null;
        if (properties != null) {
            keys = properties.keySet();
        }
        XMLParserPoolImpl xMLParserPoolImpl = this;
        synchronized (xMLParserPoolImpl) {
            List<SAXParser> list = this.parserCache.get(keys);
            int currentSize = list.size();
            if (currentSize < 300) {
                list.add(parser);
            }
        }
    }

    private SAXParser createParser(Map<String, ?> properties) throws ParserConfigurationException, SAXException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser parser = factory.newSAXParser();
        if (properties != null) {
            for (Map.Entry<String, ?> entry : properties.entrySet()) {
                parser.getXMLReader().setProperty(entry.getKey(), entry.getValue());
            }
        }
        logger.log(Level.FINEST, "created a new SAX parser");
        return parser;
    }
}

