/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc.dbprofile.sampledb.internal.impl;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.birt.report.data.oda.jdbc.dbprofile.sampledb.internal.impl.ProfileDriverUtil;
import org.eclipse.birt.report.data.oda.jdbc.dbprofile.sampledb.nls.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public class SampleDbFactory
implements IExecutableExtension {
    static final String PLUGIN_ID = "org.eclipse.birt.report.data.oda.jdbc.dbprofile.sampledb";
    private static final String SAMPLEDB_PLUGIN_ID = "org.eclipse.birt.report.data.oda.sampledb";
    private static final String SAMPLE_DB_HOME_SUBDIR = "db";
    private static final String SAMPLE_DB_NAME = "BirtSample";
    private static final String SAMPLE_DB_JAR_FILE = "BirtSample.jar";
    private static final String SAMPLE_DB_LOG = "log";
    private static final String SAMPLE_DB_SEG = "seg0";
    private static final String PATH_SEPARATOR = "/";
    private static final String DRIVER_DEFN_NAME_KEY = "%driver.definition.name";
    private static final String SAMPLEDB_DRIVER_DEFN_DEFAULT_NAME = "BIRT SampleDb Derby Embedded Driver";
    private static final String SAMPLEDB_DRIVER_DEFN_RESOURCE_KEY = "%driver.definition.name BIRT SampleDb Derby Embedded Driver";

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        Bundle sampledbBundle = Platform.getBundle((String)SAMPLEDB_PLUGIN_ID);
        String stateLocation = Platform.getStateLocation((Bundle)Platform.getBundle((String)config.getDeclaringExtension().getNamespaceIdentifier())).toOSString();
        try {
            this.initSampleDb(sampledbBundle, stateLocation);
            this.removeObsoleteDriverDefinition();
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
            throw new CoreException((IStatus)new Status(4, PLUGIN_ID, ex.getLocalizedMessage(), (Throwable)ex));
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new CoreException((IStatus)new Status(4, PLUGIN_ID, ex.getLocalizedMessage(), (Throwable)ex));
        }
    }

    private void initSampleDb(Bundle sampledbBundle, String rootPath) throws IOException, IllegalArgumentException {
        ZipEntry entry;
        String dbJarEntryName;
        URL fileURL;
        if (sampledbBundle == null) {
            throw new IllegalArgumentException("null sampledbBundle");
        }
        if (rootPath == null || rootPath.length() == 0) {
            throw new IllegalArgumentException(Messages.bind((String)Messages.sampleDbFactory_invalidDirectory, (Object)rootPath));
        }
        File dbDir = new File(String.valueOf(rootPath) + PATH_SEPARATOR + SAMPLE_DB_HOME_SUBDIR);
        if (dbDir.exists()) {
            File[] subDir = dbDir.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.equals(SampleDbFactory.SAMPLE_DB_NAME);
                }
            });
            if (subDir == null || subDir.length > 1) {
                throw new IllegalArgumentException(Messages.bind((String)Messages.sampleDbFactory_invalidDirectory, (Object)dbDir.toString()));
            }
            if (subDir.length == 1) {
                File sampleDb = subDir[0];
                if (!sampleDb.isDirectory()) {
                    throw new IllegalArgumentException(Messages.bind((String)Messages.sampleDbFactory_invalidDirectory, (Object)sampleDb.toString()));
                }
                File[] sampleDbFiles = sampleDb.listFiles(new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return name.equals(SampleDbFactory.SAMPLE_DB_LOG) || name.equals(SampleDbFactory.SAMPLE_DB_SEG);
                    }
                });
                if (sampleDbFiles.length == 2) {
                    return;
                }
            }
        }
        if (!dbDir.exists()) {
            dbDir.mkdir();
        }
        if ((fileURL = sampledbBundle.getEntry(dbJarEntryName = "db/BirtSample.jar")) == null) {
            throw new RuntimeException(Messages.bind((String)Messages.sampleDbFactory_noSampleDbJarFile, (Object)dbJarEntryName));
        }
        BufferedInputStream dbFileStream = new BufferedInputStream(fileURL.openStream());
        ZipInputStream zipStream = new ZipInputStream(dbFileStream);
        while ((entry = zipStream.getNextEntry()) != null) {
            int len;
            File entryFile = new File(dbDir, entry.getName());
            if (entry.isDirectory()) {
                entryFile.mkdir();
                continue;
            }
            FileOutputStream os = new FileOutputStream(entryFile);
            byte[] buf = new byte[4000];
            while ((len = zipStream.read(buf)) > 0) {
                ((OutputStream)os).write(buf, 0, len);
            }
            ((OutputStream)os).close();
        }
        zipStream.close();
        ((InputStream)dbFileStream).close();
    }

    private void removeObsoleteDriverDefinition() {
        Bundle myBundle = Platform.getBundle((String)PLUGIN_ID);
        String driverDefnName = Platform.getResourceString((Bundle)myBundle, (String)SAMPLEDB_DRIVER_DEFN_RESOURCE_KEY);
        ProfileDriverUtil.removeInvalidDriverDefinition(driverDefnName);
    }
}

