/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DateTimeCommonAccessor;
import oracle.jdbc.driver.OracleStatement;
import oracle.sql.Datum;
import oracle.sql.TIMESTAMP;

class DateAccessor
extends DateTimeCommonAccessor {
    static final int maxLength = 7;

    DateAccessor(OracleStatement oracleStatement, int n, short s, int n2, boolean bl) throws SQLException {
        this.init(oracleStatement, 12, 12, s, bl);
        this.initForDataAccess(n2, n, null);
    }

    DateAccessor(OracleStatement oracleStatement, int n, boolean bl, int n2, int n3, int n4, int n5, int n6, short s) throws SQLException {
        this.init(oracleStatement, 12, 12, s, false);
        this.initForDescribe(12, n, bl, n2, n3, n4, n5, n6, s, null);
        this.initForDataAccess(0, n, null);
    }

    Object getObject(int n) throws SQLException {
        Date date = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1) {
            if (this.externalType == 0) {
                date = this.statement.connection.v8Compatible ? this.getTimestamp(n) : this.getDate(n);
            } else {
                switch (this.externalType) {
                    case 91: {
                        return this.getDate(n);
                    }
                    case 92: {
                        return this.getTime(n);
                    }
                    case 93: {
                        return this.getTimestamp(n);
                    }
                }
                DatabaseError.throwSqlException(4);
                return null;
            }
        }
        return date;
    }

    Object getObject(int n, Map map) throws SQLException {
        return this.getObject(n);
    }

    Datum getOracleObject(int n) throws SQLException {
        return this.getDATE(n);
    }

    String getString(int n) throws SQLException {
        String string = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1) {
            int n2 = this.columnIndex + this.byteLength * n;
            int n3 = ((this.rowSpaceByte[n2] & 0xFF) - 100) * 100 + (this.rowSpaceByte[1 + n2] & 0xFF) - 100;
            string = String.valueOf(n3) + "-" + DateAccessor.toStr(this.rowSpaceByte[2 + n2]) + "-" + DateAccessor.toStr(this.rowSpaceByte[3 + n2]) + " " + DateAccessor.toStr(this.rowSpaceByte[4 + n2] - 1) + ":" + DateAccessor.toStr(this.rowSpaceByte[5 + n2] - 1) + ":" + DateAccessor.toStr(this.rowSpaceByte[6 + n2] - 1) + ".0";
        }
        return string;
    }

    TIMESTAMP getTIMESTAMP(int n) throws SQLException {
        if (!this.statement.connection.v8Compatible || this.externalType != 93) {
            return super.getTIMESTAMP(n);
        }
        TIMESTAMP tIMESTAMP = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1) {
            short s = this.rowSpaceIndicator[this.lengthIndex + n];
            int n2 = this.columnIndex + this.byteLength * n;
            byte[] byArray = new byte[s];
            System.arraycopy(this.rowSpaceByte, n2, byArray, 0, s);
            tIMESTAMP = new TIMESTAMP(byArray);
        }
        return tIMESTAMP;
    }

    Timestamp getTimestamp(int n) throws SQLException {
        Timestamp timestamp = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1) {
            int n2 = this.columnIndex + this.byteLength * n;
            TimeZone timeZone = this.statement.getDefaultTimeZone();
            int n3 = ((this.rowSpaceByte[n2] & 0xFF) - 100) * 100 + (this.rowSpaceByte[1 + n2] & 0xFF) - 100;
            if (n3 <= 0) {
                ++n3;
            }
            timestamp = new Timestamp(DateTimeCommonAccessor.getMillis(n3, this.oracleMonth(n2), this.oracleDay(n2), this.oracleTime(n2), timeZone));
        }
        return timestamp;
    }

    void initForDataAccess(int n, int n2, String string) throws SQLException {
        if (n != 0) {
            this.externalType = n;
        }
        this.internalTypeMaxLength = 7;
        if (n2 > 0 && n2 < this.internalTypeMaxLength) {
            this.internalTypeMaxLength = n2;
        }
        this.byteLength = this.internalTypeMaxLength;
    }

    static String toStr(int n) {
        return n < 10 ? "0" + n : Integer.toString(n);
    }
}

