/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.transaction.xa.XAResource;
import oracle.jdbc.driver.ClosedConnection;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleCloseCallback;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.OracleStatement;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCLOB;
import oracle.jdbc.pool.OracleConnectionCacheCallback;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.BfileDBAccess;
import oracle.sql.BlobDBAccess;
import oracle.sql.CLOB;
import oracle.sql.ClobDBAccess;
import oracle.sql.CustomDatum;
import oracle.sql.Datum;
import oracle.sql.StructDescriptor;

class LogicalConnection
extends OracleConnection {
    static final ClosedConnection closedConnection = new ClosedConnection();
    PhysicalConnection internalConnection;
    OraclePooledConnection pooledConnection;
    boolean closed;
    OracleCloseCallback closeCallback = null;
    Object privateData = null;
    long startTime = 0L;
    OracleConnectionCacheCallback connectionCacheCallback = null;
    Object connectionCacheCallbackUserObj = null;
    int callbackFlag = 0;
    int releasePriority = 0;
    int heartbeatCount = 0;
    int heartbeatLastCount = 0;
    int heartbeatNoChangeCount = 0;
    boolean isAbandonedTimeoutEnabled = false;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jun_22_11:15:39_PDT_2005";

    LogicalConnection(OraclePooledConnection oraclePooledConnection, PhysicalConnection physicalConnection, boolean bl) throws SQLException {
        this.internalConnection = physicalConnection;
        this.pooledConnection = oraclePooledConnection;
        this.connection = this.internalConnection;
        this.connection.setWrapper(this);
        this.closed = false;
        this.internalConnection.setAutoCommit(bl);
    }

    public int CHARBytesToJavaChars(byte[] byArray, int n, char[] cArray) throws SQLException {
        return this.internalConnection.CHARBytesToJavaChars(byArray, n, cArray);
    }

    public boolean IsNCharFixedWith() {
        return this.internalConnection.IsNCharFixedWith();
    }

    public int NCHARBytesToJavaChars(byte[] byArray, int n, char[] cArray) throws SQLException {
        return this.internalConnection.NCHARBytesToJavaChars(byArray, n, cArray);
    }

    public Connection _getPC() {
        return this.internalConnection;
    }

    public void abort() throws SQLException {
        if (this.closed) {
            return;
        }
        this.internalConnection.abort();
        this.closed = true;
        this.internalConnection = closedConnection;
        this.connection = closedConnection;
    }

    public synchronized void applyConnectionAttributes(Properties properties) throws SQLException {
        if (this.pooledConnection != null) {
            ((Hashtable)this.pooledConnection.cachedConnectionAttributes).putAll(properties);
        }
    }

    public void cancel() throws SQLException {
        this.internalConnection.cancel();
    }

    public Class classForNameAndSchema(String string, String string2) throws ClassNotFoundException {
        return this.internalConnection.classForNameAndSchema(string, string2);
    }

    public void clearAllApplicationContext(String string) throws SQLException {
        this.internalConnection.clearAllApplicationContext(string);
    }

    public void clearClientIdentifier(String string) throws SQLException {
        this.internalConnection.clearClientIdentifier(string);
    }

    public synchronized void close() throws SQLException {
        this.closeInternal(true);
    }

    public synchronized void close(int n) throws SQLException {
        if ((n & 0x1000) != 0) {
            if (this.pooledConnection != null) {
                this.pooledConnection.closeOption = n;
            }
            this.close();
            return;
        }
        if ((n & 1) != 0) {
            this.internalConnection.close(1);
        }
    }

    public synchronized void close(Properties properties) throws SQLException {
        if (this.pooledConnection != null) {
            ((Hashtable)this.pooledConnection.cachedConnectionAttributes).clear();
            ((Hashtable)this.pooledConnection.cachedConnectionAttributes).putAll(properties);
        }
        this.close();
    }

    public void closeInternal(boolean bl) throws SQLException {
        if (this.closed) {
            return;
        }
        if (this.closeCallback != null) {
            this.closeCallback.beforeClose(this, this.privateData);
        }
        this.internalConnection.closeLogicalConnection();
        this.startTime = 0L;
        this.closed = true;
        if (this.pooledConnection != null && bl) {
            this.pooledConnection.logicalClose();
        }
        this.internalConnection = closedConnection;
        this.connection = closedConnection;
        if (this.closeCallback != null) {
            this.closeCallback.afterClose(this.privateData);
        }
    }

    public BFILE createBfile(byte[] byArray) throws SQLException {
        return this.internalConnection.createBfile(byArray);
    }

    public BfileDBAccess createBfileDBAccess() throws SQLException {
        return this.internalConnection.createBfileDBAccess();
    }

    public BLOB createBlob(byte[] byArray) throws SQLException {
        return this.internalConnection.createBlob(byArray);
    }

    public BlobDBAccess createBlobDBAccess() throws SQLException {
        return this.internalConnection.createBlobDBAccess();
    }

    public CLOB createClob(byte[] byArray) throws SQLException {
        return this.internalConnection.createClob(byArray);
    }

    public CLOB createClob(byte[] byArray, short s) throws SQLException {
        return this.internalConnection.createClob(byArray, s);
    }

    public ClobDBAccess createClobDBAccess() throws SQLException {
        return this.internalConnection.createClobDBAccess();
    }

    public Enumeration descriptorCacheKeys() {
        return this.internalConnection.descriptorCacheKeys();
    }

    public boolean getBigEndian() throws SQLException {
        return this.internalConnection.getBigEndian();
    }

    public int getC2SNlsRatio() {
        return this.internalConnection.getC2SNlsRatio();
    }

    public CallableStatement getCallWithKey(String string) throws SQLException {
        return this.internalConnection.getCallWithKey(string);
    }

    public Object getClientData(Object object) {
        return this.internalConnection.getClientData(object);
    }

    public synchronized Properties getConnectionAttributes() throws SQLException {
        if (this.pooledConnection != null) {
            return this.pooledConnection.cachedConnectionAttributes;
        }
        return null;
    }

    public int getConnectionCacheCallbackFlag() throws SQLException {
        return this.callbackFlag;
    }

    public OracleConnectionCacheCallback getConnectionCacheCallbackObj() throws SQLException {
        return this.connectionCacheCallback;
    }

    public Object getConnectionCacheCallbackPrivObj() throws SQLException {
        return this.connectionCacheCallbackUserObj;
    }

    public int getConnectionReleasePriority() throws SQLException {
        return this.releasePriority;
    }

    public Properties getDBAccessProperties() throws SQLException {
        return this.internalConnection.getDBAccessProperties();
    }

    public String getDatabaseProductVersion() throws SQLException {
        return this.internalConnection.getDatabaseProductVersion();
    }

    public short getDbCsId() throws SQLException {
        return this.internalConnection.getDbCsId();
    }

    public boolean getDefaultFixedString() {
        return this.internalConnection.getDefaultFixedString();
    }

    public Object getDescriptor(byte[] byArray) {
        return this.internalConnection.getDescriptor(byArray);
    }

    public short getDriverCharSet() {
        return this.internalConnection.getDriverCharSet();
    }

    public boolean getExplicitCachingEnabled() throws SQLException {
        return this.internalConnection.getExplicitCachingEnabled();
    }

    public byte[] getFDO(boolean bl) throws SQLException {
        return this.internalConnection.getFDO(bl);
    }

    public void getForm(OracleTypeADT oracleTypeADT, OracleTypeCLOB oracleTypeCLOB, int n) throws SQLException {
        this.internalConnection.getForm(oracleTypeADT, oracleTypeCLOB, n);
    }

    public int getHeapAllocSize() throws SQLException {
        return this.internalConnection.getHeapAllocSize();
    }

    public int getHeartbeatNoChangeCount() throws SQLException {
        if (this.heartbeatCount == this.heartbeatLastCount) {
            ++this.heartbeatNoChangeCount;
        } else {
            this.heartbeatLastCount = this.heartbeatCount;
            this.heartbeatNoChangeCount = 0;
        }
        return this.heartbeatNoChangeCount;
    }

    public boolean getImplicitCachingEnabled() throws SQLException {
        return this.internalConnection.getImplicitCachingEnabled();
    }

    public boolean getIncludeSynonyms() {
        return this.internalConnection.getIncludeSynonyms();
    }

    public Map getJavaObjectTypeMap() {
        return this.internalConnection.getJavaObjectTypeMap();
    }

    public short getJdbcCsId() throws SQLException {
        return this.internalConnection.getJdbcCsId();
    }

    public Connection getLogicalConnection(OraclePooledConnection oraclePooledConnection, boolean bl) throws SQLException {
        DatabaseError.throwSqlException(153);
        return null;
    }

    public int getMaxCharSize() throws SQLException {
        return this.internalConnection.getMaxCharSize();
    }

    public int getMaxCharbyteSize() {
        return this.internalConnection.getMaxCharbyteSize();
    }

    public int getMaxNCharbyteSize() {
        return this.internalConnection.getMaxNCharbyteSize();
    }

    public short getNCharSet() {
        return this.internalConnection.getNCharSet();
    }

    public int getOCIEnvHeapAllocSize() throws SQLException {
        return this.internalConnection.getOCIEnvHeapAllocSize();
    }

    public Properties getOCIHandles() throws SQLException {
        return this.internalConnection.getOCIHandles();
    }

    public void getOracleTypeADT(OracleTypeADT oracleTypeADT) throws SQLException {
        this.internalConnection.getOracleTypeADT(oracleTypeADT);
    }

    public oracle.jdbc.internal.OracleConnection getPhysicalConnection() {
        return this.internalConnection;
    }

    public void getPropertyForPooledConnection(OraclePooledConnection oraclePooledConnection) throws SQLException {
        DatabaseError.throwSqlException(153);
    }

    public String getProtocolType() {
        return this.internalConnection.getProtocolType();
    }

    public boolean getRemarksReporting() {
        return this.internalConnection.getRemarksReporting();
    }

    public boolean getRestrictGetTables() {
        return this.internalConnection.getRestrictGetTables();
    }

    public Properties getServerSessionInfo() throws SQLException {
        return this.internalConnection.getServerSessionInfo();
    }

    public long getStartTime() throws SQLException {
        return this.startTime;
    }

    public int getStatementCacheSize() throws SQLException {
        return this.internalConnection.getStatementCacheSize();
    }

    public PreparedStatement getStatementWithKey(String string) throws SQLException {
        return this.internalConnection.getStatementWithKey(string);
    }

    public int getStmtCacheSize() {
        return this.internalConnection.getStmtCacheSize();
    }

    public short getStructAttrNCsId() throws SQLException {
        return this.internalConnection.getStructAttrNCsId();
    }

    public long getTdoCState(String string, String string2) throws SQLException {
        return this.internalConnection.getTdoCState(string, string2);
    }

    public int getTxnMode() {
        return this.internalConnection.getTxnMode();
    }

    public Map getTypeMap() throws SQLException {
        return this.internalConnection.getTypeMap();
    }

    public String getURL() throws SQLException {
        return this.internalConnection.getURL();
    }

    public synchronized Properties getUnMatchedConnectionAttributes() throws SQLException {
        if (this.pooledConnection != null) {
            return this.pooledConnection.unMatchedCachedConnAttr;
        }
        return null;
    }

    public short getVersionNumber() throws SQLException {
        return this.internalConnection.getVersionNumber();
    }

    public oracle.jdbc.OracleConnection getWrapper() {
        return this;
    }

    public XAResource getXAResource() throws SQLException {
        return this.pooledConnection.getXAResource();
    }

    public boolean isCharSetMultibyte(short s) {
        return this.internalConnection.isCharSetMultibyte(s);
    }

    public synchronized boolean isClosed() throws SQLException {
        return this.closed;
    }

    public boolean isDescriptorSharable(oracle.jdbc.internal.OracleConnection oracleConnection) throws SQLException {
        return this.internalConnection.isDescriptorSharable(oracleConnection);
    }

    public synchronized boolean isLogicalConnection() {
        return true;
    }

    public boolean isStatementCacheInitialized() {
        return this.internalConnection.isStatementCacheInitialized();
    }

    public boolean isV8Compatible() throws SQLException {
        return this.internalConnection.isV8Compatible();
    }

    public int javaCharsToCHARBytes(char[] cArray, int n, byte[] byArray) throws SQLException {
        return this.internalConnection.javaCharsToCHARBytes(cArray, n, byArray);
    }

    public int javaCharsToNCHARBytes(char[] cArray, int n, byte[] byArray) throws SQLException {
        return this.internalConnection.javaCharsToNCHARBytes(cArray, n, byArray);
    }

    public ResultSet newArrayDataResultSet(ARRAY aRRAY, long l, int n, Map map) throws SQLException {
        return this.internalConnection.newArrayDataResultSet(aRRAY, l, n, map);
    }

    public ResultSet newArrayDataResultSet(Datum[] datumArray, long l, int n, Map map) throws SQLException {
        return this.internalConnection.newArrayDataResultSet(datumArray, l, n, map);
    }

    public ResultSet newArrayLocatorResultSet(ArrayDescriptor arrayDescriptor, byte[] byArray, long l, int n, Map map) throws SQLException {
        return this.internalConnection.newArrayLocatorResultSet(arrayDescriptor, byArray, l, n, map);
    }

    public ResultSetMetaData newStructMetaData(StructDescriptor structDescriptor) throws SQLException {
        return this.internalConnection.newStructMetaData(structDescriptor);
    }

    public int numberOfDescriptorCacheEntries() {
        return this.internalConnection.numberOfDescriptorCacheEntries();
    }

    public oracle.jdbc.internal.OracleConnection physicalConnectionWithin() {
        return this.internalConnection;
    }

    public void purgeExplicitCache() throws SQLException {
        this.internalConnection.purgeExplicitCache();
    }

    public void purgeImplicitCache() throws SQLException {
        this.internalConnection.purgeImplicitCache();
    }

    public void putDescriptor(byte[] byArray, Object object) throws SQLException {
        this.internalConnection.putDescriptor(byArray, object);
    }

    public OracleStatement refCursorCursorToStatement(int n) throws SQLException {
        return this.internalConnection.refCursorCursorToStatement(n);
    }

    public synchronized void registerCloseCallback(OracleCloseCallback oracleCloseCallback, Object object) {
        this.closeCallback = oracleCloseCallback;
        this.privateData = object;
    }

    public synchronized void registerConnectionCacheCallback(OracleConnectionCacheCallback oracleConnectionCacheCallback, Object object, int n) throws SQLException {
        this.connectionCacheCallback = oracleConnectionCacheCallback;
        this.connectionCacheCallbackUserObj = object;
        this.callbackFlag = n;
    }

    void registerHeartbeat() throws SQLException {
        block2: {
            if (!this.isAbandonedTimeoutEnabled) break block2;
            try {
                ++this.heartbeatCount;
            }
            catch (ArithmeticException arithmeticException) {
                this.heartbeatCount = 0;
            }
        }
    }

    public void removeAllDescriptor() {
        this.internalConnection.removeAllDescriptor();
    }

    public Object removeClientData(Object object) {
        return this.internalConnection.removeClientData(object);
    }

    public void removeDescriptor(String string) {
        this.internalConnection.removeDescriptor(string);
    }

    public synchronized void setAbandonedTimeoutEnabled(boolean bl) throws SQLException {
        this.isAbandonedTimeoutEnabled = true;
    }

    public void setApplicationContext(String string, String string2, String string3) throws SQLException {
        this.internalConnection.setApplicationContext(string, string2, string3);
    }

    public Object setClientData(Object object, Object object2) {
        return this.internalConnection.setClientData(object, object2);
    }

    public void setClientIdentifier(String string) throws SQLException {
        this.internalConnection.setClientIdentifier(string);
    }

    public synchronized void setConnectionReleasePriority(int n) throws SQLException {
        this.releasePriority = n;
    }

    public void setDefaultFixedString(boolean bl) {
        this.internalConnection.setDefaultFixedString(bl);
    }

    public void setFDO(byte[] byArray) throws SQLException {
        this.internalConnection.setFDO(byArray);
    }

    public void setJavaObjectTypeMap(Map map) {
        this.internalConnection.setJavaObjectTypeMap(map);
    }

    public void setStartTime(long l) throws SQLException {
        if (l <= 0L) {
            DatabaseError.throwSqlException(68);
        } else {
            this.startTime = l;
        }
    }

    public void setTxnMode(int n) {
        this.internalConnection.setTxnMode(n);
    }

    public void setTypeMap(Map map) {
        this.internalConnection.setTypeMap(map);
    }

    public Datum toDatum(CustomDatum customDatum) throws SQLException {
        return this.internalConnection.toDatum(customDatum);
    }
}

