/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;

public class OracleBufferedStream
extends InputStream {
    byte[] buf;
    int pos = 0;
    int count = 0;
    boolean closed = false;
    int chunkSize;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jun_22_11:15:40_PDT_2005";

    public OracleBufferedStream(int n) {
        this.chunkSize = n;
        this.buf = new byte[n];
    }

    public int available() throws IOException {
        if (this.closed || this.isNull()) {
            return 0;
        }
        return this.count - this.pos;
    }

    public void close() throws IOException {
        this.closed = true;
    }

    public int flushBytes(int n) {
        int n2 = n > this.count - this.pos ? this.count - this.pos : n;
        this.pos += n2;
        return n2;
    }

    public boolean isNull() throws IOException {
        return false;
    }

    public synchronized void mark(int n) {
    }

    public boolean markSupported() {
        return false;
    }

    public boolean needBytes() throws IOException {
        throw new IOException("You should not call this method");
    }

    public synchronized int read() throws IOException {
        if (this.closed || this.isNull()) {
            return -1;
        }
        if (this.needBytes()) {
            return this.buf[this.pos++] & 0xFF;
        }
        return -1;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = n;
        if (this.closed || this.isNull()) {
            return -1;
        }
        int n4 = n2 > byArray.length ? n3 + byArray.length : n3 + n2;
        if (!this.needBytes()) {
            return -1;
        }
        n3 += this.writeBytes(byArray, n3, n4 - n3);
        while (n3 < n4 && this.needBytes()) {
            n3 += this.writeBytes(byArray, n3, n4 - n3);
        }
        return n3 - n;
    }

    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    /*
     * Unable to fully structure code
     */
    public long skip(int var1_1) throws IOException {
        var2_2 = 0;
        var3_3 = var1_1;
        if (this.closed || this.isNull()) {
            return -1L;
        }
        if (this.needBytes()) ** GOTO lbl8
        return -1L;
lbl-1000:
        // 1 sources

        {
            var2_2 += this.flushBytes(var3_3 - var2_2);
lbl8:
            // 2 sources

            ** while (var2_2 < var3_3 && this.needBytes())
        }
lbl9:
        // 1 sources

        return var2_2;
    }

    public int writeBytes(byte[] byArray, int n, int n2) {
        int n3 = n2 > this.count - this.pos ? this.count - this.pos : n2;
        System.arraycopy(this.buf, this.pos, byArray, n, n3);
        this.pos += n3;
        return n3;
    }
}

