/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleBufferedStream;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.sql.CLOB;

public class OracleClobInputStream
extends OracleBufferedStream {
    protected long lobOffset;
    protected CLOB clob;
    protected long markedByte;
    protected boolean endOfStream;
    protected char[] charBuf;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jun_22_11:15:40_PDT_2005";

    public OracleClobInputStream(CLOB cLOB) throws SQLException {
        this(cLOB, ((PhysicalConnection)cLOB.getJavaSqlConnection()).getDefaultStreamChunkSize(), 1L);
    }

    public OracleClobInputStream(CLOB cLOB, int n) throws SQLException {
        this(cLOB, n, 1L);
    }

    public OracleClobInputStream(CLOB cLOB, int n, long l) throws SQLException {
        super(n);
        if (cLOB == null || n <= 0 || l < 1L) {
            throw new IllegalArgumentException("Illegal Arguments");
        }
        this.lobOffset = l;
        this.clob = cLOB;
        this.markedByte = -1L;
        this.endOfStream = false;
        this.charBuf = new char[n];
    }

    protected void ensureOpen() throws IOException {
        try {
            if (this.closed) {
                DatabaseError.throwSqlException(57, null);
            }
        }
        catch (SQLException sQLException) {
            DatabaseError.SQLToIOException(sQLException);
        }
    }

    public synchronized void mark(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Read-ahead limit < 0");
        }
        this.markedByte = this.lobOffset - (long)this.count + (long)this.pos;
    }

    public boolean markSupported() {
        return true;
    }

    public boolean needBytes() throws IOException {
        this.ensureOpen();
        if (this.pos >= this.count) {
            if (!this.endOfStream) {
                try {
                    this.count = this.clob.getChars(this.lobOffset, this.chunkSize, this.charBuf);
                    int n = 0;
                    while (n < this.count) {
                        this.buf[n] = (byte)this.charBuf[n];
                        ++n;
                    }
                    if (this.count < this.chunkSize) {
                        this.endOfStream = true;
                    }
                    if (this.count > 0) {
                        this.pos = 0;
                        this.lobOffset += (long)this.count;
                        return true;
                    }
                }
                catch (SQLException sQLException) {
                    DatabaseError.SQLToIOException(sQLException);
                }
            }
            return false;
        }
        return true;
    }

    public synchronized void reset() throws IOException {
        this.ensureOpen();
        if (this.markedByte < 0L) {
            throw new IOException("Mark invalid or stream not marked.");
        }
        this.lobOffset = this.markedByte;
        this.pos = this.count;
        this.endOfStream = false;
    }

    public long skip(long l) throws IOException {
        long l2;
        block5: {
            this.ensureOpen();
            l2 = 0L;
            if ((long)(this.count - this.pos) >= l) {
                this.pos = (int)((long)this.pos + l);
                l2 += l;
            } else {
                l2 += (long)(this.count - this.pos);
                this.pos = this.count;
                try {
                    long l3 = 0L;
                    l3 = this.clob.length() - this.lobOffset + 1L;
                    if (l3 >= l - l2) {
                        this.lobOffset += l - l2;
                        l2 += l - l2;
                        break block5;
                    }
                    this.lobOffset += l3;
                    l2 += l3;
                }
                catch (SQLException sQLException) {
                    DatabaseError.SQLToIOException(sQLException);
                }
            }
        }
        return l2;
    }
}

