/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.ScrollRsetStatement;
import oracle.jdbc.driver.ScrollableResultSet;

class SensitiveScrollableResultSet
extends ScrollableResultSet {
    int beginLastFetchedIndex;
    int endLastFetchedIndex;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jun_22_11:15:43_PDT_2005";

    SensitiveScrollableResultSet(ScrollRsetStatement scrollRsetStatement, OracleResultSetImpl oracleResultSetImpl, int n, int n2) throws SQLException {
        super(scrollRsetStatement, oracleResultSetImpl, n, n2);
        int n3 = oracleResultSetImpl.getValidRows();
        if (n3 > 0) {
            this.beginLastFetchedIndex = 1;
            this.endLastFetchedIndex = n3;
        } else {
            this.beginLastFetchedIndex = 0;
            this.endLastFetchedIndex = 0;
        }
    }

    public synchronized boolean absolute(int n) throws SQLException {
        if (super.absolute(n)) {
            this.handle_refetch();
            return true;
        }
        return false;
    }

    public synchronized boolean first() throws SQLException {
        if (super.first()) {
            this.handle_refetch();
            return true;
        }
        return false;
    }

    private boolean handle_refetch() throws SQLException {
        if (this.currentRow >= this.beginLastFetchedIndex && this.currentRow <= this.endLastFetchedIndex || this.currentRow >= this.endLastFetchedIndex && this.currentRow <= this.beginLastFetchedIndex) {
            return false;
        }
        this.refreshRow();
        return true;
    }

    public synchronized boolean last() throws SQLException {
        if (super.last()) {
            this.handle_refetch();
            return true;
        }
        return false;
    }

    public synchronized boolean next() throws SQLException {
        if (super.next()) {
            this.handle_refetch();
            return true;
        }
        return false;
    }

    public synchronized boolean previous() throws SQLException {
        if (super.previous()) {
            this.handle_refetch();
            return true;
        }
        return false;
    }

    public synchronized void refreshRow() throws SQLException {
        if (!this.isValidRow(this.currentRow)) {
            DatabaseError.throwSqlException(11);
        }
        int n = this.getFetchDirection();
        int n2 = 0;
        try {
            n2 = this.refreshRowsInCache(this.currentRow, this.getFetchSize(), n);
        }
        catch (SQLException sQLException) {
            DatabaseError.throwSqlException(sQLException, 90, "Unsupported syntax for refreshRow()");
        }
        if (n2 != 0) {
            this.beginLastFetchedIndex = this.currentRow;
            this.endLastFetchedIndex = this.currentRow + n2 - 1;
        }
    }

    public synchronized boolean relative(int n) throws SQLException {
        if (super.relative(n)) {
            this.handle_refetch();
            return true;
        }
        return false;
    }

    synchronized int removeRowInCache(int n) throws SQLException {
        int n2 = super.removeRowInCache(n);
        if (n2 != 0) {
            if (n >= this.beginLastFetchedIndex && n <= this.endLastFetchedIndex && this.beginLastFetchedIndex != this.endLastFetchedIndex) {
                --this.endLastFetchedIndex;
            } else {
                this.endLastFetchedIndex = 0;
                this.beginLastFetchedIndex = 0;
            }
        }
        return n2;
    }
}

