/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.LongRawAccessor;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CTTIoer;
import oracle.net.ns.BreakNetException;

class T4CLongRawAccessor
extends LongRawAccessor {
    T4CMAREngine mare;
    byte[][] data = null;
    int[] nbBytesRead = null;
    int[] bytesReadSoFar = null;
    final int[] escapeSequenceArr = new int[1];
    final boolean[] readHeaderArr = new boolean[1];
    final boolean[] readAsNonStreamArr = new boolean[1];
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jun_22_11:15:46_PDT_2005";

    T4CLongRawAccessor(OracleStatement oracleStatement, int n, int n2, short s, int n3, T4CMAREngine t4CMAREngine) throws SQLException {
        super(oracleStatement, n, n2, s, n3);
        this.mare = t4CMAREngine;
        if (oracleStatement.connection.useFetchSizeWithLongColumn) {
            this.data = new byte[oracleStatement.rowPrefetch][];
            int n4 = 0;
            while (n4 < oracleStatement.rowPrefetch) {
                this.data[n4] = new byte[4080];
                ++n4;
            }
            this.nbBytesRead = new int[oracleStatement.rowPrefetch];
            this.bytesReadSoFar = new int[oracleStatement.rowPrefetch];
        }
    }

    T4CLongRawAccessor(OracleStatement oracleStatement, int n, int n2, boolean bl, int n3, int n4, int n5, int n6, int n7, short s, int n8, int n9, T4CMAREngine t4CMAREngine) throws SQLException {
        super(oracleStatement, n, n2, bl, n3, n4, n5, n6, n7, s);
        this.mare = t4CMAREngine;
        this.definedColumnType = n8;
        this.definedColumnSize = n9;
        if (oracleStatement.connection.useFetchSizeWithLongColumn) {
            this.data = new byte[oracleStatement.rowPrefetch][];
            int n10 = 0;
            while (n10 < oracleStatement.rowPrefetch) {
                this.data[n10] = new byte[4080];
                ++n10;
            }
            this.nbBytesRead = new int[oracleStatement.rowPrefetch];
            this.bytesReadSoFar = new int[oracleStatement.rowPrefetch];
        }
    }

    void fetchNextColumns() throws SQLException {
        this.statement.continueReadRow(this.columnPosition);
    }

    String getString(int n) throws SQLException {
        String string = super.getString(n);
        if (string != null && this.definedColumnSize > 0 && string.length() > this.definedColumnSize * 2) {
            string = string.substring(0, this.definedColumnSize * 2);
        }
        return string;
    }

    void processIndicator(int n) throws IOException, SQLException {
        if (this.internalType == 1 && this.describeType == 112 || this.internalType == 23 && this.describeType == 113) {
            this.mare.unmarshalUB2();
            this.mare.unmarshalUB2();
        } else if (this.mare.versionNumber < 9200) {
            this.mare.unmarshalSB2();
            if (this.statement.sqlKind != 1 && this.statement.sqlKind != 4) {
                this.mare.unmarshalSB2();
            }
        } else if (this.statement.sqlKind == 1 || this.statement.sqlKind == 4 || this.isDMLReturnedParam) {
            this.mare.processIndicator(n <= 0, n);
        }
    }

    int readStream(byte[] byArray, int n) throws SQLException, IOException {
        int n2 = this.statement.currentRow;
        if (this.statement.connection.useFetchSizeWithLongColumn) {
            byte[] byArray2 = this.data[n2];
            int n3 = this.bytesReadSoFar[n2];
            int n4 = this.nbBytesRead[n2];
            if (n3 == n4) {
                return -1;
            }
            int n5 = 0;
            n5 = n <= n4 - n3 ? n : n4 - n3;
            System.arraycopy(byArray2, n3, byArray, 0, n5);
            int n6 = n2;
            this.bytesReadSoFar[n6] = this.bytesReadSoFar[n6] + n5;
            return n5;
        }
        int n7 = T4CLongRawAccessor.readStreamFromWire(byArray, 0, n, this.escapeSequenceArr, this.readHeaderArr, this.readAsNonStreamArr, this.mare, ((T4CConnection)this.statement.connection).oer);
        return n7;
    }

    protected static final int readStreamFromWire(byte[] byArray, int n, int n2, int[] nArray, boolean[] blArray, boolean[] blArray2, T4CMAREngine t4CMAREngine, T4CTTIoer t4CTTIoer) throws SQLException, IOException {
        int n3;
        block13: {
            n3 = -1;
            try {
                if (!blArray2[0]) {
                    if (n2 > 255 || n2 < 0) {
                        DatabaseError.throwSqlException(433);
                    }
                    if (blArray[0]) {
                        if (nArray[0] == 254) {
                            n3 = t4CMAREngine.unmarshalUB1();
                        } else {
                            if (nArray[0] == 0) {
                                return 0;
                            }
                            blArray2[0] = true;
                            n3 = nArray[0];
                        }
                        blArray[0] = false;
                        nArray[0] = 0;
                    } else {
                        n3 = t4CMAREngine.unmarshalUB1();
                    }
                } else {
                    blArray2[0] = false;
                }
                if (n3 > 0) {
                    t4CMAREngine.unmarshalNBytes(byArray, n, n3);
                } else {
                    n3 = -1;
                }
            }
            catch (BreakNetException breakNetException) {
                n3 = t4CMAREngine.unmarshalSB1();
                if (n3 != 4) break block13;
                t4CTTIoer.init();
                t4CTTIoer.processError();
            }
        }
        if (n3 == -1) {
            blArray[0] = true;
            t4CMAREngine.unmarshalUB2();
            t4CMAREngine.unmarshalUB2();
        }
        return n3;
    }

    boolean unmarshalOneRow() throws SQLException, IOException {
        if (this.isUseLess) {
            ++this.lastRowProcessed;
            return false;
        }
        boolean bl = false;
        int n = this.indicatorIndex + this.lastRowProcessed;
        this.escapeSequenceArr[0] = this.mare.unmarshalUB1();
        if (this.mare.escapeSequenceNull(this.escapeSequenceArr[0])) {
            this.rowSpaceIndicator[n] = -1;
            this.mare.processIndicator(false, 0);
            int n2 = (int)this.mare.unmarshalUB4();
            bl = false;
            this.escapeSequenceArr[0] = 0;
            ++this.lastRowProcessed;
        } else {
            this.rowSpaceIndicator[n] = 0;
            this.readHeaderArr[0] = true;
            this.readAsNonStreamArr[0] = false;
            if (this.statement.connection.useFetchSizeWithLongColumn) {
                int n3 = 0;
                while (n3 != -1) {
                    if (this.data[this.lastRowProcessed].length < this.nbBytesRead[this.lastRowProcessed] + 255) {
                        byte[] byArray = new byte[this.data[this.lastRowProcessed].length * 4];
                        System.arraycopy(this.data[this.lastRowProcessed], 0, byArray, 0, this.nbBytesRead[this.lastRowProcessed]);
                        this.data[this.lastRowProcessed] = byArray;
                    }
                    if ((n3 = T4CLongRawAccessor.readStreamFromWire(this.data[this.lastRowProcessed], this.nbBytesRead[this.lastRowProcessed], 255, this.escapeSequenceArr, this.readHeaderArr, this.readAsNonStreamArr, this.mare, ((T4CConnection)this.statement.connection).oer)) == -1) continue;
                    int n4 = this.lastRowProcessed;
                    this.nbBytesRead[n4] = this.nbBytesRead[n4] + n3;
                }
                ++this.lastRowProcessed;
            } else {
                bl = true;
            }
        }
        return bl;
    }
}

