/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;

public class Util {
    private static int[] ldsRoundTable;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jun_22_11:15:38_PDT_2005";

    static {
        int[] nArray = new int[9];
        nArray[1] = 1;
        nArray[3] = 2;
        nArray[7] = 3;
        ldsRoundTable = nArray;
        _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    }

    static void checkNextByte(InputStream inputStream, byte by) throws SQLException {
        try {
            if (inputStream.read() != by) {
                DatabaseError.throwSqlException(47, "parseTDS");
            }
        }
        catch (IOException iOException) {
            DatabaseError.throwSqlException(iOException);
        }
    }

    public static Object deserializeObject(byte[] byArray) throws IOException, ClassNotFoundException {
        if (byArray == null) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        return new ObjectInputStream(byteArrayInputStream).readObject();
    }

    static byte fdoGetAlign(byte[] byArray, int n) {
        byte by = Util.fdoGetEntry(byArray, n);
        return (byte)(by & 7);
    }

    private static byte fdoGetEntry(byte[] byArray, int n) {
        short s = Util.getUnsignedByte(byArray[5]);
        byte by = byArray[6 + s + n];
        return by;
    }

    static byte fdoGetSize(byte[] byArray, int n) {
        byte by = Util.fdoGetEntry(byArray, n);
        return (byte)(by >> 3 & 0x1F);
    }

    public static short getUnsignedByte(byte by) {
        return (short)(by & 0xFF);
    }

    static int ldsRound(int n, int n2) {
        int n3 = ldsRoundTable[n2];
        return (n >> n3) + 1 << n3;
    }

    public static void printByteArray(byte[] byArray) {
        System.out.println("DONT CALL THIS -- oracle.jdbc.oracore.Util.printByteArray");
    }

    static byte readByte(InputStream inputStream) throws SQLException {
        try {
            return (byte)inputStream.read();
        }
        catch (IOException iOException) {
            DatabaseError.throwSqlException(iOException);
            return 0;
        }
    }

    static byte[] readBytes(InputStream inputStream, int n) throws SQLException {
        byte[] byArray = new byte[n];
        try {
            int n2 = inputStream.read(byArray);
            if (n2 != n) {
                byte[] byArray2 = new byte[n2];
                System.arraycopy(byArray, 0, byArray2, 0, n2);
                return byArray2;
            }
        }
        catch (IOException iOException) {
            DatabaseError.throwSqlException(iOException);
        }
        return byArray;
    }

    static long readLong(InputStream inputStream) throws SQLException {
        byte[] byArray = new byte[4];
        try {
            inputStream.read(byArray);
            return (((byArray[0] & 0xFF) * 256 + (byArray[1] & 0xFF)) * 256 + (byArray[2] & 0xFF)) * 256 + (byArray[3] & 0xFF);
        }
        catch (IOException iOException) {
            DatabaseError.throwSqlException(iOException);
            return 0L;
        }
    }

    static short readShort(InputStream inputStream) throws SQLException {
        byte[] byArray = new byte[2];
        try {
            inputStream.read(byArray);
            return (short)((byArray[0] & 0xFF) * 256 + (byArray[1] & 0xFF));
        }
        catch (IOException iOException) {
            DatabaseError.throwSqlException(iOException);
            return 0;
        }
    }

    public static byte[] serializeObject(Object object) throws IOException {
        if (object == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(object);
        objectOutputStream.flush();
        return byteArrayOutputStream.toByteArray();
    }

    static void skipBytes(InputStream inputStream, int n) throws SQLException {
        try {
            inputStream.skip(n);
        }
        catch (IOException iOException) {
            DatabaseError.throwSqlException(iOException);
        }
    }

    public static int[] toJavaUnsignedBytes(byte[] byArray) {
        int[] nArray = new int[byArray.length];
        int n = 0;
        while (n < byArray.length) {
            nArray[n] = byArray[n] & 0xFF;
            ++n;
        }
        return nArray;
    }

    static void writeBytes(OutputStream outputStream, byte[] byArray) throws SQLException {
        try {
            outputStream.write(byArray);
        }
        catch (IOException iOException) {
            DatabaseError.throwSqlException(iOException);
        }
    }
}

