/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.jdbc.rowset.OracleCachedRowSet;
import oracle.jdbc.rowset.OracleWebRowSetXmlReader;
import oracle.jdbc.rowset.OracleWebRowSetXmlReaderImpl;
import oracle.jdbc.rowset.OracleWebRowSetXmlWriter;
import oracle.jdbc.rowset.OracleWebRowSetXmlWriterImpl;

public class OracleWebRowSet
extends OracleCachedRowSet {
    public static final String PUBLIC_XML_SCHEMA = "--//Sun Microsystems, Inc.//XSD Schema//EN";
    public static final String SCHEMA_SYSTEM_ID = "http://java.sun.com/xml/ns/jdbc/webrowset.xsd";
    private transient OracleWebRowSetXmlReader xmlReader = new OracleWebRowSetXmlReaderImpl();
    private transient OracleWebRowSetXmlWriter xmlWriter = new OracleWebRowSetXmlWriterImpl();

    public OracleWebRowSet() throws SQLException {
        this.setReadOnly(false);
    }

    public void readXml(InputStream inputStream) throws SQLException {
        this.readXml(new InputStreamReader(inputStream));
    }

    public void readXml(Reader reader) throws SQLException {
        if (this.xmlReader == null) {
            throw new SQLException("Invalid reader");
        }
        this.xmlReader.readXML(this, reader);
    }

    public void writeXml(OutputStream outputStream) throws SQLException {
        this.writeXml(new OutputStreamWriter(outputStream));
    }

    public void writeXml(Writer writer) throws SQLException {
        if (this.xmlWriter == null) {
            throw new SQLException("Invalid writer");
        }
        this.xmlWriter.writeXML(this, writer);
    }

    public void writeXml(ResultSet resultSet, OutputStream outputStream) throws SQLException {
        this.writeXml(resultSet, new OutputStreamWriter(outputStream));
    }

    public void writeXml(ResultSet resultSet, Writer writer) throws SQLException {
        this.populate(resultSet);
        this.writeXml(writer);
    }
}

