/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nl;

import java.io.PrintStream;
import java.util.Vector;
import oracle.net.nl.InvalidSyntaxException;

public final class NVPair {
    public static int RHS_NONE = 0;
    public static int RHS_ATOM = 1;
    public static int RHS_LIST = 2;
    public static int LIST_REGULAR = 3;
    public static int LIST_COMMASEP = 4;
    private String _name;
    private int _rhsType;
    private String _atom;
    private Vector _list;
    private int _listType;
    private NVPair _parent;
    private String _linesep = System.getProperty("line.separator");

    public NVPair(String string) {
        this._name = string;
        this._atom = null;
        this._list = null;
        this._listType = LIST_REGULAR;
        this._parent = null;
        this._rhsType = RHS_NONE;
    }

    public NVPair(String string, String string2) throws InvalidSyntaxException {
        this(string);
        this.setAtom(string2);
    }

    public NVPair(String string, NVPair nVPair) {
        this(string);
        this.addListElement(nVPair);
    }

    private void _setParent(NVPair nVPair) {
        this._parent = nVPair;
    }

    public void addListElement(NVPair nVPair) {
        if (this._list == null) {
            this._rhsType = RHS_LIST;
            this._list = new Vector(3, 5);
            this._atom = null;
        }
        this._list.addElement(nVPair);
        nVPair._setParent(this);
    }

    private boolean containsComment(String string) {
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) == '#') {
                if (n != 0) {
                    if (string.charAt(n - 1) != '\\') {
                        return true;
                    }
                } else {
                    return true;
                }
            }
            ++n;
        }
        return false;
    }

    public String getAtom() {
        return this._atom;
    }

    public NVPair getListElement(int n) {
        if (this._list == null) {
            return null;
        }
        return (NVPair)this._list.elementAt(n);
    }

    public int getListSize() {
        if (this._list == null) {
            return 0;
        }
        return this._list.size();
    }

    public int getListType() {
        return this._listType;
    }

    public String getName() {
        return this._name;
    }

    public NVPair getParent() {
        return this._parent;
    }

    public int getRHSType() {
        return this._rhsType;
    }

    public String modifyCommentString(String string) {
        String string2 = "";
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '\\': {
                    if (string.charAt(n + 1) != '(' && string.charAt(n + 1) != '=' && string.charAt(n + 1) != ')' && string.charAt(n + 1) != ',' && string.charAt(n + 1) != '\\') break;
                }
            }
            int n2 = ++n;
            ++n;
            string2 = String.valueOf(string2) + string.charAt(n2);
        }
        return string2;
    }

    public void println() {
        System.out.println(this.toString());
    }

    public void println(PrintStream printStream) {
        if (this._rhsType == RHS_ATOM) {
            printStream.println("          (" + this._name + " = " + this._atom + ")");
        } else if (this._rhsType == RHS_LIST) {
            int n = 0;
            while (n < this.getListSize()) {
                this.getListElement(n).println(printStream);
                ++n;
            }
        }
    }

    public void removeListElement(int n) {
        if (this._list != null) {
            this._list.removeElementAt(n);
            if (this.getListSize() == 0) {
                this._list = null;
                this._rhsType = RHS_NONE;
            }
        }
    }

    public void setAtom(String string) throws InvalidSyntaxException {
        if (this._name.indexOf("COMMENT") == -1 && this.containsComment(string)) {
            Object[] objectArray = new Object[]{"#", this.getName()};
            throw new InvalidSyntaxException("UnexpectedChar-04603", objectArray);
        }
        this._rhsType = RHS_ATOM;
        this._atom = string;
        this._list = null;
    }

    public void setListType(int n) {
        this._listType = n;
    }

    public void setName(String string) {
        this._name = string;
    }

    private String space(int n) {
        String string = new String("");
        int n2 = 0;
        while (n2 < n) {
            string = String.valueOf(string) + " ";
            ++n2;
        }
        return string;
    }

    public String toString() {
        String string = "(" + this._name + "=";
        if (this._rhsType == RHS_ATOM) {
            string = String.valueOf(string) + this._atom;
        } else if (this._rhsType == RHS_LIST) {
            if (this._listType == LIST_REGULAR) {
                int n = 0;
                while (n < this.getListSize()) {
                    string = String.valueOf(string) + this.getListElement(n).toString();
                    ++n;
                }
            } else if (this._listType == LIST_COMMASEP) {
                string = String.valueOf(string) + " (";
                int n = 0;
                while (n < this.getListSize()) {
                    NVPair nVPair = this.getListElement(n);
                    string = String.valueOf(string) + nVPair.getName();
                    if (n != this.getListSize() - 1) {
                        string = String.valueOf(string) + ", ";
                    }
                    ++n;
                }
                string = String.valueOf(string) + ")";
            }
        }
        string = String.valueOf(string) + ")";
        return string;
    }

    public String toString(int n, boolean bl) {
        String string = "";
        String string2 = new String(this._name);
        if (this._rhsType == RHS_LIST) {
            if (this._listType == LIST_REGULAR) {
                String string3 = "";
                int n2 = 0;
                while (n2 < this.getListSize()) {
                    string3 = string2.equalsIgnoreCase("ADDRESS") || string2.equalsIgnoreCase("RULE") ? String.valueOf(string3) + this.getListElement(n2).toString(n + 1, false) : String.valueOf(string3) + this.getListElement(n2).toString(n + 1, true);
                    ++n2;
                }
                if (!string3.equals("")) {
                    string = string2.equalsIgnoreCase("ADDRESS") || string2.equalsIgnoreCase("RULE") ? String.valueOf(string) + this.space(n * 2) + "(" + this._name + " = " : String.valueOf(string) + this.space(n * 2) + "(" + this._name + " =" + this._linesep;
                    string = String.valueOf(string) + string3;
                    string = string2.equalsIgnoreCase("ADDRESS") || string2.equalsIgnoreCase("RULE") ? String.valueOf(string) + ")" + this._linesep : (n == 0 ? String.valueOf(string) + ")" : (n == 1 ? String.valueOf(string) + this.space(n * 2) + ")" : String.valueOf(string) + this.space(n * 2) + ")" + this._linesep));
                }
            } else if (this._listType == LIST_COMMASEP) {
                string = String.valueOf(string) + "(" + this._name + "=" + " (";
                int n3 = 0;
                while (n3 < this.getListSize()) {
                    NVPair nVPair = this.getListElement(n3);
                    string = String.valueOf(string) + nVPair.getName();
                    if (n3 != this.getListSize() - 1) {
                        string = String.valueOf(string) + ", ";
                    }
                    ++n3;
                }
                string = String.valueOf(string) + ")" + ")";
            }
        } else if (this._rhsType == RHS_ATOM) {
            if (n == 0) {
                if (string2.indexOf("COMMENT") != -1) {
                    this._atom = this.modifyCommentString(this._atom);
                    string = String.valueOf(string) + "(" + this._atom + ")";
                } else {
                    string = String.valueOf(string) + "(" + this._name + " = " + this._atom + ")";
                }
            } else if (string2.indexOf("COMMENT") != -1) {
                this._atom = this.modifyCommentString(this._atom);
                string = String.valueOf(string) + this._atom + this._linesep;
            } else if (!bl) {
                string = String.valueOf(string) + "(" + this._name + " = " + this._atom + ")";
            } else {
                string = String.valueOf(string) + this.space(n * 2) + "(" + this._name + " = " + this._atom + ")";
                string = String.valueOf(string) + this._linesep;
            }
        }
        return string;
    }

    public String trimValueToString() {
        String string = this.valueToString().trim();
        return string.substring(1, string.length() - 1);
    }

    public String valueToString() {
        String string;
        block4: {
            block5: {
                block3: {
                    string = "";
                    if (this._rhsType != RHS_ATOM) break block3;
                    string = String.valueOf(string) + this._atom;
                    break block4;
                }
                if (this._rhsType != RHS_LIST) break block4;
                if (this._listType != LIST_REGULAR) break block5;
                int n = 0;
                while (n < this.getListSize()) {
                    string = String.valueOf(string) + this.getListElement(n).toString();
                    ++n;
                }
                break block4;
            }
            if (this._listType != LIST_COMMASEP) break block4;
            int n = 0;
            while (n < this.getListSize()) {
                NVPair nVPair = this.getListElement(n);
                string = String.valueOf(string) + nVPair.getName();
                if (n != this.getListSize() - 1) {
                    string = String.valueOf(string) + ", ";
                }
                ++n;
            }
        }
        return string;
    }
}

