/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.computation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.birt.chart.computation.IConstants;
import org.eclipse.birt.chart.computation.Object3D;
import org.eclipse.birt.chart.computation.Vector;
import org.eclipse.birt.chart.event.Arc3DRenderEvent;
import org.eclipse.birt.chart.event.Area3DRenderEvent;
import org.eclipse.birt.chart.event.I3DRenderEvent;
import org.eclipse.birt.chart.event.Image3DRenderEvent;
import org.eclipse.birt.chart.event.Line3DRenderEvent;
import org.eclipse.birt.chart.event.Oval3DRenderEvent;
import org.eclipse.birt.chart.event.Polygon3DRenderEvent;
import org.eclipse.birt.chart.event.PrimitiveRenderEvent;
import org.eclipse.birt.chart.event.Text3DRenderEvent;
import org.eclipse.birt.chart.event.WrappedInstruction;
import org.eclipse.birt.chart.internal.computations.Matrix;
import org.eclipse.birt.chart.model.attribute.Angle3D;
import org.eclipse.birt.chart.model.attribute.AngleType;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.attribute.Rotation3D;
import org.eclipse.birt.chart.util.FillUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Engine3D
implements IConstants {
    public static final byte OUT_OF_RANGE_NONE = 0;
    public static final byte OUT_OF_RANGE_END = 1;
    public static final byte OUT_OF_RANGE_START = 2;
    public static final byte OUT_OF_RANGE_BOTH = 4;
    private double dViewerWidth;
    private double dViewerHeight;
    private double VIEW_DISTANCE = 200.0;
    private double MODEL_DISTANCE = 290.0;
    private double FRONT_DISTANCE = 20.0;
    private double BACK_DISTANCE = 600.0;
    private double PERSPECTIVE_VALUE = 100.0;
    private Vector[] PRP;
    private Vector[] PNV;
    private Vector COP;
    private Vector VDZ;
    private Vector VDY;
    private Vector VDX;
    private Vector LDR;
    private Rotation3D ROT;
    private Matrix V2M_MATRIX;
    private Matrix M2V_MATRIX;
    private Matrix C2V_MATRIX;
    private Matrix V2C_MATRIX;

    public Engine3D(Rotation3D rotation, Vector lightDirection, double viewerWidth, double viewerHeight, double viewingDistance, double modelingDistance, double hitherDistance, double yonDistance, double perspectiveDistance) {
        this.dViewerWidth = viewerWidth;
        this.dViewerHeight = viewerHeight;
        this.ROT = rotation.copyInstance();
        this.LDR = new Vector(lightDirection);
        this.VIEW_DISTANCE = viewingDistance;
        this.MODEL_DISTANCE = modelingDistance;
        this.FRONT_DISTANCE = hitherDistance;
        this.BACK_DISTANCE = yonDistance;
        this.PERSPECTIVE_VALUE = perspectiveDistance;
        this.reset();
    }

    public Engine3D(Rotation3D rotation, Vector lightDirection, double viewerWidth, double viewerHeight) {
        this.dViewerWidth = viewerWidth;
        this.dViewerHeight = viewerHeight;
        this.ROT = rotation.copyInstance();
        this.LDR = new Vector(lightDirection);
        this.reset();
    }

    public void reset() {
        this.COP = new Vector(0.0, 0.0, -this.MODEL_DISTANCE);
        this.VDX = new Vector(this.dViewerWidth / 2.0 / 100.0, 0.0, 0.0, false);
        this.VDY = new Vector(0.0, this.dViewerHeight / 2.0 / 100.0, 0.0, false);
        this.VDZ = new Vector(0.0, 0.0, this.VIEW_DISTANCE / 100.0, false);
        this.PNV = new Vector[6];
        this.PNV[0] = new Vector(0.0, 0.0, 1.0, false);
        this.PNV[1] = new Vector(0.0, 0.0, -1.0, false);
        this.PNV[2] = new Vector(0.0, -1.0, 1.0, false);
        this.PNV[3] = new Vector(0.0, 1.0, 1.0, false);
        this.PNV[4] = new Vector(1.0, 0.0, 1.0, false);
        this.PNV[5] = new Vector(-1.0, 0.0, 1.0, false);
        this.PRP = new Vector[6];
        this.PRP[0] = new Vector(0.0, 0.0, this.FRONT_DISTANCE);
        this.PRP[1] = new Vector(0.0, 0.0, this.BACK_DISTANCE);
        this.PRP[2] = new Vector(0.0, 0.0, 0.0);
        this.PRP[3] = new Vector(0.0, 0.0, 0.0);
        this.PRP[4] = new Vector(0.0, 0.0, 0.0);
        this.PRP[5] = new Vector(0.0, 0.0, 0.0);
        this.V2M_MATRIX = Matrix.identity(4, 4);
        this.M2V_MATRIX = Matrix.identity(4, 4);
        this.initViewModelMatrix();
        this.V2C_MATRIX = Matrix.identity(4, 4);
        this.C2V_MATRIX = Matrix.identity(4, 4);
        this.initViewCanvasMatrix();
    }

    private void initViewModelMatrix() {
        int i = 0;
        while (i < 4) {
            this.V2M_MATRIX.set(0, i, this.VDX.get(i));
            this.V2M_MATRIX.set(1, i, this.VDY.get(i));
            this.V2M_MATRIX.set(2, i, this.VDZ.get(i));
            this.V2M_MATRIX.set(3, i, this.COP.get(i));
            ++i;
        }
        this.M2V_MATRIX = this.V2M_MATRIX.copy().inverse();
    }

    private void initViewCanvasMatrix() {
        this.V2C_MATRIX.set(0, 0, this.dViewerWidth / 2.0 / 100.0);
        this.V2C_MATRIX.set(1, 1, -(this.dViewerHeight / 2.0) / 100.0);
        this.V2C_MATRIX.set(3, 0, this.dViewerWidth / 2.0);
        this.V2C_MATRIX.set(3, 1, this.dViewerHeight / 2.0);
        this.C2V_MATRIX = this.V2C_MATRIX.copy().inverse();
    }

    Vector model2View(Vector v) {
        return v.getMultiply(this.M2V_MATRIX);
    }

    Vector view2model(Vector v) {
        return v.getMultiply(this.V2M_MATRIX);
    }

    Vector canvas2View(Vector v) {
        return v.getMultiply(this.C2V_MATRIX);
    }

    Vector view2Canvas(Vector v) {
        return v.getMultiply(this.V2C_MATRIX);
    }

    Vector perspective(Vector v) {
        Vector nv = new Vector(v);
        nv.perspective(this.PERSPECTIVE_VALUE);
        return nv;
    }

    public void translate(Vector v) {
        this.COP.add(v);
        this.initViewModelMatrix();
    }

    Matrix rotateMatrixX(Matrix t, double degree) {
        Matrix m = Matrix.identity(4, 4);
        double radians = Math.toRadians(degree);
        double cos = Math.cos(radians);
        double sin = Math.sin(radians);
        m.set(1, 1, cos);
        m.set(2, 2, cos);
        m.set(1, 2, sin);
        m.set(2, 1, -sin);
        return t.times(m);
    }

    Matrix rotateMatrixY(Matrix t, double degree) {
        Matrix m = Matrix.identity(4, 4);
        double radians = Math.toRadians(degree);
        double cos = Math.cos(radians);
        double sin = Math.sin(radians);
        m.set(0, 0, cos);
        m.set(2, 2, cos);
        m.set(0, 2, -sin);
        m.set(2, 0, sin);
        return t.times(m);
    }

    Matrix rotateMatrixZ(Matrix t, double degree) {
        Matrix m = Matrix.identity(4, 4);
        double radians = Math.toRadians(degree);
        double cos = Math.cos(radians);
        double sin = Math.sin(radians);
        m.set(0, 0, cos);
        m.set(1, 1, cos);
        m.set(0, 1, sin);
        m.set(1, 0, -sin);
        return t.times(m);
    }

    Matrix translateMatrix(Matrix t, Vector v) {
        Matrix m = Matrix.identity(4, 4);
        m.set(3, 0, v.get(0));
        m.set(3, 1, v.get(1));
        m.set(3, 2, v.get(2));
        return t.times(m);
    }

    public byte checkClipping(Vector start, Vector end) {
        byte retval = 0;
        Vector v1 = new Vector();
        Vector v2 = new Vector();
        Vector clip_ptr = new Vector();
        int i = 0;
        while (i < 6) {
            v1.set(start.get(0), start.get(1), start.get(2));
            v1.sub(this.PRP[i]);
            v2.set(end.get(0), end.get(1), end.get(2));
            v2.sub(this.PRP[i]);
            double sp1 = v1.scalarProduct(this.PNV[i]);
            double sp2 = v2.scalarProduct(this.PNV[i]);
            if (sp1 < 0.0 && sp2 < 0.0) {
                return 4;
            }
            if (sp1 < 0.0 || sp2 < 0.0) {
                double fraction = Math.abs(sp1) / (Math.abs(sp1) + Math.abs(sp2));
                clip_ptr.set(end.get(0), end.get(1), end.get(2));
                clip_ptr.sub(start);
                clip_ptr.scale(fraction);
                clip_ptr.add(start);
                if (sp1 < 0.0) {
                    retval = (byte)(retval | 2);
                    start.set(clip_ptr.get(0), clip_ptr.get(1), clip_ptr.get(2));
                } else {
                    retval = (byte)(retval | 1);
                    end.set(clip_ptr.get(0), clip_ptr.get(1), clip_ptr.get(2));
                }
            }
            ++i;
        }
        return retval;
    }

    void transform(Vector[] va, Matrix m) {
        int i = 0;
        while (i < va.length) {
            va[i].multiply(m);
            ++i;
        }
    }

    boolean checkBehindFace(Polygon3DRenderEvent p3dre) {
        if (p3dre.isDoubleSided()) {
            return false;
        }
        Vector viewDirection = p3dre.getObject3D().getCenter();
        Vector normal = p3dre.getObject3D().getNormal();
        return normal.scalarProduct(viewDirection) <= 0.0;
    }

    Matrix getTransformMatrix() {
        Matrix m = Matrix.identity(4, 4);
        m.set(2, 2, -1.0);
        for (Angle3D agl : this.ROT.getAngles()) {
            if (agl.getType() == AngleType.NONE_LITERAL) {
                m = this.rotateMatrixY(m, agl.getYAngle());
                m = this.rotateMatrixX(m, agl.getXAngle());
                m = this.rotateMatrixZ(m, agl.getZAngle());
                continue;
            }
            switch (agl.getType().getValue()) {
                case 1: {
                    m = this.rotateMatrixX(m, agl.getAxisAngle());
                    break;
                }
                case 2: {
                    m = this.rotateMatrixY(m, agl.getAxisAngle());
                    break;
                }
                case 3: {
                    m = this.rotateMatrixZ(m, agl.getAxisAngle());
                }
            }
        }
        return m;
    }

    private boolean translate3DEvent(Object obj, Matrix transMatrix, double xOffset, double yOffset) {
        return this.translate3DEvent_clip_opt(obj, transMatrix, xOffset, yOffset, true);
    }

    private boolean translate3DEvent_clip_opt(Object obj, Matrix transMatrix, double xOffset, double yOffset, boolean bClip) {
        if (obj instanceof Polygon3DRenderEvent) {
            Polygon3DRenderEvent p3dre = (Polygon3DRenderEvent)obj;
            Object3D object3D = p3dre.getObject3D();
            object3D.transform(transMatrix);
            object3D.transform(this.M2V_MATRIX);
            object3D.prepareZSort();
            if (p3dre.isEnabled()) {
                boolean behind = this.checkBehindFace(p3dre);
                p3dre.setBehind(behind);
                if (p3dre.isBehind()) {
                    return false;
                }
            }
            double cosValue = object3D.getNormal().cosineValue(this.LDR);
            if (p3dre.isDoubleSided()) {
                cosValue = -Math.abs(cosValue);
            }
            double brightnessRatio = (1.0 - cosValue) / 2.0;
            p3dre.setBrightness(brightnessRatio);
            if (bClip) {
                object3D.clip(this);
            }
            if (object3D.getVectors().length < 3) {
                return false;
            }
            object3D.perspective(this.PERSPECTIVE_VALUE);
            object3D.transform(this.V2C_MATRIX);
            p3dre.prepare2D(xOffset, yOffset);
            return true;
        }
        if (obj instanceof Line3DRenderEvent) {
            Line3DRenderEvent l3dre = (Line3DRenderEvent)obj;
            if (l3dre.getLineAttributes() == null || !l3dre.getLineAttributes().isVisible()) {
                return false;
            }
            Object3D object3D = l3dre.getObject3D();
            object3D.transform(transMatrix);
            object3D.transform(this.M2V_MATRIX);
            object3D.prepareZSort();
            if (bClip) {
                object3D.clip(this);
            }
            if (object3D.getVectors().length < 2) {
                return false;
            }
            object3D.perspective(this.PERSPECTIVE_VALUE);
            object3D.transform(this.V2C_MATRIX);
            l3dre.prepare2D(xOffset, yOffset);
        } else if (obj instanceof Text3DRenderEvent) {
            Text3DRenderEvent t3dre = (Text3DRenderEvent)obj;
            Object3D object3D = t3dre.getObject3D();
            object3D.transform(transMatrix);
            object3D.transform(this.M2V_MATRIX);
            object3D.prepareZSort();
            if (bClip) {
                object3D.clip(this);
            }
            if (object3D.getVectors().length < 1) {
                return false;
            }
            object3D.perspective(this.PERSPECTIVE_VALUE);
            object3D.transform(this.V2C_MATRIX);
            t3dre.prepare2D(xOffset, yOffset);
        } else if (obj instanceof Oval3DRenderEvent) {
            Oval3DRenderEvent o3dre = (Oval3DRenderEvent)obj;
            Object3D object3D = o3dre.getObject3D();
            object3D.transform(transMatrix);
            object3D.transform(this.M2V_MATRIX);
            object3D.prepareZSort();
            if (bClip) {
                object3D.clip(this);
            }
            if (object3D.getVectors().length < 3) {
                return false;
            }
            object3D.perspective(this.PERSPECTIVE_VALUE);
            object3D.transform(this.V2C_MATRIX);
            o3dre.prepare2D(xOffset, yOffset);
        } else if (obj instanceof Image3DRenderEvent) {
            Image3DRenderEvent i3dre = (Image3DRenderEvent)obj;
            Object3D object3D = i3dre.getObject3D();
            object3D.transform(transMatrix);
            object3D.transform(this.M2V_MATRIX);
            object3D.prepareZSort();
            if (bClip) {
                object3D.clip(this);
            }
            if (object3D.getVectors().length < 1) {
                return false;
            }
            object3D.perspective(this.PERSPECTIVE_VALUE);
            object3D.transform(this.V2C_MATRIX);
            i3dre.prepare2D(xOffset, yOffset);
        } else if (obj instanceof Arc3DRenderEvent) {
            Arc3DRenderEvent a3dre = (Arc3DRenderEvent)obj;
            Object3D object3D = a3dre.getObject3D();
            object3D.transform(transMatrix);
            object3D.transform(this.M2V_MATRIX);
            object3D.prepareZSort();
            if (bClip) {
                object3D.clip(this);
            }
            if (object3D.getVectors().length < 1) {
                return false;
            }
            object3D.perspective(this.PERSPECTIVE_VALUE);
            object3D.transform(this.V2C_MATRIX);
            a3dre.prepare2D(xOffset, yOffset);
        } else if (obj instanceof Area3DRenderEvent) {
            Area3DRenderEvent a3dre = (Area3DRenderEvent)obj;
            Iterator<PrimitiveRenderEvent> itr = a3dre.iterator();
            while (itr.hasNext()) {
                PrimitiveRenderEvent pre = itr.next();
                if (!(pre instanceof I3DRenderEvent)) continue;
                Object3D object3D = ((I3DRenderEvent)((Object)pre)).getObject3D();
                object3D.transform(transMatrix);
                object3D.transform(this.M2V_MATRIX);
                object3D.prepareZSort();
                if (bClip) {
                    object3D.clip(this);
                }
                if (object3D.getVectors().length < 1) {
                    itr.remove();
                    continue;
                }
                object3D.perspective(this.PERSPECTIVE_VALUE);
                object3D.transform(this.V2C_MATRIX);
            }
            a3dre.prepare2D(xOffset, yOffset);
        }
        return true;
    }

    public PrimitiveRenderEvent processEvent(PrimitiveRenderEvent event, double xOffset, double yOffset) {
        Matrix transMatrix = this.getTransformMatrix();
        if (this.translate3DEvent(event, transMatrix, xOffset, yOffset)) {
            return event;
        }
        return null;
    }

    public PrimitiveRenderEvent processEvent_noclip(PrimitiveRenderEvent event, double xOffset, double yOffset) {
        Matrix transMatrix = this.getTransformMatrix();
        if (this.translate3DEvent_clip_opt(event, transMatrix, xOffset, yOffset, false)) {
            return event;
        }
        return null;
    }

    public List processEvent(List renderingEvents, double xOffset, double yOffset) {
        Matrix transMatrix = this.getTransformMatrix();
        ArrayList<Object> rtList = new ArrayList<Object>();
        ArrayList<WrappedInstruction> labels = new ArrayList<WrappedInstruction>();
        for (Object obj : renderingEvents) {
            WrappedInstruction wi = null;
            if (obj instanceof WrappedInstruction) {
                wi = (WrappedInstruction)obj;
                assert (!wi.isModel());
                obj = wi.getEvent();
                if (wi.getSubDeferredCache() != null) {
                    wi.getSubDeferredCache().process3DEvent(this, xOffset, yOffset);
                }
            }
            if (!this.translate3DEvent(obj, transMatrix, xOffset, yOffset)) continue;
            if (wi != null) {
                if (obj instanceof Text3DRenderEvent) {
                    labels.add(wi);
                    continue;
                }
                rtList.add(wi);
                continue;
            }
            if (obj instanceof Text3DRenderEvent) {
                labels.add((WrappedInstruction)obj);
                continue;
            }
            rtList.add(obj);
        }
        this.zsort(rtList);
        this.overlapSwap(rtList);
        this.detectSharedEdges(rtList, xOffset, yOffset);
        rtList.addAll(labels);
        return rtList;
    }

    private void detectSharedEdges(List rtList, double xOffset, double yOffset) {
        TreeMap sharedEdges = new TreeMap();
        int i = 0;
        while (i < rtList.size()) {
            Object obj = rtList.get(i);
            while (obj instanceof WrappedInstruction) {
                obj = ((WrappedInstruction)obj).getEvent();
            }
            if (obj instanceof Polygon3DRenderEvent) {
                int j = 0;
                while (j < i) {
                    I3DRenderEvent event;
                    WrappedInstruction edge;
                    Object comparedEvent = rtList.get(j);
                    while (comparedEvent instanceof WrappedInstruction) {
                        comparedEvent = ((WrappedInstruction)comparedEvent).getEvent();
                    }
                    if (comparedEvent instanceof Polygon3DRenderEvent && (edge = this.getSharedEdge(event = (I3DRenderEvent)comparedEvent, (I3DRenderEvent)obj, xOffset, yOffset)) != null) {
                        Integer index = j;
                        if (sharedEdges.containsKey(index)) {
                            ((List)sharedEdges.get(index)).add(edge);
                        } else {
                            ArrayList<WrappedInstruction> list = new ArrayList<WrappedInstruction>();
                            list.add(edge);
                            sharedEdges.put(index, list);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        int offset = 0;
        for (Map.Entry entry : sharedEdges.entrySet()) {
            Integer position = (Integer)entry.getKey();
            List lines = (List)entry.getValue();
            Iterator iterList = lines.iterator();
            while (iterList.hasNext()) {
                rtList.add(position + offset, iterList.next());
                ++offset;
            }
        }
    }

    public WrappedInstruction getSharedEdge(I3DRenderEvent event1, I3DRenderEvent event2, double xOffset, double yOffset) {
        PrimitiveRenderEvent primEvent = (PrimitiveRenderEvent)((Object)event2);
        Fill background = primEvent.getBackground();
        if (!(background instanceof ColorDefinition)) {
            return null;
        }
        ColorDefinition backgroundColor = (ColorDefinition)background;
        Polygon3DRenderEvent sharedPolygonEdge = null;
        WrappedInstruction wi = null;
        Object3D sharedEdgeObject = event1.getObject3D().getSharedEdge(event2.getObject3D());
        if (sharedEdgeObject != null) {
            sharedPolygonEdge = new Polygon3DRenderEvent(primEvent.getSource());
            ColorDefinition sharedBackgroundColor = (ColorDefinition)FillUtil.copyOf(backgroundColor);
            sharedPolygonEdge.setBackground(sharedBackgroundColor);
            if (backgroundColor.getTransparency() < 255) {
                int t = backgroundColor.getTransparency();
                sharedBackgroundColor.setTransparency(t * t * t / 65025);
            }
            Location[] locations = sharedEdgeObject.getPoints2D(xOffset, yOffset);
            sharedPolygonEdge.setPoints(locations);
            wi = new WrappedInstruction(null, sharedPolygonEdge, 2);
        }
        return wi;
    }

    protected void overlapSwap(List<Object> rtList) {
        if (rtList.size() == 0) {
            return;
        }
        HashSet<Object> hs = new HashSet<Object>();
        int i = 0;
        while (i < rtList.size()) {
            long max_loop = rtList.size() - i;
            int n = -1;
            boolean restart = true;
            block1: while (restart && (long)n < max_loop) {
                restart = false;
                ++n;
                Object event = rtList.get(i);
                Object3D far = Engine3D.getObjectFromEvent(event, true);
                int j = i + 1;
                while (j < rtList.size()) {
                    Object event2 = rtList.get(j);
                    Object3D near = Engine3D.getObjectFromEvent(event2, true);
                    Object3D nearParent = Engine3D.getParentObject(event2);
                    if (far == near) {
                        if (nearParent == null) {
                            rtList.set(i, event2);
                            rtList.set(j, event);
                            restart = true;
                            continue block1;
                        }
                    } else if (far.testZOverlap(near)) {
                        boolean bSwap = far.testSwap(near, this);
                        if (bSwap) {
                            boolean bSwapedFromFront = hs.contains(event);
                            boolean bl = bSwap = !bSwapedFromFront;
                            if (bSwap) {
                                hs.add(event);
                            }
                        }
                        if (bSwap) {
                            rtList.set(i, event2);
                            rtList.set(j, event);
                            restart = true;
                            continue block1;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public Vector getViewReferencePoint() {
        return this.PRP[0];
    }

    public static Object3D getObjectFromEvent(Object event) {
        return Engine3D.getObjectFromEvent(event, false);
    }

    public static Object3D getParentObject(Object event) {
        if (event instanceof Line3DRenderEvent) {
            return ((Line3DRenderEvent)event).getObject3DParent();
        }
        return null;
    }

    public static Object3D getObjectFromEvent(Object event, boolean bParent) {
        if (event instanceof WrappedInstruction) {
            event = ((WrappedInstruction)event).getEvent();
        }
        if (event instanceof I3DRenderEvent) {
            if (event instanceof Area3DRenderEvent) {
                return ((I3DRenderEvent)((Object)((Area3DRenderEvent)event).getElement(0))).getObject3D();
            }
            if (bParent && event instanceof Line3DRenderEvent && ((Line3DRenderEvent)event).getObject3DParent() != null) {
                return ((Line3DRenderEvent)event).getObject3DParent();
            }
            return ((I3DRenderEvent)event).getObject3D();
        }
        throw new IllegalArgumentException();
    }

    private int zSortComparator(Object o1, Object o2) {
        Object3D obj1 = Engine3D.getObjectFromEvent(o1);
        Object3D obj2 = Engine3D.getObjectFromEvent(o2);
        if (obj1.getZMax() > obj2.getZMax()) {
            return -1;
        }
        if (obj1.getZMax() < obj2.getZMax()) {
            return 1;
        }
        return 0;
    }

    protected void zsort(List<Object> rtList) {
        Collections.sort(rtList, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return Engine3D.this.zSortComparator(o1, o2);
            }
        });
    }
}

