/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.elements.Style;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyleUtil {
    public static String handleFontFamily(PropertyDefn defn, String fontFamily) {
        String value = StringUtil.trimString(fontFamily);
        if (StringUtil.isBlank(value)) {
            return value;
        }
        String splitter = ",";
        String[] families = value.split(splitter);
        ArrayList<String> values = new ArrayList<String>();
        int i = 0;
        while (i < families.length) {
            String family = families[i];
            family = StringUtil.trimString(family);
            family = StringUtil.trimQuotes(family);
            IChoiceSet choiceSet = defn.getAllowedChoices();
            assert (choiceSet != null);
            if (choiceSet.findChoice(family) != null) {
                values.add(family);
            } else {
                values.add("\"" + family + "\"");
            }
            ++i;
        }
        StringBuilder result = new StringBuilder();
        int i2 = 0;
        while (i2 < values.size()) {
            if (i2 != 0) {
                result.append(splitter).append(" ");
            }
            result.append((String)values.get(i2));
            ++i2;
        }
        return result.toString();
    }

    public static SharedStyleHandle transferCssStyleToSharedStyle(Module module, SharedStyleHandle cssStyleHandle) {
        if (cssStyleHandle == null) {
            return null;
        }
        Style newStyle = new Style(cssStyleHandle.getName());
        SharedStyleHandle styleHandle = newStyle.handle(module);
        ModelUtil.duplicateProperties(cssStyleHandle, styleHandle, false, false);
        return styleHandle;
    }

    public static int getStylePosition(List<? extends StyleElement> styleList, String name) {
        int i = 0;
        while (i < styleList.size()) {
            StyleElement style = styleList.get(i);
            String styleName = style.getName().toLowerCase();
            if (styleName.equalsIgnoreCase(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

