/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.data.IColumnBinding;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ListingHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.AggregationArgument;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.DataItem;
import org.eclipse.birt.report.model.elements.ListingElement;
import org.eclipse.birt.report.model.elements.ReportItem;
import org.eclipse.birt.report.model.elements.ScalarParameter;
import org.eclipse.birt.report.model.i18n.ModelMessages;
import org.eclipse.birt.report.model.util.BoundColumnsMgr;

public class UnusedBoundColumnsMgr
extends BoundColumnsMgr {
    private Set<String> boundColumnNames = new HashSet<String>();
    private DesignElement element;
    private Module module;

    public UnusedBoundColumnsMgr(DesignElementHandle element) {
        this.element = element.getElement();
        this.module = element.getModule();
    }

    protected void handleBoundsForParamBinding(DesignElement element, Module module, String propValue) {
        if (propValue == null) {
            return;
        }
        List newExprs = null;
        try {
            newExprs = ExpressionUtil.extractColumnExpressions((String)propValue);
        }
        catch (BirtException birtException) {
            newExprs = null;
        }
        if (newExprs != null && newExprs.size() > 0) {
            int i = 0;
            while (i < newExprs.size()) {
                IColumnBinding column = (IColumnBinding)newExprs.get(i);
                this.boundColumnNames.add(column.getResultSetColumnName());
                ++i;
            }
        }
    }

    protected void handleBoundsForValue(DesignElement element, Module module, String propValue) {
        if (propValue == null) {
            return;
        }
        List newExprs = null;
        try {
            newExprs = ExpressionUtil.extractColumnExpressions((String)propValue);
        }
        catch (BirtException birtException) {
            newExprs = null;
        }
        if (newExprs != null) {
            int i = 0;
            while (i < newExprs.size()) {
                IColumnBinding column = (IColumnBinding)newExprs.get(i);
                this.boundColumnNames.add(column.getResultSetColumnName());
                ++i;
            }
        }
    }

    public static void removedUnusedBoundColumns(DesignElementHandle elementHandle) throws SemanticException {
        if (elementHandle == null || !(elementHandle instanceof ReportItemHandle) && !(elementHandle instanceof ScalarParameterHandle)) {
            return;
        }
        UnusedBoundColumnsMgr mgr = new UnusedBoundColumnsMgr(elementHandle);
        Module module = elementHandle.getModule();
        if (elementHandle instanceof ListingHandle) {
            mgr.dealDataContainerReportItem((ListingElement)mgr.element, module);
        } else if (elementHandle instanceof ReportItemHandle) {
            mgr.dealNonDataContainerReportItem((ReportItem)mgr.element, module);
        } else if (elementHandle instanceof ScalarParameterHandle) {
            mgr.dealScalarParameter((ScalarParameter)mgr.element, module);
        }
        mgr.removeUnusedColumns();
    }

    void removeUnusedColumns() throws SemanticException {
        String propName = null;
        if (this.element instanceof ReportItem) {
            propName = "boundDataColumns";
        } else if (this.element instanceof ScalarParameter) {
            propName = "boundDataColumns";
        } else {
            return;
        }
        List currentList = (List)this.element.getLocalProperty(this.module, propName);
        if (currentList == null || currentList.isEmpty()) {
            return;
        }
        ArrayList<ComputedColumn> unusedList = new ArrayList<ComputedColumn>();
        int i = 0;
        while (i < currentList.size()) {
            ComputedColumn column = (ComputedColumn)currentList.get(i);
            if (!this.boundColumnNames.contains(column.getName())) {
                unusedList.add(column);
            }
            ++i;
        }
        PropertyHandle propHandle = this.element.getHandle(this.module).getPropertyHandle(propName);
        ActivityStack cmdStack = this.module.getActivityStack();
        cmdStack.startTrans(ModelMessages.getMessage("Message.RemoveItem"));
        try {
            int i2 = 0;
            while (i2 < unusedList.size()) {
                propHandle.removeItem(unusedList.get(i2));
                ++i2;
            }
        }
        catch (SemanticException e) {
            cmdStack.rollback();
            throw e;
        }
        cmdStack.commit();
    }

    public void dealData(DataItem element, Module module) {
        super.dealData(element, module);
        String value = (String)element.getLocalProperty(module, "resultSetColumn");
        if (value == null) {
            return;
        }
        this.boundColumnNames.add(value);
    }

    protected void dealReportItem(ReportItem element, Module module) {
        super.dealReportItem(element, module);
        List columnBindings = (List)element.getLocalProperty(module, "boundDataColumns");
        if (columnBindings != null) {
            int i = 0;
            while (i < columnBindings.size()) {
                ComputedColumn paramValue = (ComputedColumn)columnBindings.get(i);
                this.handleBoundsForValue(element, module, paramValue.getExpression());
                List args = (List)paramValue.getLocalProperty(module, "arguments");
                if (args != null) {
                    int j = 0;
                    while (j < args.size()) {
                        AggregationArgument arg = (AggregationArgument)args.get(j);
                        this.handleBoundsForValue(element, module, arg.getValue());
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    protected void dealScalarParameter(ScalarParameter element, Module module) {
        super.dealScalarParameter(element, module);
        List columnBindings = (List)element.getLocalProperty(module, "boundDataColumns");
        if (columnBindings != null) {
            int i = 0;
            while (i < columnBindings.size()) {
                ComputedColumn paramValue = (ComputedColumn)columnBindings.get(i);
                this.handleBoundsForValue(element, module, paramValue.getExpression());
                List args = (List)paramValue.getLocalProperty(module, "arguments");
                if (args != null) {
                    int j = 0;
                    while (j < args.size()) {
                        AggregationArgument arg = (AggregationArgument)args.get(j);
                        this.handleBoundsForValue(element, module, arg.getValue());
                        ++j;
                    }
                }
                ++i;
            }
        }
    }
}

