/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.utility;

import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.report.context.BaseAttributeBean;
import org.eclipse.birt.report.context.BaseTaskBean;
import org.eclipse.birt.report.context.ViewerAttributeBean;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IEngineTask;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.ITOCTree;
import org.eclipse.birt.report.engine.api.TOCNode;
import org.eclipse.birt.report.engine.api.script.instance.IScriptStyle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ParameterHandle;
import org.eclipse.birt.report.resource.BirtResources;
import org.eclipse.birt.report.service.ParameterDataTypeConverter;
import org.eclipse.birt.report.service.ReportEngineService;
import org.eclipse.birt.report.service.api.IViewerReportDesignHandle;
import org.eclipse.birt.report.service.api.InputOptions;
import org.eclipse.birt.report.service.api.ParameterDefinition;
import org.eclipse.birt.report.service.api.ReportServiceException;
import org.eclipse.birt.report.soapengine.api.Operation;
import org.eclipse.birt.report.soapengine.api.Oprand;
import org.eclipse.birt.report.utility.DataUtil;
import org.eclipse.birt.report.utility.ParameterAccessor;
import org.eclipse.birt.report.utility.PrintUtility;
import org.eclipse.birt.report.utility.Printer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BirtUtility {
    public static final String NONE = "none";
    public static final String VIEWER_MARKER_CLEARED = "ViewerMarkerCleared";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTask(HttpServletRequest request, IEngineTask task) {
        if (request == null || task == null) {
            return;
        }
        try {
            BaseAttributeBean attrBean = (BaseAttributeBean)request.getAttribute("attributeBean");
            if (attrBean == null) {
                return;
            }
            String taskid = attrBean.getTaskId();
            if (taskid == null) {
                return;
            }
            HttpSession session = request.getSession(true);
            HashMap<String, BaseTaskBean> map = (HashMap<String, BaseTaskBean>)session.getAttribute("tasks");
            if (map == null) {
                map = new HashMap<String, BaseTaskBean>();
                session.setAttribute("tasks", map);
            }
            HashMap<String, BaseTaskBean> hashMap = map;
            synchronized (hashMap) {
                BaseTaskBean bean = new BaseTaskBean(taskid, task);
                map.put(taskid, bean);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeTask(HttpServletRequest request) {
        if (request == null) {
            return;
        }
        try {
            BaseAttributeBean attrBean = (BaseAttributeBean)request.getAttribute("attributeBean");
            if (attrBean == null) {
                return;
            }
            String taskid = attrBean.getTaskId();
            if (taskid == null) {
                return;
            }
            HttpSession session = request.getSession(true);
            Map map = (Map)session.getAttribute("tasks");
            if (map == null) {
                return;
            }
            Map map2 = map;
            synchronized (map2) {
                map.remove(taskid);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cancelTask(HttpServletRequest request, String taskid) throws Exception {
        if (taskid == null) {
            return;
        }
        HttpSession session = request.getSession();
        if (session == null) {
            return;
        }
        Map map = (Map)session.getAttribute("tasks");
        if (map != null && map.containsKey(taskid)) {
            BaseTaskBean bean = (BaseTaskBean)map.get(taskid);
            if (bean == null) {
                return;
            }
            IEngineTask task = bean.getTask();
            if (task != null) {
                task.cancel();
            }
            Map map2 = map;
            synchronized (map2) {
                map.remove(taskid);
            }
        }
    }

    public static List getParameterList(IViewerReportDesignHandle reportDesignHandle) throws ReportServiceException {
        IReportRunnable runnable = (IReportRunnable)reportDesignHandle.getDesignObject();
        if (runnable == null) {
            return null;
        }
        ModuleHandle model = runnable.getDesignHandle().getModuleHandle();
        if (model == null) {
            return null;
        }
        return model.getFlattenParameters();
    }

    public static ParameterDefinition findParameterDefinition(Collection parameterList, String paramName) {
        if (parameterList == null || paramName == null) {
            return null;
        }
        for (ParameterDefinition parameter : parameterList) {
            String name;
            if (parameter == null || !paramName.equals(name = parameter.getName())) continue;
            return parameter;
        }
        return null;
    }

    public static ParameterHandle findParameter(IViewerReportDesignHandle reportDesignHandle, String paramName) throws ReportServiceException {
        if (paramName == null) {
            return null;
        }
        IReportRunnable runnable = (IReportRunnable)reportDesignHandle.getDesignObject();
        if (runnable == null) {
            return null;
        }
        ModuleHandle model = runnable.getDesignHandle().getModuleHandle();
        if (model == null) {
            return null;
        }
        return model.findParameter(paramName);
    }

    public static Map getModuleOptions(HttpServletRequest request) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("resourceFolder", ParameterAccessor.getResourceFolder(request));
        options.put("semanticCheck", Boolean.FALSE);
        return options;
    }

    public static Map getDisplayTexts(Collection parameters, Map displayTexts, HttpServletRequest request) {
        if (displayTexts == null) {
            displayTexts = new HashMap<String, String>();
        }
        Enumeration params = request.getParameterNames();
        while (params != null && params.hasMoreElements()) {
            ParameterDefinition parameter;
            String param = DataUtil.getString(params.nextElement());
            String paramName = ParameterAccessor.isDisplayText(param);
            if (paramName == null || (parameter = BirtUtility.findParameterDefinition(parameters, paramName)) == null) continue;
            if (parameter.isMultiValue()) {
                displayTexts.put(paramName, null);
                continue;
            }
            displayTexts.put(paramName, ParameterAccessor.getParameter(request, param));
        }
        return displayTexts;
    }

    public static List getLocParams(List locParams, HttpServletRequest request) {
        String[] arrs;
        if (locParams == null) {
            locParams = new ArrayList<String>();
        }
        if ((arrs = request.getParameterValues("__islocale")) != null) {
            for (int i = 0; i < arrs.length; ++i) {
                locParams.add(arrs[i]);
            }
        }
        return locParams;
    }

    public static boolean validateParameters(Collection parameterList, Map parameters) {
        assert (parameters != null);
        boolean missingParameter = false;
        for (ParameterDefinition parameter : parameterList) {
            String parameterName = parameter.getName();
            Object parameterValue = parameters.get(parameterName);
            if (parameter.isHidden() || !parameter.isRequired()) continue;
            if (parameterValue == null) {
                missingParameter = true;
                break;
            }
            if (parameterValue instanceof List) {
                List values = (List)parameterValue;
                for (int i = 0; i < values.size(); ++i) {
                    Object value = values.get(i);
                    if (value == null) {
                        missingParameter = true;
                        break;
                    }
                    if (!(value instanceof String) || ((String)value).length() > 0) continue;
                    missingParameter = true;
                    break;
                }
                if (!missingParameter) continue;
                break;
            }
            if (!(parameterValue instanceof String) || ((String)parameterValue).length() > 0) continue;
            missingParameter = true;
            break;
        }
        return missingParameter;
    }

    public static void handleOperation(Operation operation, ViewerAttributeBean bean, Map parameterMap, Map displayTexts) throws Exception {
        if (operation == null || bean == null || parameterMap == null || displayTexts == null) {
            return;
        }
        ArrayList<String> locs = new ArrayList<String>();
        HashMap<String, ArrayList<String>> params = new HashMap<String, ArrayList<String>>();
        String displayTextParam = null;
        Oprand[] oprands = operation.getOprand();
        for (int i = 0; i < oprands.length; ++i) {
            ArrayList<String> list;
            String paramName = oprands[i].getName();
            String paramValue = oprands[i].getValue();
            if (paramName == null || paramValue == null) continue;
            if (paramName.equalsIgnoreCase("__islocale")) {
                locs.add(paramValue);
                continue;
            }
            displayTextParam = ParameterAccessor.isDisplayText(paramName);
            if (displayTextParam != null) {
                ParameterDefinition parameter = bean.findParameterDefinition(displayTextParam);
                if (parameter == null) continue;
                if (parameter.isMultiValue()) {
                    displayTexts.put(displayTextParam, null);
                    continue;
                }
                displayTexts.put(displayTextParam, paramValue);
                continue;
            }
            if ("__isnulllist".equalsIgnoreCase(paramName)) {
                paramName = paramValue;
                params.remove(paramName);
                continue;
            }
            if ("__isnull".equalsIgnoreCase(paramName)) {
                paramName = paramValue;
                paramValue = null;
            }
            if ((list = (ArrayList<String>)params.get(paramName)) == null) {
                list = new ArrayList<String>();
                params.put(paramName, list);
            }
            list.add(paramValue);
        }
        for (Map.Entry entry : params.entrySet()) {
            String paramName = (String)entry.getKey();
            List paramValues = (List)entry.getValue();
            ParameterDefinition parameter = bean.findParameterDefinition(paramName);
            if (parameter == null) continue;
            String pattern = parameter.getPattern();
            String dataType = ParameterDataTypeConverter.convertDataType(parameter.getDataType());
            boolean isLocale = locs.contains(paramName);
            if (parameter.isMultiValue()) {
                if (paramValues == null) {
                    parameterMap.put(paramName, null);
                    continue;
                }
                ArrayList<Object> values = new ArrayList<Object>();
                for (int i = 0; i < paramValues.size(); ++i) {
                    Object paramValueObj = DataUtil.validate(paramName, dataType, pattern, (String)paramValues.get(i), bean.getLocale(), bean.getTimeZone(), isLocale);
                    values.add(paramValueObj);
                }
                parameterMap.put(paramName, values.toArray());
                continue;
            }
            Object paramValueObj = DataUtil.validate(paramName, dataType, pattern, paramValues == null ? null : (String)paramValues.get(0), bean.getLocale(), bean.getTimeZone(), isLocale);
            parameterMap.put(paramName, paramValueObj);
        }
    }

    public static IReportRunnable getRunnableFromDesignFile(HttpServletRequest request, String designFile, Map options) throws EngineException {
        IReportRunnable reportRunnable = null;
        File file = new File(designFile);
        if (file.exists()) {
            reportRunnable = ReportEngineService.getInstance().openReportDesign(designFile, options);
        } else {
            InputStream is = null;
            URL url = null;
            try {
                String resoureFile;
                if (!ParameterAccessor.isUniversalPath(designFile)) {
                    designFile = ParameterAccessor.workingFolder + "/" + ParameterAccessor.getParameter(request, "__report");
                }
                if (!(resoureFile = designFile).startsWith("/")) {
                    resoureFile = "/" + resoureFile;
                }
                if ((url = request.getSession().getServletContext().getResource(resoureFile)) != null) {
                    is = url.openStream();
                } else {
                    url = new URL(designFile);
                    is = url.openStream();
                }
                if (is != null) {
                    reportRunnable = ReportEngineService.getInstance().openReportDesign(url.toString(), is, options);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return reportRunnable;
    }

    public static String getTitleFromDesign(IViewerReportDesignHandle reportDesignHandle) throws ReportServiceException {
        Object design;
        String reportTitle = null;
        if (reportDesignHandle != null && (design = reportDesignHandle.getDesignObject()) instanceof IReportRunnable) {
            IReportRunnable runnable = (IReportRunnable)design;
            reportTitle = (String)runnable.getProperty("title");
        }
        return reportTitle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStackTrace(Throwable e) {
        StringWriter stackTraceWriter = null;
        PrintWriter writer = null;
        try {
            stackTraceWriter = new StringWriter();
            writer = new PrintWriter(stackTraceWriter);
            e.printStackTrace(writer);
            String string = stackTraceWriter.toString();
            return string;
        }
        finally {
            if (stackTraceWriter != null) {
                try {
                    stackTraceWriter.close();
                }
                catch (IOException e1) {}
            }
            if (writer != null) {
                writer.close();
            }
        }
    }

    public static String toHtml(String text) {
        return text.replaceAll("\n", "<BR/>");
    }

    public static AxisFault makeAxisFault(String qName, Exception e) {
        AxisFault fault = BirtUtility.makeAxisFault(e);
        fault.setFaultCode(new QName(qName));
        return fault;
    }

    public static AxisFault makeAxisFault(Exception e) {
        if (e instanceof AxisFault) {
            return (AxisFault)((Object)e);
        }
        AxisFault fault = AxisFault.makeFault((Exception)e);
        fault.addFaultDetailString(BirtUtility.getStackTrace(e));
        return fault;
    }

    public static Exception makeAxisFault(String qName, Collection<Exception> exceptions) {
        if (exceptions.size() == 1) {
            return BirtUtility.makeAxisFault(qName, exceptions.iterator().next());
        }
        QName exceptionQName = new QName("string");
        AxisFault fault = new AxisFault(BirtResources.getMessage("birt.viewer.generalException.MULTIPLE_EXCEPTIONS"));
        fault.setFaultCode(new QName(qName));
        for (Exception e : exceptions) {
            fault.addFaultDetail(exceptionQName, BirtUtility.getStackTrace(e));
        }
        return fault;
    }

    public static void appendErrorMessage(OutputStream out, Exception e) throws IOException {
        String message = "<html>\n<head>\n<title>" + BirtResources.getMessage("birt.viewer.title.error") + "</title>\n";
        message = message + "<META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset=utf-8\">\n</head>\n";
        message = message + "<body>\n";
        String errorId = "document.getElementById('error_detail')";
        String errorIcon = "document.getElementById('error_icon')";
        String onClick = "if (" + errorId + ".style.display == 'none') { " + errorIcon + ".innerHTML = '- '; " + errorId + ".style.display = 'block'; }" + "else { " + errorIcon + ".innerHTML = '+ '; " + errorId + ".style.display = 'none'; }";
        message = message + "<div id=\"birt_errorPage\" style=\"color:red\">\n";
        message = message + "<span id=\"error_icon\"  style=\"cursor:pointer\" onclick=\"" + onClick + "\" > + </span>\n";
        String errorMessage = null;
        errorMessage = e instanceof AxisFault ? ((AxisFault)((Object)e)).getFaultString() : e.getLocalizedMessage();
        message = errorMessage != null ? message + ParameterAccessor.htmlEncode(errorMessage) : message + "Unknown error!";
        message = message + "<br>\n";
        message = message + "<pre id=\"error_detail\" style=\"display:none;\" >\n";
        message = message + ParameterAccessor.htmlEncode(BirtUtility.getDetailMessage(e));
        message = message + "</pre>\n";
        message = message + "</div>\n";
        message = message + "</body>\n</html>";
        out.write(message.getBytes("UTF-8"));
        out.flush();
        out.close();
    }

    public static String getDetailMessage(Throwable tx) {
        StringWriter out = new StringWriter();
        PrintWriter print = new PrintWriter(out);
        try {
            tx.printStackTrace(print);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        print.flush();
        print.close();
        return out.getBuffer().toString();
    }

    public static void writeMessage(OutputStream out, String content, String msgType, boolean isCloseWin) throws IOException {
        String fontColor = "black";
        if ("error".equalsIgnoreCase(msgType)) {
            fontColor = "red";
        }
        String message = "<html><head><title>" + BirtResources.getMessage("birt.viewer.title." + msgType) + "</title>";
        message = message + "<META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset=utf-8\"></head>";
        message = message + "<body";
        if (isCloseWin) {
            message = message + " onload=\"javascript:window.close()\"";
        }
        message = message + " style=\"background-color: #ECE9D8;\"><div style=\"font-size:10pt;\"><font color=\"" + fontColor + "\">" + content + "</font></div></body></html>";
        out.write(message.getBytes("UTF-8"));
        out.flush();
        out.close();
    }

    public static void doPrintAction(InputStream inputStream, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, RemoteException {
        Printer printer = PrintUtility.getPrinter(request);
        response.setContentType("text/html; charset=utf-8");
        if (printer != null) {
            PrintUtility.execPrint(inputStream, printer);
            BirtUtility.writeMessage((OutputStream)response.getOutputStream(), BirtResources.getMessage("birt.viewer.dialog.printserver.complete"), "complete", true);
        } else {
            BirtUtility.writeMessage((OutputStream)response.getOutputStream(), BirtResources.getMessage("birt.viewer.dialog.printserver.error.noprinter"), "error", false);
        }
    }

    public static String getTOCStyle(TOCNode node) {
        String textUnderline;
        String textLinethrough;
        if (node == null) {
            return null;
        }
        IScriptStyle scriptStyle = node.getTOCStyle();
        if (scriptStyle == null) {
            return null;
        }
        String style = BirtUtility.getStyle(scriptStyle, "getBackgroundAttachment", "background-attachment");
        style = style + BirtUtility.getStyle(scriptStyle, "getBackgroundColor", "background-color");
        style = style + BirtUtility.getStyle(scriptStyle, "getBackgroundImage", "background-image");
        style = style + BirtUtility.getStyle(scriptStyle, "getBackgroundPositionX", "background-position-x");
        style = style + BirtUtility.getStyle(scriptStyle, "getBackgroundPositionY", "background-position-y");
        style = style + BirtUtility.getStyle(scriptStyle, "getBackgroundRepeat", "background-repeat");
        style = style + BirtUtility.getStyle(scriptStyle, "getBorderBottomColor", "border-bottom-color");
        style = style + BirtUtility.getStyle(scriptStyle, "getBorderBottomStyle", "border-bottom-style");
        style = style + BirtUtility.getStyle(scriptStyle, "getBorderBottomWidth", "border-bottom-width");
        style = style + BirtUtility.getStyle(scriptStyle, "getBorderLeftColor", "border-left-color");
        style = style + BirtUtility.getStyle(scriptStyle, "getBorderLeftStyle", "border-left-style");
        style = style + BirtUtility.getStyle(scriptStyle, "getBorderLeftWidth", "border-left-width");
        style = style + BirtUtility.getStyle(scriptStyle, "getBorderRightColor", "border-right-color");
        style = style + BirtUtility.getStyle(scriptStyle, "getBorderRightStyle", "border-right-style");
        style = style + BirtUtility.getStyle(scriptStyle, "getBorderRightWidth", "border-right-width");
        style = style + BirtUtility.getStyle(scriptStyle, "getBorderTopColor", "border-top-color");
        style = style + BirtUtility.getStyle(scriptStyle, "getBorderTopStyle", "border-top-style");
        style = style + BirtUtility.getStyle(scriptStyle, "getBorderTopWidth", "border-top-width");
        style = style + BirtUtility.getStyle(scriptStyle, "getColor", "color");
        style = style + BirtUtility.getStyle(scriptStyle, "getFontFamily", "font-family");
        style = style + BirtUtility.getStyle(scriptStyle, "getFontSize", "font-size");
        style = style + BirtUtility.getStyle(scriptStyle, "getFontStyle", "font-style");
        style = style + BirtUtility.getStyle(scriptStyle, "getFontVariant", "font-variant");
        style = style + BirtUtility.getStyle(scriptStyle, "getFontWeight", "font-weight");
        style = style + BirtUtility.getStyle(scriptStyle, "getLetterSpacing", "letter-spacing");
        style = style + BirtUtility.getStyle(scriptStyle, "getLineHeight", "line-height");
        style = style + BirtUtility.getStyle(scriptStyle, "getPaddingBottom", "padding-bottom");
        style = style + BirtUtility.getStyle(scriptStyle, "getPaddingLeft", "padding-left");
        style = style + BirtUtility.getStyle(scriptStyle, "getPaddingRight", "padding-right");
        style = style + BirtUtility.getStyle(scriptStyle, "getPaddingTop", "padding-top");
        style = style + BirtUtility.getStyle(scriptStyle, "getTextAlign", "text-align");
        style = style + BirtUtility.getStyle(scriptStyle, "getTextTransform", "text-transform");
        String textDecoration = "";
        String textOverline = scriptStyle.getTextOverline();
        if (textOverline != null && !NONE.equalsIgnoreCase(textOverline)) {
            textDecoration = textDecoration + textOverline + " ";
        }
        if ((textLinethrough = scriptStyle.getTextLineThrough()) != null && !NONE.equalsIgnoreCase(textLinethrough)) {
            textDecoration = textDecoration + textLinethrough + " ";
        }
        if ((textUnderline = scriptStyle.getTextUnderline()) != null && !NONE.equalsIgnoreCase(textUnderline)) {
            textDecoration = textDecoration + textUnderline + " ";
        }
        if (textDecoration.length() > 0) {
            style = style + "text-decoration:" + textDecoration + ";";
        }
        style = style + BirtUtility.getStyle(scriptStyle, "getWordSpacing", "word-spacing");
        return style;
    }

    private static String getStyle(Object obj, String methodName, String cssAttr) {
        assert (obj != null);
        assert (methodName != null);
        assert (cssAttr != null);
        String style = BirtUtility.invokeGetStyle(obj, methodName);
        if (style == null || NONE.equalsIgnoreCase(style)) {
            return "";
        }
        return cssAttr + ":" + style + ";";
    }

    private static String invokeGetStyle(Object obj, String methodName) {
        String style = null;
        try {
            Method method = IScriptStyle.class.getMethod(methodName, new Class[0]);
            if (method == null) {
                return null;
            }
            Object value = method.invoke(obj, new Object[0]);
            if (value != null) {
                style = (String)value;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return style;
    }

    public static Map getAppContext(HttpServletRequest request) {
        int cubeMemorySize;
        int maxCubeColumnLevels;
        HashMap<String, Object> context = new HashMap<String, Object>();
        Boolean isDesigner = ParameterAccessor.isDesigner();
        context.put("org.eclipse.birt.data.engine.dataset.cache.option", isDesigner);
        context.put("BIRT_VIEWER_HTTPSERVET_REQUEST", request);
        context.put("CHART_RESOLUTION", ParameterAccessor.getDpi(request));
        int maxCubeRowLevels = ParameterAccessor.getMaxCubeRowLevels(request);
        if (maxCubeRowLevels >= 0) {
            context.put(DataEngine.CUBECUSROR_FETCH_LIMIT_ON_ROW_EDGE, maxCubeRowLevels);
        }
        if ((maxCubeColumnLevels = ParameterAccessor.getMaxCubeColumnLevels(request)) >= 0) {
            context.put(DataEngine.CUBECURSOR_FETCH_LIMIT_ON_COLUMN_EDGE, maxCubeColumnLevels);
        }
        if ((cubeMemorySize = ParameterAccessor.getCubeMemorySize(request)) >= 0) {
            context.put(DataEngine.IN_MEMORY_CUBE_SIZE, cubeMemorySize);
        }
        context.put("birt.viewer.resource.path", ParameterAccessor.getResourceFolder(request));
        ParameterAccessor.pushAppContext(context, request);
        if (isDesigner.booleanValue()) {
            String appContextName = ParameterAccessor.getAppContextName(request);
            BirtUtility.getAppContextFromExtension(appContextName, context);
        }
        return context;
    }

    public static String findTocByName(IReportDocument doc, String name, InputOptions options) {
        if (doc == null || name == null) {
            return null;
        }
        String tocid = null;
        Locale locale = null;
        TimeZone timeZone = null;
        if (options != null) {
            locale = (Locale)options.getOption("locale");
            timeZone = (TimeZone)options.getOption("timeZone");
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        ITOCTree tocTree = null;
        tocTree = timeZone != null ? doc.getTOCTree("viewer", ULocale.forLocale((Locale)locale), BirtUtility.toICUTimeZone(timeZone)) : doc.getTOCTree("viewer", ULocale.forLocale((Locale)locale));
        if (tocTree == null) {
            return null;
        }
        List tocList = tocTree.findTOCByValue((Object)name);
        if (tocList != null && tocList.size() > 0) {
            tocid = ((TOCNode)tocList.get(0)).getBookmark();
        }
        return tocid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void outputFile(String filePath, OutputStream out, boolean isDelete) throws IOException {
        if (filePath == null) {
            return;
        }
        File file = new File(filePath);
        if (!file.exists()) {
            return;
        }
        FileInputStream in = new FileInputStream(file);
        try {
            byte[] buf = new byte[512];
            int len = 0;
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            out.flush();
        }
        finally {
            in.close();
            try {
                if (isDelete) {
                    file.delete();
                }
            }
            catch (Exception e) {}
        }
    }

    private static String getSystemId(HttpServletRequest request) {
        String systemId = null;
        ViewerAttributeBean attrBean = (ViewerAttributeBean)request.getAttribute("attributeBean");
        if (attrBean != null) {
            systemId = attrBean.getReportDesignName();
        }
        return systemId;
    }

    private static void error(String systemId, String message, long elementId, int lineNumber) {
        try {
            Method mt;
            Class<?> clz = Class.forName("org.eclipse.birt.report.viewer.utilities.MarkerUtil");
            if (clz != null && (mt = clz.getMethod("error", String.class, String.class, Long.TYPE, Integer.TYPE)) != null) {
                mt.invoke(null, systemId, message, elementId, lineNumber);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public static void error(HttpServletRequest request, List errors) {
        String systemId = BirtUtility.getSystemId(request);
        if (systemId == null) {
            return;
        }
        String isCleared = (String)request.getAttribute(VIEWER_MARKER_CLEARED);
        if (isCleared == null) {
            BirtUtility.clearErrors(systemId);
            request.setAttribute(VIEWER_MARKER_CLEARED, (Object)"true");
        }
        if (errors == null || errors.size() <= 0) {
            return;
        }
        for (Exception e : errors) {
            if (e == null) continue;
            int lineno = -1;
            long elementId = 0L;
            if (e instanceof EngineException) {
                try {
                    Map options = BirtUtility.getModuleOptions(request);
                    options.put("markLineNumber", Boolean.TRUE);
                    IReportRunnable reportRunnable = BirtUtility.getRunnableFromDesignFile(request, systemId, options);
                    if (reportRunnable != null) {
                        ModuleHandle moduleHandle = reportRunnable.getDesignHandle().getModuleHandle();
                        elementId = ((EngineException)((Object)e)).getElementID();
                        DesignElementHandle obj = moduleHandle.getElementByID(elementId);
                        lineno = moduleHandle.getLineNo((Object)obj);
                    }
                }
                catch (Exception err) {
                    // empty catch block
                }
            }
            BirtUtility.error(systemId, BirtUtility.getDetailMessage(e), elementId, lineno);
        }
    }

    private static void clearErrors(String systemId) {
        try {
            Method mt;
            Class<?> clz = Class.forName("org.eclipse.birt.report.viewer.utilities.MarkerUtil");
            if (clz != null && (mt = clz.getMethod("clear", String.class)) != null) {
                mt.invoke(null, systemId);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static ClassLoader getAppClassLoader() {
        ClassLoader classLoader = null;
        try {
            Method mt;
            Class<?> clz = Class.forName("org.eclipse.birt.report.viewer.utilities.WebViewer");
            if (clz != null && (mt = clz.getMethod("getAppClassLoader", new Class[0])) != null) {
                classLoader = (ClassLoader)mt.invoke(null, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return classLoader;
    }

    public static Map getAppContext(Map context) {
        String appContextName = null;
        try {
            Method mt;
            Class<?> clz = Class.forName("org.eclipse.birt.report.viewer.utilities.WebViewer");
            if (clz != null && (mt = clz.getMethod("getAppContextName", null)) != null) {
                appContextName = (String)mt.invoke(null, (Object[])null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (appContextName != null) {
            return BirtUtility.getAppContextFromExtension(appContextName, context);
        }
        return context;
    }

    private static Map getAppContextFromExtension(String appContextName, Map context) {
        try {
            Method mt;
            Class<?> clz = Class.forName("org.eclipse.birt.report.viewer.utilities.AppContextUtil");
            if (clz != null && (mt = clz.getMethod("getAppContext", String.class, Map.class)) != null) {
                context = (Map)mt.invoke(null, appContextName, context);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return context;
    }

    public static com.ibm.icu.util.TimeZone toICUTimeZone(TimeZone timeZone) {
        if (timeZone != null) {
            return com.ibm.icu.util.TimeZone.getTimeZone((String)timeZone.getID());
        }
        return null;
    }
}

