/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.features.cache;

import aurora.application.features.cache.CacheProviderRegistry;
import aurora.application.features.cache.ICacheProvider;
import aurora.application.features.cache.IEventHandler;
import aurora.application.features.msg.IConsumer;
import aurora.application.features.msg.IMessage;
import aurora.application.features.msg.IMessageListener;
import aurora.application.features.msg.IMessageStub;
import aurora.application.features.msg.INoticerConsumer;
import aurora.database.FetchDescriptor;
import aurora.database.service.BusinessModelService;
import aurora.database.service.IDatabaseServiceFactory;
import aurora.database.service.SqlServiceContext;
import aurora.service.IServiceFactory;
import aurora.service.ServiceInvoker;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import uncertain.cache.ConcurrentCache;
import uncertain.cache.ICache;
import uncertain.cache.INamedCacheFactory;
import uncertain.cache.IReadWriteLockable;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.composite.transform.GroupTransformer;
import uncertain.core.ILifeCycle;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.exception.GeneralException;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.AbstractLocatableObject;
import uncertain.ocm.IObjectRegistry;
import uncertain.proc.IProcedureManager;
import uncertain.proc.Procedure;

public class CacheProvider
extends AbstractLocatableObject
implements ICacheProvider,
IMessageListener,
ILifeCycle {
    protected String cacheName;
    protected String loadProc;
    protected String refreshProc;
    protected String loadBM;
    protected String refreshBM;
    protected boolean loadOnStartup = true;
    protected IEventHandler[] eventHandlers;
    protected String value = "${@value}";
    protected String type = "value";
    protected String key = "${@key}";
    protected boolean isConcurrent = true;
    protected String groupByFields;
    protected String cacheDesc;
    protected String reloadTopic = "dml_event";
    protected String reloadMessage;
    protected Date lastReloadDate;
    protected boolean inited = false;
    protected ILogger logger;
    protected IProcedureManager procedureManager;
    protected IObjectRegistry mRegistry;
    protected IServiceFactory serviceFactory;
    protected IDatabaseServiceFactory dsFactory;
    protected ICache cache;
    protected INamedCacheFactory mCacheFactory;
    protected IMessageStub messageStub;

    public CacheProvider(IObjectRegistry registry, INamedCacheFactory cacheFactory) {
        this.mRegistry = registry;
        this.mCacheFactory = cacheFactory;
    }

    @Override
    public void initialize() {
        IMessageStub stub;
        if (this.cacheName == null) {
            throw BuiltinExceptionFactory.createAttributeMissing(this, "cacheName");
        }
        if (this.key == null) {
            throw BuiltinExceptionFactory.createAttributeMissing(this, "key");
        }
        this.logger = LoggingContext.getLogger(this.getClass().getCanonicalName(), this.mRegistry);
        this.procedureManager = (IProcedureManager)this.mRegistry.getInstanceOfType(IProcedureManager.class);
        if (this.procedureManager == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException(this, IProcedureManager.class, this.getClass().getName());
        }
        this.serviceFactory = (IServiceFactory)this.mRegistry.getInstanceOfType(IServiceFactory.class);
        if (this.serviceFactory == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException(this, IServiceFactory.class, this.getClass().getName());
        }
        this.dsFactory = (IDatabaseServiceFactory)this.mRegistry.getInstanceOfType(IDatabaseServiceFactory.class);
        if (this.dsFactory == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException(this, IDatabaseServiceFactory.class, this.getClass().getName());
        }
        if (this.reloadMessage == null) {
            this.reloadMessage = String.valueOf(this.cacheName) + "_reload";
        }
        if ((stub = (IMessageStub)this.mRegistry.getInstanceOfType(IMessageStub.class)) == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException(this, IMessageStub.class, this.getClass().getName());
        }
        IConsumer consumer = stub.getConsumer(this.reloadTopic);
        if (consumer == null) {
            if (!stub.isStarted()) {
                throw new IllegalStateException("MessageStub is not started, please check the configuration.");
            }
            throw new IllegalStateException("MessageStub does not define the reloadTopic '" + this.reloadTopic + "', please check the configuration.");
        }
        if (!(consumer instanceof INoticerConsumer)) {
            throw BuiltinExceptionFactory.createInstanceTypeWrongException(this.getOriginSource(), INoticerConsumer.class, IConsumer.class);
        }
        ((INoticerConsumer)consumer).addListener(this.reloadMessage, this);
        CacheProviderRegistry.put(this.cacheName, this);
        if (this.eventHandlers != null) {
            int i = 0;
            while (i < this.eventHandlers.length) {
                this.eventHandlers[i].init(this, this.mRegistry);
                ++i;
            }
        }
        this.initResourcePath();
        if (this.loadOnStartup) {
            this.initCacheData();
        }
        this.inited = true;
    }

    private void initResourcePath() {
        if (this.refreshBM != null && this.loadBM == null && this.loadProc == null) {
            this.loadBM = this.refreshBM;
        }
        if (this.loadBM != null && this.refreshBM == null && this.refreshProc == null) {
            this.refreshBM = this.loadBM;
        }
        if (this.refreshProc != null && this.loadProc == null && this.loadBM == null) {
            this.loadProc = this.refreshProc;
        }
        if (this.loadProc != null && this.refreshBM == null && this.refreshProc == null) {
            this.refreshProc = this.loadProc;
        }
        if (this.refreshBM != null && this.refreshProc != null) {
            throw BuiltinExceptionFactory.createConflictAttributesExcepiton(this, "refreshBM,refreshProc");
        }
        if (this.loadProc != null && this.loadBM != null) {
            throw BuiltinExceptionFactory.createConflictAttributesExcepiton(this, "loadProc,loadBM");
        }
        if (this.loadProc == null && this.loadBM == null) {
            throw BuiltinExceptionFactory.createOneAttributeMissing(this, "loadProc,loadBM");
        }
    }

    protected void initCacheData() {
        this.writeLock();
        try {
            try {
                if (this.isLoadByBM()) {
                    this.executeBM(new CompositeMap());
                } else {
                    this.executeProc(this.loadProc, null);
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        finally {
            this.writeUnLock();
        }
    }

    protected void executeBM(CompositeMap context) throws Exception {
        block15: {
            List childs;
            String type;
            CompositeMap data;
            block18: {
                block17: {
                    block16: {
                        if (this.loadBM == null) break block15;
                        data = this.queryBM(this.loadBM, context);
                        if (data == null) {
                            return;
                        }
                        if (this.groupByFields != null) {
                            CompositeMap config = new CompositeMap();
                            CompositeMap level1 = new CompositeMap();
                            level1.put("group_key_fields", this.groupByFields);
                            level1.put("record_name", "level1");
                            config.addChild(level1);
                            data = GroupTransformer.transformByConfig((CompositeMap)data.clone(), config);
                        }
                        type = this.getType();
                        childs = data.getChilds();
                        if (!ICacheProvider.VALUE_TYPE.value.name().equals(type)) break block16;
                        if (childs == null) {
                            String key = TextParser.parse(this.getKey(), data);
                            String value = TextParser.parse(this.getValue(), data);
                            this.cache.setValue(key, value);
                        } else {
                            for (Object child : data.getChilds()) {
                                CompositeMap record = (CompositeMap)child;
                                String key = TextParser.parse(this.getKey(), record);
                                String value = TextParser.parse(this.getValue(), record);
                                this.cache.setValue(key, value);
                            }
                        }
                        break block15;
                    }
                    if (!ICacheProvider.VALUE_TYPE.record.name().equals(type)) break block17;
                    if (childs == null) {
                        String key = TextParser.parse(this.getKey(), data);
                        this.cache.setValue(key, data);
                    } else {
                        for (Object child : data.getChilds()) {
                            CompositeMap record = (CompositeMap)child;
                            String key = TextParser.parse(this.getKey(), record);
                            this.cache.setValue(key, record);
                        }
                    }
                    break block15;
                }
                if (!ICacheProvider.VALUE_TYPE.valueSet.name().equals(type)) break block18;
                if (childs == null) {
                    return;
                }
                for (Object child : data.getChilds()) {
                    CompositeMap record = (CompositeMap)child;
                    String key = TextParser.parse(this.getKey(), record);
                    List new_values = record.getChilds();
                    if (new_values == null) {
                        throw new IllegalArgumentException("Value type is 'valueSet', please group by the data first!");
                    }
                    LinkedList<String> value_list = new LinkedList<String>();
                    this.cache.setValue(key, value_list);
                    for (Object value : new_values) {
                        CompositeMap newValue_record = (CompositeMap)value;
                        String new_value = TextParser.parse(this.getValue(), newValue_record);
                        value_list.add(new_value);
                    }
                }
                break block15;
            }
            if (!ICacheProvider.VALUE_TYPE.recordSet.name().equals(type)) break block15;
            if (childs == null) {
                return;
            }
            for (Object child : data.getChilds()) {
                CompositeMap record = (CompositeMap)child;
                String key = TextParser.parse(this.getKey(), record);
                List new_values = record.getChilds();
                if (new_values == null) {
                    throw new IllegalArgumentException("Value type is 'recordSet', please group by the data first!");
                }
                LinkedList value_list = new LinkedList();
                this.cache.setValue(key, value_list);
                value_list.addAll(new_values);
            }
        }
    }

    protected void executeProc(String procedure, CompositeMap context) {
        block8: {
            this.writeLock();
            try {
                try {
                    this.logger.log(Level.CONFIG, "load procedure:{0}", new Object[]{procedure});
                    Procedure proc = null;
                    try {
                        proc = this.procedureManager.loadProcedure(procedure);
                    }
                    catch (Exception ex) {
                        throw BuiltinExceptionFactory.createResourceLoadException(this, procedure, ex);
                    }
                    String name = "Cache." + procedure;
                    if (context != null) {
                        ServiceInvoker.invokeProcedureWithTransaction(name, proc, this.serviceFactory, context);
                        break block8;
                    }
                    ServiceInvoker.invokeProcedureWithTransaction(name, proc, this.serviceFactory);
                }
                catch (Exception ex) {
                    this.logger.log(Level.SEVERE, "Error when invoking procedure " + procedure, ex);
                    this.writeUnLock();
                }
            }
            finally {
                this.writeUnLock();
            }
        }
    }

    public CompositeMap queryBM(String bm_name, CompositeMap queryMap) throws Exception {
        SqlServiceContext sqlContext = this.dsFactory.createContextWithConnection();
        try {
            CompositeMap resultMap;
            CompositeMap context = sqlContext.getObjectContext();
            if (context == null) {
                context = new CompositeMap();
            }
            BusinessModelService service = this.dsFactory.getModelService(bm_name, context);
            CompositeMap compositeMap = resultMap = service.queryAsMap(queryMap, FetchDescriptor.fetchAll());
            return compositeMap;
        }
        finally {
            if (sqlContext != null) {
                sqlContext.freeConnection();
            }
        }
    }

    public CompositeMap queryBM(CompositeMap queryMap) throws Exception {
        return this.queryBM(this.getRefreshBM(), queryMap);
    }

    public void setName(String name) {
        this.cacheName = name;
    }

    @Override
    public void reload() {
        this.writeLock();
        try {
            this.inited = false;
            this.cache.clear();
            this.loadOnStartup = true;
            this.initCacheData();
            this.setLastReloadDate(new Date());
        }
        finally {
            this.writeUnLock();
        }
    }

    public Object getValue(CompositeMap parameter) {
        if (!this.inited) {
            try {
                this.initCacheData();
            }
            catch (Exception e) {
                throw new RuntimeException("init cache:" + this.getCacheName() + " failed!");
            }
        }
        this.readLock();
        try {
            String keyValue = TextParser.parse(this.key, parameter);
            Object object = this.cache.getValue(keyValue);
            return object;
        }
        finally {
            this.readUnLock();
        }
    }

    public String getRefreshBM() {
        return this.refreshBM;
    }

    public void setRefreshBM(String refreshBM) {
        this.refreshBM = refreshBM;
    }

    public String getCacheKey() {
        return this.key;
    }

    public void setCacheKey(String key) {
        this.key = key;
    }

    public boolean getLoadOnStart() {
        return this.loadOnStartup;
    }

    public void setLoadOnStart(boolean loadOnStart) {
        this.loadOnStartup = loadOnStart;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public IEventHandler[] getEventHandlers() {
        return this.eventHandlers;
    }

    public void setEventHandlers(IEventHandler[] eventHandlers) {
        this.eventHandlers = eventHandlers;
    }

    public String getLoadProc() {
        return this.loadProc;
    }

    public void setLoadProc(String loadProc) {
        this.loadProc = loadProc;
    }

    public String getRefreshProc() {
        return this.refreshProc;
    }

    public void setRefreshProc(String refreshProc) {
        this.refreshProc = refreshProc;
    }

    public String getLoadBM() {
        return this.loadBM;
    }

    public void setLoadBM(String loadBM) {
        this.loadBM = loadBM;
    }

    protected boolean isLoadByBM() {
        return this.loadBM != null;
    }

    protected boolean isRefreshByBM() {
        return this.refreshBM != null;
    }

    public boolean isConcurrent() {
        return this.isConcurrent;
    }

    public void setConcurrent(boolean isConcurrent) {
        this.isConcurrent = isConcurrent;
    }

    @Override
    public void writeLock() {
        if (!this.isConcurrent) {
            return;
        }
        ((IReadWriteLockable)((Object)this.cache)).writeLock().lock();
    }

    @Override
    public void writeUnLock() {
        if (!this.isConcurrent) {
            return;
        }
        ((IReadWriteLockable)((Object)this.cache)).writeLock().unlock();
    }

    @Override
    public void readLock() {
        if (!this.isConcurrent) {
            return;
        }
        ((IReadWriteLockable)((Object)this.cache)).readLock().lock();
    }

    @Override
    public void readUnLock() {
        if (!this.isConcurrent) {
            return;
        }
        ((IReadWriteLockable)((Object)this.cache)).readLock().unlock();
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String getCacheName() {
        return this.cacheName;
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    public void removeKey(String key) {
        this.cache.remove(key);
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public ICache getCache() {
        return this.cache;
    }

    public String getGroupByFields() {
        return this.groupByFields;
    }

    public void setGroupByFields(String groupByFields) {
        this.groupByFields = groupByFields;
    }

    @Override
    public String getCacheDesc() {
        return this.cacheDesc;
    }

    public void setCacheDesc(String cacheDesc) {
        this.cacheDesc = cacheDesc;
    }

    @Override
    public String getReloadTopic() {
        return this.reloadTopic;
    }

    public void setReloadTopic(String reloadTopic) {
        this.reloadTopic = reloadTopic;
    }

    @Override
    public String getReloadMessage() {
        return this.reloadMessage;
    }

    public void setReloadMessage(String reloadMessage) {
        this.reloadMessage = reloadMessage;
    }

    @Override
    public Date getLastReloadDate() {
        return this.lastReloadDate;
    }

    public void setLastReloadDate(Date date) {
        this.lastReloadDate = date;
    }

    @Override
    public void onMessage(IMessage message) {
        try {
            if (this.reloadMessage.equals(message.getText())) {
                this.reload();
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "reload failed!", e);
        }
    }

    @Override
    public boolean startup() {
        this.cache = this.mCacheFactory.getNamedCache(this.cacheName);
        if (this.cache == null) {
            throw new GeneralException("uncertain.cache.named_cache_not_found", new Object[]{this.cache}, this);
        }
        if (this.isConcurrent) {
            this.cache = new ConcurrentCache(this.cache);
            this.mCacheFactory.setNamedCache(this.cacheName, this.cache);
        }
        return true;
    }

    @Override
    public void shutdown() {
    }
}

