/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.features.msg;

import aurora.application.features.msg.IMessage;
import aurora.application.features.msg.IMessageHandler;
import aurora.application.features.msg.IMessageListener;
import aurora.service.IServiceFactory;
import aurora.service.ServiceInvoker;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import uncertain.composite.CompositeMap;
import uncertain.core.UncertainEngine;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.AbstractLocatableObject;
import uncertain.ocm.IObjectRegistry;
import uncertain.proc.IProcedureManager;
import uncertain.proc.Procedure;

public class DefaultMessageHandler
extends AbstractLocatableObject
implements IMessageHandler {
    private IObjectRegistry registry;
    private String name;
    private String procedure;
    private String className;
    private IProcedureManager procedureManager;
    private IServiceFactory serviceFactory;
    private UncertainEngine uncertainEngine;

    public DefaultMessageHandler(IObjectRegistry registry) {
        this.registry = registry;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void onMessage(IMessage message) {
        ILogger logger = LoggingContext.getLogger(this.getClass().getPackage().getName(), this.registry);
        logger.log(Level.INFO, "accepted a new message!");
        if (message == null) {
            logger.log(Level.WARNING, "message is null");
            return;
        }
        if (this.procedure == null && this.className == null) {
            throw BuiltinExceptionFactory.createAttributeMissing(this, "procedure,className");
        }
        if (this.procedure != null && this.className != null) {
            throw BuiltinExceptionFactory.createConflictAttributesExcepiton(this, "procedure,className");
        }
        if (this.procedure != null) {
            if (this.procedureManager == null) {
                this.procedureManager = (IProcedureManager)this.registry.getInstanceOfType(IProcedureManager.class);
                if (this.procedureManager == null) {
                    throw BuiltinExceptionFactory.createInstanceNotFoundException(this, IProcedureManager.class, this.getClass().getName());
                }
                this.serviceFactory = (IServiceFactory)this.registry.getInstanceOfType(IServiceFactory.class);
                if (this.serviceFactory == null) {
                    throw BuiltinExceptionFactory.createInstanceNotFoundException(this, IServiceFactory.class, this.getClass().getName());
                }
            }
            CompositeMap context = new CompositeMap();
            try {
                CompositeMap properties = message.getProperties();
                if (properties != null && !properties.isEmpty()) {
                    Set entrySet = properties.entrySet();
                    for (Map.Entry entry : entrySet) {
                        context.putObject("/parameter/message/@" + entry.getKey(), entry.getValue(), true);
                    }
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error when handle message properties ", e);
            }
            try {
                try {
                    logger.log(Level.CONFIG, "receive message text:{0}", new Object[]{message.getText()});
                    logger.log(Level.CONFIG, "load procedure:{0}", new Object[]{this.procedure});
                    Procedure proc = null;
                    try {
                        proc = this.procedureManager.loadProcedure(this.procedure);
                    }
                    catch (Exception ex) {
                        throw BuiltinExceptionFactory.createResourceLoadException(this, this.procedure, ex);
                    }
                    String name = "MSG." + this.procedure;
                    ServiceInvoker.invokeProcedureWithTransaction(name, proc, this.serviceFactory, context);
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, "Error when invoking procedure " + this.procedure, ex);
                    context.clear();
                }
            }
            finally {
                context.clear();
            }
        } else {
            this.uncertainEngine = (UncertainEngine)this.registry.getInstanceOfType(UncertainEngine.class);
            try {
                Class<?> run_class = Class.forName(this.className);
                Object object = this.uncertainEngine.getObjectCreator().createInstance(run_class);
                if (object == null) {
                    throw new IllegalArgumentException(" Can not create instance for " + run_class);
                }
                if (!(object instanceof IMessageListener)) {
                    throw BuiltinExceptionFactory.createInstanceTypeWrongException("", IMessageListener.class, object.getClass());
                }
                IMessageListener lis = (IMessageListener)object;
                lis.onMessage(message);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "", e);
            }
        }
    }

    public String getProcedure() {
        return this.procedure;
    }

    public void setProcedure(String procedure) {
        this.procedure = procedure;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }
}

