/*
 * Decompiled with CFR 0.152.
 */
package aurora.bm;

import aurora.bm.BmBuiltinExceptionFactory;
import aurora.bm.BusinessModel;
import aurora.bm.IModelFactory;
import java.io.IOException;
import java.util.Iterator;
import org.xml.sax.SAXException;
import uncertain.cache.CacheFactoryConfig;
import uncertain.cache.ICache;
import uncertain.composite.CompositeLoader;
import uncertain.composite.CompositeMap;
import uncertain.composite.CompositeUtil;
import uncertain.exception.MessageFactory;
import uncertain.ocm.IObjectRegistry;
import uncertain.ocm.OCManager;

public class ModelFactory
implements IModelFactory {
    public static final String DEFAULT_MODEL_EXTENSION = "bm";
    OCManager mOcManager;
    CompositeLoader mCompositeLoader;
    IObjectRegistry mObjRegistry;
    boolean mUseCache = false;
    ICache mModelCache;

    static {
        MessageFactory.loadResource("resources/aurora_bm_exceptions");
    }

    public void onInitialize() {
        ICache cache;
        if (this.mObjRegistry != null && (cache = CacheFactoryConfig.getNamedCache(this.mObjRegistry, "BusinessModel")) != null) {
            this.setUseCache(true);
            this.setCache(cache);
        }
    }

    public boolean getUseCache() {
        return this.mUseCache;
    }

    public void setUseCache(boolean useCache) {
        this.mUseCache = useCache;
        if (!this.mUseCache && this.mModelCache != null) {
            this.mModelCache.clear();
        }
    }

    public ICache getCache() {
        return this.mModelCache;
    }

    public void setCache(ICache mModelCache) {
        this.mModelCache = mModelCache;
    }

    private String getCacheKey(String name, String ext) {
        return String.valueOf(name) + '[' + ext + ']';
    }

    public ModelFactory(OCManager ocm) {
        this.mOcManager = ocm;
        this.mCompositeLoader = CompositeLoader.createInstanceForOCM();
        this.mCompositeLoader.setDefaultExt(DEFAULT_MODEL_EXTENSION);
    }

    public ModelFactory(OCManager ocm, IObjectRegistry reg) {
        this(ocm);
        this.mObjRegistry = reg;
    }

    private void saveCachedModel(String name, BusinessModel model) {
        if (this.mUseCache && this.mModelCache != null) {
            this.mModelCache.setValue(name, model);
        }
    }

    @Override
    public BusinessModel getModelForRead(String name, String ext) throws IOException {
        if (!this.mUseCache) {
            return this.getNewModelInstance(name, ext);
        }
        String full_name = this.getCacheKey(name, ext);
        BusinessModel model = (BusinessModel)this.mModelCache.getValue(full_name);
        if (model == null) {
            model = this.getNewModelInstance(name, ext);
            this.saveCachedModel(full_name, model);
        }
        return model;
    }

    @Override
    public BusinessModel getModelForRead(String name) throws IOException {
        return this.getModelForRead(name, this.mCompositeLoader.getDefaultExt());
    }

    @Override
    public BusinessModel getModel(CompositeMap config) {
        BusinessModel model = this.createBusinessModelInternal(config);
        return model;
    }

    private CompositeMap mergeConfig(CompositeMap config, CompositeMap base_config, boolean is_override) {
        CompositeMap merged_map = (CompositeMap)config.clone();
        CompositeUtil.copyAttributes(base_config, merged_map);
        Iterator it = base_config.getChildIterator();
        while (it.hasNext()) {
            CompositeMap origin_child = (CompositeMap)it.next();
            String name = origin_child.getName();
            CompositeMap new_child = merged_map.getChild(name);
            if (new_child != null) {
                if (is_override) {
                    CompositeUtil.mergeChildsByOverride(origin_child, new_child, "name");
                    continue;
                }
                CompositeUtil.mergeChildsByReference(origin_child, new_child, "name");
                continue;
            }
            merged_map.addChild((CompositeMap)origin_child.clone());
        }
        return merged_map;
    }

    protected BusinessModel createBusinessModelInternal(CompositeMap config) {
        BusinessModel model = new BusinessModel();
        model.setModelFactory(this);
        model.setOcManager(this.mOcManager);
        model.initialize(config);
        String base = model.getExtend();
        if (base != null) {
            String mode = model.getExtendMode();
            if (mode == null) {
                mode = "override";
            }
            boolean is_override = "override".equalsIgnoreCase(mode);
            try {
                BusinessModel parent_model = this.getModelForRead(base);
                CompositeMap final_config = this.mergeConfig(config, parent_model.getObjectContext(), is_override);
                model.initialize(final_config);
                model.setParent(parent_model);
            }
            catch (IOException ex) {
                throw BmBuiltinExceptionFactory.createParentBMLoadException(base, config, ex);
            }
        }
        model.makeReady();
        return model;
    }

    protected BusinessModel getNewModelInstance(String name, String ext) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException("model name is null");
        }
        try {
            CompositeMap config = this.mCompositeLoader.loadFromClassPath(name, ext);
            if (config == null) {
                throw new IOException("Can't load resource " + name);
            }
            BusinessModel model = this.createBusinessModelInternal(config);
            model.setName(name);
            return model;
        }
        catch (SAXException ex) {
            throw new RuntimeException("Error when parsing " + name, ex);
        }
    }

    @Override
    public CompositeMap getModelConfig(String name, String ext) throws IOException {
        BusinessModel model = this.getNewModelInstance(name, ext);
        return model.getObjectContext();
    }

    @Override
    public CompositeMap getModelConfig(String name) throws IOException {
        return this.getModelConfig(name, this.mCompositeLoader.getDefaultExt());
    }

    @Override
    public BusinessModel getModel(String name, String ext) throws IOException {
        return this.getNewModelInstance(name, ext);
    }

    @Override
    public BusinessModel getModel(String name) throws IOException {
        return this.getModel(name, this.mCompositeLoader.getDefaultExt());
    }

    @Override
    public CompositeLoader getCompositeLoader() {
        return this.mCompositeLoader;
    }
}

