/*
 * Decompiled with CFR 0.152.
 */
package aurora.database.features;

import aurora.bm.BusinessModel;
import aurora.bm.DataFilter;
import aurora.bm.Field;
import aurora.bm.QueryField;
import aurora.database.profile.IDatabaseFactory;
import aurora.database.profile.IDatabaseProfile;
import aurora.database.service.BusinessModelServiceContext;
import aurora.database.service.RawSqlService;
import aurora.database.service.ServiceOption;
import aurora.database.sql.ConditionList;
import aurora.database.sql.ISqlStatement;
import aurora.database.sql.IWithWhereClause;
import aurora.database.sql.RawSqlExpression;
import aurora.database.sql.SelectField;
import aurora.database.sql.SelectStatement;
import uncertain.composite.CompositeMap;
import uncertain.core.ConfigurationError;

public class WhereClauseCreator {
    public static final String WHERE_CLAUSE = "#WHERE_CLAUSE#";
    IDatabaseFactory mFactory;

    public WhereClauseCreator(IDatabaseFactory fact) {
        this.mFactory = fact;
    }

    static boolean isInOperation(String operation, String[] operations) {
        if (operation == null) {
            return true;
        }
        boolean found = false;
        int n = 0;
        while (n < operations.length) {
            if (operation.equalsIgnoreCase(operations[n])) {
                found = true;
                break;
            }
            ++n;
        }
        return found;
    }

    public void addDataFilterConditions(String operation, ConditionList conditions, DataFilter[] filters) {
        if (filters == null) {
            return;
        }
        int i = 0;
        while (i < filters.length) {
            DataFilter filter = filters[i];
            String[] operations = filter.getEnforceOperations();
            if (operations == null || WhereClauseCreator.isInOperation(operation, operations)) {
                String exp = filter.getExpression();
                if (exp == null) {
                    throw new ConfigurationError("Must set 'expression' property for " + filter.getObjectContext().toXML() + " No." + (i + 1));
                }
                conditions.addCondition(new RawSqlExpression(exp));
            }
            ++i;
        }
    }

    public void addQueryConditions(CompositeMap parameter, SelectStatement select, BusinessModel model) {
        QueryField[] fields = model.getQueryFieldsArray();
        if (fields == null) {
            return;
        }
        ConditionList where = select.getWhereClause();
        int i = 0;
        while (i < fields.length) {
            QueryField qf = fields[i];
            String field_name = qf.getField();
            Field field = null;
            boolean has_field = true;
            if (field_name != null) {
                field = model.getField(field_name);
                if (field != null && field.isReferenceField()) {
                    throw new ConfigurationError("query option for reference field is not supported yet");
                }
            } else {
                has_field = false;
                field_name = qf.getName();
                if (field_name == null) {
                    throw new ConfigurationError("must set either 'name' or 'field' property for query field: " + qf.getObjectContext().toXML());
                }
                field = (Field)qf.castTo(Field.class);
            }
            if (field == null) {
                throw new IllegalArgumentException("Can't get query field for " + qf.getObjectContext().toXML());
            }
            String path = field.getInputPath();
            if (parameter.getObject(path) != null) {
                if (has_field) {
                    SelectField select_field = select.getField(field.getName());
                    if (select_field != null) {
                        qf.addToWhereClause(where, select_field, field.getInputPath());
                    } else {
                        qf.addToWhereClause(where, new RawSqlExpression(field.getPhysicalName()), field.getInputPath());
                    }
                } else {
                    qf.addToWhereClause(where, "@" + qf.getName());
                }
            }
            ++i;
        }
    }

    public void addDefaultWhereClause(BusinessModelServiceContext bmsc, ConditionList where) {
        String operation_defined_where;
        ServiceOption option = bmsc.getServiceOption();
        if (option != null && (operation_defined_where = option.getDefaultWhereClause()) != null) {
            where.addCondition(new RawSqlExpression(operation_defined_where));
        }
    }

    public void doPopulateStatement(BusinessModelServiceContext bmsc) {
        ISqlStatement s = bmsc.getStatement();
        if (s instanceof IWithWhereClause) {
            IWithWhereClause statement = (IWithWhereClause)((Object)s);
            ConditionList where = statement.getWhereClause();
            BusinessModel model = bmsc.getBusinessModel();
            if (model == null) {
                return;
            }
            String operation = bmsc.getOperation();
            this.addDataFilterConditions(operation, where, model.getDataFilters());
            this.addDefaultWhereClause(bmsc, where);
            if (s instanceof SelectStatement) {
                this.addQueryConditions(bmsc.getCurrentParameter(), (SelectStatement)s, model);
            }
        }
    }

    public void onPopulateUpdateStatement(BusinessModelServiceContext bmsc) {
        this.doPopulateStatement(bmsc);
    }

    public void onPopulateDeleteStatement(BusinessModelServiceContext bmsc) {
        this.doPopulateStatement(bmsc);
    }

    public void onPopulateQueryStatement(BusinessModelServiceContext bmsc) {
        this.doPopulateStatement(bmsc);
    }

    public void onPopulateQuerySql(BusinessModelServiceContext bmsc, RawSqlService service, StringBuffer sql) {
        this.doPopulateSql(bmsc, sql);
    }

    public void doPopulateSql(BusinessModelServiceContext bmsc, StringBuffer sql) {
        IDatabaseProfile profile;
        BusinessModel model = bmsc.getBusinessModel();
        int index = sql.indexOf(WHERE_CLAUSE);
        if (index < 0) {
            return;
        }
        SelectStatement select = new SelectStatement();
        ConditionList where = select.getWhereClause();
        this.addDataFilterConditions(bmsc.getOperation(), where, model.getDataFilters());
        this.addQueryConditions(bmsc.getCurrentParameter(), select, model);
        this.addDefaultWhereClause(bmsc, where);
        String db_type = model.getDatabaseType();
        IDatabaseProfile iDatabaseProfile = profile = db_type == null ? this.mFactory.getDefaultDatabaseProfile() : this.mFactory.getDatabaseProfile(db_type);
        if (profile == null) {
            throw new IllegalArgumentException("Unkown database type:" + db_type);
        }
        String where_clause = profile.getSqlBuilderRegistry().getSql(where);
        if (where_clause == null) {
            where_clause = "";
        } else if ((where_clause = where_clause.trim()).length() > 0) {
            where_clause = " WHERE " + where_clause;
        }
        sql.replace(index, index + WHERE_CLAUSE.length(), where_clause);
    }

    public void onPopulateOperationSql(BusinessModelServiceContext bmsc, StringBuffer sql) {
        this.doPopulateSql(bmsc, sql);
    }
}

