/*
 * Decompiled with CFR 0.152.
 */
package aurora.database.service;

import aurora.bm.BusinessModel;
import aurora.bm.Operation;
import aurora.database.DBUtil;
import aurora.database.FetchDescriptor;
import aurora.database.IResultSetConsumer;
import aurora.database.ParsedSql;
import aurora.database.SqlRunner;
import aurora.database.rsconsumer.CompositeMapCreator;
import aurora.database.service.BusinessModelServiceContext;
import aurora.database.service.DatabaseServiceFactory;
import aurora.database.service.SqlServiceContext;
import aurora.database.sql.ISqlStatement;
import aurora.database.sql.IStatementWithParameter;
import aurora.service.ServiceContext;
import aurora.service.exception.ExceptionDescriptorConfig;
import aurora.service.validation.IParameterIterator;
import aurora.service.validation.ParameterParser;
import aurora.service.validation.ValidationException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import uncertain.composite.CompositeMap;
import uncertain.core.ConfigurationError;
import uncertain.event.Configuration;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.IObjectRegistry;
import uncertain.ocm.OCManager;
import uncertain.proc.IExceptionHandle;
import uncertain.proc.ProcedureRunner;

public class BusinessModelService {
    public static final String PROC_EXECUTE_DML = "aurora.database.service.bm.execute_dml";
    public static final String PROC_QUERY = "aurora.database.service.bm.query";
    public static final String PROC_CREATE_SQL = "aurora.database.service.bm.create_sql";
    BusinessModel mBusinessModel;
    ExceptionDescriptorConfig mExceptionProcessor;
    Configuration mConfig;
    DatabaseServiceFactory mServiceFactory;
    CompositeMap mContextMap;
    BusinessModelServiceContext mServiceContext;
    ProcedureRunner mRunner;
    Configuration mOldConfig = null;
    IObjectRegistry mObjectRegistry;
    OCManager mOcManager;
    ILogger mLogger;

    protected BusinessModelService(DatabaseServiceFactory factory, Configuration config, BusinessModel model, CompositeMap context_map) throws Exception {
        this.mConfig = config;
        this.mBusinessModel = model;
        this.mServiceFactory = factory;
        this.mObjectRegistry = factory.getObjectRegistry();
        this.mOcManager = (OCManager)this.mObjectRegistry.getInstanceOfType(OCManager.class);
        this.setContextMap(context_map);
        this.mLogger = LoggingContext.getLogger(this.mServiceContext.getObjectContext(), "aurora.database");
        CompositeMap cfg = model.getExceptionDescriptorConfig();
        if (cfg != null) {
            this.mExceptionProcessor = (ExceptionDescriptorConfig)this.mOcManager.createObject(cfg);
            if (this.mExceptionProcessor == null) {
                throw new ConfigurationError("Can't create " + ExceptionDescriptorConfig.class.getName() + " instance from config:" + cfg.toXML());
            }
        }
    }

    protected void prepareForRun(String proc_name) throws ValidationException, SQLException {
        this.mRunner = this.mServiceFactory.loadProcedure(proc_name, this.mContextMap);
        this.parseParameter(this.mServiceContext);
        this.mServiceContext.prepareForRun();
        this.mServiceContext.initConnection(this.mObjectRegistry, this.mBusinessModel.getDataSourceName());
        this.mServiceContext.put("BusinessModel", this.mBusinessModel);
        if (this.mExceptionProcessor != null) {
            this.mRunner.addExceptionHandle(new IExceptionHandle(){

                @Override
                public boolean handleException(ProcedureRunner runner, Throwable exception) {
                    CompositeMap msg = BusinessModelService.this.mExceptionProcessor.process(BusinessModelService.this.mServiceContext, exception);
                    if (msg != null) {
                        BusinessModelService.this.mServiceContext.setError(msg);
                        BusinessModelService.this.mServiceContext.putBoolean("success", false);
                        BusinessModelService.this.mRunner.setResumeAfterException(true);
                        BusinessModelService.this.mServiceContext.setSuccess(true);
                        return true;
                    }
                    return false;
                }
            });
        }
        this.mRunner.setSaveStackTrace(false);
    }

    public void setServiceContext(ServiceContext context) {
        this.setContextMap(context.getObjectContext());
    }

    public void setContextMap(CompositeMap map) {
        this.mContextMap = map;
        if (this.mServiceContext == null) {
            this.mServiceContext = new BusinessModelServiceContext();
        }
        this.mServiceContext.initialize(this.mContextMap);
        this.mServiceContext.setBusinessModel(this.mBusinessModel);
    }

    public BusinessModelServiceContext getServiceContext() {
        return this.mServiceContext;
    }

    public ProcedureRunner getRunner() {
        return this.mRunner;
    }

    public BusinessModel getBusinessModel() {
        return this.mBusinessModel;
    }

    private void pushConfig() {
        this.mOldConfig = this.mServiceContext.getConfig();
        this.mServiceContext.setConfig(this.mConfig);
    }

    private void popConfig() {
        this.mServiceContext.setConfig(this.mOldConfig);
        this.mOldConfig = null;
    }

    public StringBuffer getSql(String operation) throws Exception {
        this.mServiceContext.setOperation(operation);
        this.pushConfig();
        try {
            this.prepareForRun(PROC_CREATE_SQL);
            this.mRunner.run();
            this.mRunner.checkAndThrow();
        }
        finally {
            this.popConfig();
        }
        return this.mServiceContext.getSqlString();
    }

    public void query(Map parameters, IResultSetConsumer consumer, FetchDescriptor desc) throws Exception {
        this.pushConfig();
        try {
            this.mServiceContext.setOperation("query");
            this.prepareForRun(PROC_QUERY);
            if (parameters != null) {
                this.mServiceContext.setCurrentParameter(parameters);
            }
            this.mServiceContext.setResultsetConsumer(consumer);
            this.mServiceContext.setFetchDescriptor(desc);
            this.mRunner.setSaveStackTrace(false);
            this.mRunner.run();
            this.mRunner.checkAndThrow();
        }
        finally {
            this.popConfig();
            this.printTraceInfo();
        }
    }

    public CompositeMap queryAsMap(Map parameters, FetchDescriptor desc) throws Exception {
        CompositeMapCreator map_creator = new CompositeMapCreator();
        this.query(parameters, map_creator, desc);
        return map_creator.getCompositeMap();
    }

    public CompositeMap queryAsMap(Map parameters) throws Exception {
        FetchDescriptor desc = FetchDescriptor.fetchAll();
        return this.queryAsMap(parameters, desc);
    }

    public CompositeMap queryIntoMap(Map parameters, FetchDescriptor desc, CompositeMap root) throws Exception {
        CompositeMapCreator map_creator = new CompositeMapCreator(root);
        this.query(parameters, map_creator, desc);
        return map_creator.getCompositeMap();
    }

    public void query() throws Exception {
        CompositeMap param = this.mServiceContext.getCurrentParameter();
        IResultSetConsumer consumer = this.mServiceContext.getResultsetConsumer();
        if (consumer == null) {
            throw new IllegalStateException("IResultSetConsumer instance is not set in service context");
        }
        FetchDescriptor desc = this.mServiceContext.getFetchDescriptor();
        if (desc == null) {
            desc = FetchDescriptor.createFromParameter(this.mServiceContext.getParameter());
        }
        this.query(param, consumer, desc);
    }

    protected void runProcedure(Map parameters, String proc_name) throws Exception {
        this.pushConfig();
        try {
            if (parameters != null) {
                this.mServiceContext.setCurrentParameter(parameters);
            }
            this.prepareForRun(proc_name);
            this.mRunner.run();
            this.mRunner.checkAndThrow();
        }
        finally {
            this.popConfig();
            this.printTraceInfo();
        }
    }

    public void executeDml(Map parameters, String operation) throws Exception {
        this.mServiceContext.getObjectContext().put("SqlStatementType", new StringBuffer(operation));
        this.mServiceContext.setOperation(operation);
        this.runProcedure(parameters, PROC_EXECUTE_DML);
    }

    public void updateByPK(Map parameters) throws Exception {
        this.executeDml(parameters, "Update");
    }

    public void insert(Map parameters) throws Exception {
        this.executeDml(parameters, "Insert");
    }

    public void deleteByPK(Map parameters) throws Exception {
        this.executeDml(parameters, "Delete");
    }

    public void execute(Map parameters) throws Exception {
        this.executeDml(parameters, "Execute");
    }

    public void parseParameter(ServiceContext context) throws ValidationException {
        String operation = this.mServiceContext.getOperation();
        CompositeMap parameter = context.getCurrentParameter();
        boolean parsed = parameter.getBoolean("__parameter_parsed__", false);
        if (!parsed) {
            ParameterParser parser = ParameterParser.getInstance();
            List exceptions = null;
            IParameterIterator params = this.mBusinessModel.getParameterForOperation(operation);
            if (params != null) {
                exceptions = parser.parse(parameter, params);
                if (exceptions != null) {
                    ValidationException exp = new ValidationException(parameter, exceptions);
                    throw exp;
                }
                parameter.putBoolean("__parameter_parsed__", true);
            }
        }
    }

    void printTraceInfo() {
        ILogger logger = LoggingContext.getLogger(this.mServiceContext.getObjectContext(), "aurora.database");
        SqlRunner runner = this.mServiceContext.getSqlRunner();
        DBUtil.printTraceInfo(this.mServiceContext.getOperation(), logger, runner);
    }

    public Configuration getConfiguration() {
        return this.mConfig;
    }

    public void onCreateSqlRunner(StringBuffer sql) {
        if (sql == null) {
            throw new IllegalStateException("No SQL created in context");
        }
        BusinessModelServiceContext bmsc = this.mServiceContext;
        Collection parameters = null;
        ISqlStatement stmt = bmsc.getStatement();
        if (stmt != null && stmt instanceof IStatementWithParameter) {
            parameters = ((IStatementWithParameter)((Object)stmt)).getParameters();
        }
        ParsedSql s = new ParsedSql();
        if (parameters != null) {
            s.defineParameters(parameters, true);
        }
        List param_list = this.mBusinessModel.getParameterForOperationInList(this.mServiceContext.getOperation());
        s.defineParameters(param_list, false);
        s.parse(sql.toString());
        SqlRunner runner = BusinessModelService.createSqlRunner(bmsc, s);
        bmsc.setSqlRunner(runner);
    }

    public static SqlRunner createSqlRunner(BusinessModelServiceContext bmsc, ParsedSql parsedSql) {
        SqlServiceContext context = null;
        CompositeMap root = bmsc.getObjectContext().getRoot();
        context = root != null ? SqlServiceContext.createSqlServiceContext(root) : bmsc;
        SqlRunner runner = new SqlRunner(context, parsedSql);
        runner.setConnectionName(bmsc.getBusinessModel().getDataSourceName());
        return runner;
    }

    public void onExecuteDmlStatement(SqlRunner runner) throws Exception {
        runner.update(this.mServiceContext.getCurrentParameter());
    }

    public void onDecideSqlGenerationMode(String operation) {
        String predefined_sql = null;
        Operation op = this.mBusinessModel.getOperation(operation);
        if (op != null) {
            predefined_sql = op.getSql();
        }
        if (predefined_sql != null) {
            this.mServiceContext.setSqlGenerationMode("Predefined");
            this.mServiceContext.setSqlString(new StringBuffer(predefined_sql));
        } else {
            this.mServiceContext.setSqlGenerationMode("AutoGenerate");
            this.mServiceContext.setStatementType(operation);
            this.mServiceContext.setSqlString(null);
        }
    }
}

