/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.c3p0;

import com.mchange.v2.c3p0.DataSources;
import java.util.logging.Level;
import javax.sql.DataSource;
import uncertain.core.UncertainEngine;
import uncertain.logging.ILogger;
import uncertain.ocm.IObjectRegistry;

public class DataSourceConfig {
    String mUrl;
    String mUserName;
    String mPassword;
    boolean mPool;
    String mDriverClass;
    DataSource mDataSource;
    IObjectRegistry mObjectRegistry;
    ILogger mLogger;

    public DataSourceConfig(UncertainEngine engine) {
        this.mObjectRegistry = engine.getObjectRegistry();
        this.mLogger = engine.getLogger("uncertain.core");
    }

    public DataSourceConfig(ILogger logger, IObjectRegistry reg) {
        this.mLogger = logger;
        this.mObjectRegistry = reg;
    }

    public String getUrl() {
        return this.mUrl;
    }

    public void setUrl(String url) {
        this.mUrl = url;
    }

    public String getUserName() {
        return this.mUserName;
    }

    public void setUserName(String userName) {
        this.mUserName = userName;
    }

    public String getPassword() {
        return this.mPassword;
    }

    public void setPassword(String password) {
        this.mPassword = password;
    }

    public void onInitialize() throws Exception {
        if (this.mDriverClass != null) {
            Class.forName(this.mDriverClass).newInstance();
        }
        DataSource unpooled = DataSources.unpooledDataSource((String)this.mUrl, (String)this.mUserName, (String)this.mPassword);
        this.mDataSource = this.mPool ? DataSources.pooledDataSource((DataSource)unpooled) : unpooled;
        this.mLogger.log(Level.CONFIG, "Setting up pooled DataSource:{0}, database user:{1}", new Object[]{this.mUrl, this.mUserName});
        this.mObjectRegistry.registerInstance(DataSource.class, this.mDataSource);
    }

    public void onShutdown() throws Exception {
        if (this.mDataSource != null) {
            DataSources.destroy((DataSource)this.mDataSource);
        }
    }

    public DataSource getDataSource() {
        return this.mDataSource;
    }

    public boolean getPool() {
        return this.mPool;
    }

    public void setPool(boolean pool) {
        this.mPool = pool;
    }

    public String getDriverClass() {
        return this.mDriverClass;
    }

    public void setDriverClass(String driverClass) {
        this.mDriverClass = driverClass;
    }
}

