/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation;

import aurora.application.features.ILookupCodeProvider;
import aurora.i18n.DummyLocalizedMessageProvider;
import aurora.i18n.ILocalizedMessageProvider;
import aurora.i18n.LocalizedMessageTagCreator;
import aurora.presentation.IResourceUrlMapper;
import aurora.presentation.IViewBuilder;
import aurora.presentation.PresentationManager;
import aurora.presentation.TagParseUtil;
import aurora.presentation.ViewComponentPackage;
import aurora.presentation.ViewContext;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import uncertain.composite.CompositeMap;
import uncertain.composite.QualifiedName;
import uncertain.event.Configuration;
import uncertain.event.HandleManager;
import uncertain.event.RuntimeContext;
import uncertain.logging.DummyLogger;
import uncertain.logging.ILogger;
import uncertain.logging.ILoggerProvider;
import uncertain.util.template.ITagCreatorRegistry;
import uncertain.util.template.TagCreatorRegistry;
import uncertain.util.template.TextTemplate;

public class BuildSession {
    public static final String LOGGING_TOPIC = "aurora.presentation.buildsession";
    protected Writer mWriter;
    Configuration mCurrentConfig;
    PresentationManager mOwner;
    ViewComponentPackage mCurrentPackage;
    String mTheme = "default";
    CompositeMap mSessionContext;
    RuntimeContext mRuntimeContext;
    Set mIncludedResourceSet;
    Map mNamedViewContextMap;
    Configuration mBaseConfig;
    String contextPath;
    ILocalizedMessageProvider mMessageProvider = DummyLocalizedMessageProvider.DEFAULT_INSTANCE;
    ITagCreatorRegistry mSessionTagCreatorRegistry;
    String title;
    String manifest;
    String labelSeparator;
    String radioSeparator;
    ILookupCodeProvider lookupProvider;
    int defaultPageSize;
    String language;

    public BuildSession(PresentationManager pm) {
        this.mOwner = pm;
        this.mSessionContext = new CompositeMap("build-session");
        this.mRuntimeContext = RuntimeContext.getInstance(this.mSessionContext);
    }

    public PresentationManager getPresentationManager() {
        return this.mOwner;
    }

    private void startSession(CompositeMap view) {
        if (this.mBaseConfig != null) {
            this.mCurrentConfig = this.mBaseConfig;
        } else {
            this.mCurrentConfig = this.mOwner.createConfiguration();
            this.mCurrentConfig.setLogger(this.getLogger());
        }
        this.mCurrentConfig.loadConfig(view);
    }

    private void endSession() {
        this.mCurrentConfig = null;
        this.mCurrentPackage = null;
    }

    public void buildViewFromBegin(CompositeMap model, CompositeMap view) throws Exception {
        Configuration config = this.mCurrentConfig;
        ViewComponentPackage pkg = this.mCurrentPackage;
        this.mCurrentConfig = null;
        this.mCurrentPackage = null;
        try {
            this.buildView(model, view);
        }
        finally {
            this.mCurrentConfig = config;
            this.mCurrentPackage = pkg;
        }
    }

    public void buildView(CompositeMap model, CompositeMap view) throws Exception {
        ILogger logger = this.getLogger();
        boolean from_begin = false;
        if (this.mCurrentConfig == null) {
            this.startSession(view);
            from_begin = true;
            logger.config("Start build session");
        }
        ViewComponentPackage old_package = this.mCurrentPackage;
        this.mCurrentPackage = this.mOwner.getPackage(view);
        ViewContext context = this.getNamedViewContext(view.getQName());
        if (context != null) {
            context.model = model;
            context.view = view;
        } else {
            context = new ViewContext(model, view);
        }
        IViewBuilder builder = this.mOwner.getViewBuilder(view);
        if (builder == null) {
            throw new IllegalStateException("Can't get IViewBuilder instance for " + view.toXML());
        }
        logger.log(Level.CONFIG, "building view: <{0}> -> {1}", new Object[]{view.getName(), builder});
        String[] events = builder.getBuildSteps(context);
        if (events != null) {
            this.fireBuildEvents(events, context);
        }
        builder.buildView(this, context);
        this.mCurrentPackage = old_package;
        if (from_begin) {
            this.endSession();
            logger.config("End build session");
        }
    }

    public String buildViewAsString(CompositeMap model, CompositeMap view) throws Exception {
        Writer old_writer = this.mWriter;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            PrintWriter out = new PrintWriter(bos);
            this.setWriter(out);
            this.buildView(model, view);
            out.flush();
            String str = bos.toString();
            out.close();
            bos.close();
            String string = str;
            return string;
        }
        finally {
            this.mWriter = old_writer;
        }
    }

    public void buildViews(CompositeMap model, Collection view_list) throws Exception {
        if (view_list == null) {
            return;
        }
        for (CompositeMap view : view_list) {
            this.buildView(model, view);
        }
    }

    public String buildViewsAsString(CompositeMap model, Collection view_list) throws Exception {
        Writer old_writer = this.mWriter;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            PrintWriter out = new PrintWriter(bos);
            this.setWriter(out);
            this.buildViews(model, view_list);
            out.flush();
            String str = bos.toString();
            out.close();
            bos.close();
            String string = str;
            return string;
        }
        finally {
            this.mWriter = old_writer;
        }
    }

    public TextTemplate getTemplateByName(String name) throws IOException {
        if (this.mCurrentPackage == null) {
            throw new IllegalStateException("package of current component is undefined");
        }
        File template_file = this.mCurrentPackage.getTemplateFile(this.getTheme(), name);
        if (template_file == null) {
            return null;
        }
        return this.mOwner.parseTemplate(template_file, this.getTagCreatorRegistry());
    }

    public TextTemplate getTemplateFromString(String content) throws IOException {
        return this.mOwner.getTemplateParser().buildTemplate(new StringReader(content), this.getTagCreatorRegistry());
    }

    public void fireBuildEvent(String event_name, ViewContext context, boolean for_all_components) throws Exception {
        Object[] args = new Object[]{this, context};
        if (for_all_components) {
            this.mCurrentConfig.fireEvent(event_name, this.mSessionContext, args);
            if (this.mBaseConfig != null && this.mBaseConfig != this.mCurrentConfig) {
                this.mBaseConfig.fireEvent(event_name, this.mSessionContext, args);
            }
        } else {
            HandleManager manager = this.mCurrentConfig.createHandleManager(context.getView());
            this.mCurrentConfig.fireEvent(event_name, args, this.mSessionContext, manager);
        }
    }

    public void fireBuildEvent(String event_name, ViewContext context) throws Exception {
        this.fireBuildEvent(event_name, context, false);
    }

    public void fireBuildEvents(String[] event_name, ViewContext context) throws Exception {
        Object[] args = new Object[]{this, context};
        HandleManager manager = this.mCurrentConfig.createHandleManager(context.getView());
        int i = 0;
        while (i < event_name.length) {
            this.mCurrentConfig.fireEvent(event_name[i], args, this.mSessionContext, manager);
            ++i;
        }
    }

    public String getLocalizedPrompt(String key) {
        ILocalizedMessageProvider provider = this.getMessageProvider();
        if (provider != null) {
            String p = provider.getMessage(key);
            return p == null ? key : p;
        }
        return key;
    }

    public Writer getWriter() {
        return this.mWriter;
    }

    public void setWriter(Writer writer) {
        this.mWriter = writer;
    }

    public String getTheme() {
        return this.mTheme;
    }

    public void setTheme(String theme) {
        this.mTheme = theme;
    }

    public ILogger getLogger() {
        ILogger logger = (ILogger)this.mRuntimeContext.getInstanceOfType(ILogger.class);
        return logger == null ? DummyLogger.getInstance() : logger;
    }

    public void setLogger(ILogger logger) {
        this.mRuntimeContext.setInstanceOfType(ILogger.class, logger);
    }

    public void setLoggerProvider(ILoggerProvider provider) {
        this.mRuntimeContext.setInstanceOfType(ILoggerProvider.class, provider);
    }

    public String getResourceUrl(ViewComponentPackage pkg, String resource) {
        IResourceUrlMapper mapper = this.mOwner.getResourceUrlMapper();
        if (mapper == null) {
            throw new IllegalStateException("No instance of " + IResourceUrlMapper.class.getName() + " defined");
        }
        String theme = null;
        if (pkg.isResourceExist(this.mTheme, resource)) {
            theme = this.mTheme;
        } else {
            theme = "default";
            if (!pkg.isResourceExist(theme, resource)) {
                this.getLogger().warning("Required resource not found:" + resource);
                return null;
            }
        }
        StringBuffer buf = new StringBuffer();
        String path = mapper.getResourceUrl(pkg.getName(), theme, resource);
        String contextPath = this.getContextPath();
        if (contextPath != null) {
            buf.append(contextPath);
            if (!contextPath.endsWith("/")) {
                buf.append("/");
            }
        }
        buf.append(path);
        return buf.toString();
    }

    public String getResourceUrl(String package_name, String resource) {
        ViewComponentPackage pkg = this.mOwner.getPackage(package_name);
        if (pkg == null) {
            throw new IllegalArgumentException("packge " + package_name + " does not exist");
        }
        return this.getResourceUrl(pkg, resource);
    }

    public String getResourceUrl(String resource) {
        if (this.mCurrentPackage == null) {
            return null;
        }
        return this.getResourceUrl(this.mCurrentPackage, resource);
    }

    protected String getResourceFullName(String package_name, String resource) {
        return String.valueOf(package_name) + '.' + resource;
    }

    protected void checkResourceSet() {
        if (this.mIncludedResourceSet == null) {
            this.mIncludedResourceSet = new HashSet();
        }
    }

    public boolean includeResource(String package_name, String resource) {
        String full_name = this.getResourceFullName(package_name, resource);
        this.checkResourceSet();
        if (this.mIncludedResourceSet.contains(full_name)) {
            return true;
        }
        this.mIncludedResourceSet.add(full_name);
        return false;
    }

    public boolean includeResource(String resource) {
        String pkg_name = this.mCurrentPackage == null ? null : this.mCurrentPackage.getName();
        return this.includeResource(pkg_name, resource);
    }

    public void setResourceIncluded(String package_name, String resource, boolean included) {
        String full_name = this.getResourceFullName(package_name, resource);
        this.checkResourceSet();
        if (included) {
            this.mIncludedResourceSet.add(full_name);
        } else {
            this.mIncludedResourceSet.remove(full_name);
        }
    }

    public ViewComponentPackage getCurrentPackage() {
        return this.mCurrentPackage;
    }

    public CompositeMap getSessionContext() {
        return this.mSessionContext;
    }

    public ViewContext createNamedViewContext(QualifiedName qname) {
        ViewContext context;
        if (this.mNamedViewContextMap == null) {
            this.mNamedViewContextMap = new HashMap();
        }
        if ((context = (ViewContext)this.mNamedViewContextMap.get(qname)) == null) {
            context = new ViewContext();
            this.mNamedViewContextMap.put(qname, context);
        }
        return context;
    }

    public ViewContext getNamedViewContext(QualifiedName qname) {
        return this.mNamedViewContextMap == null ? null : (ViewContext)this.mNamedViewContextMap.get(qname);
    }

    public Configuration getBaseConfig() {
        return this.mBaseConfig;
    }

    public void setBaseConfig(Configuration baseConfig) {
        this.mBaseConfig = baseConfig;
    }

    public void setInstanceOfType(Class type, Object instance) {
        this.mRuntimeContext.setInstanceOfType(type, instance);
    }

    public Object getInstanceOfType(Class type) {
        return this.mRuntimeContext.getInstanceOfType(type);
    }

    public String parseString(String text, CompositeMap model) throws IOException {
        return TagParseUtil.parseStringFromSession(this, text, model);
    }

    public ILocalizedMessageProvider getMessageProvider() {
        return this.mMessageProvider;
    }

    public ITagCreatorRegistry getTagCreatorRegistry() {
        return this.mSessionTagCreatorRegistry == null ? this.mOwner.getTagCreatorRegistry() : this.mSessionTagCreatorRegistry;
    }

    public ITagCreatorRegistry getSessionTagCreatorRegistry() {
        return this.mSessionTagCreatorRegistry;
    }

    protected void setSessionTagCreatorRegistry(ITagCreatorRegistry registry) {
        this.mSessionTagCreatorRegistry = registry;
    }

    private void checkTagCreator() {
        if (this.mSessionTagCreatorRegistry == null) {
            TagCreatorRegistry r = new TagCreatorRegistry();
            this.mSessionTagCreatorRegistry = r;
            this.mSessionTagCreatorRegistry.setParent(this.mOwner.getTagCreatorRegistry());
        }
    }

    public void setMessageProvider(ILocalizedMessageProvider messageProvider) {
        this.mMessageProvider = messageProvider;
        this.checkTagCreator();
        LocalizedMessageTagCreator creator = new LocalizedMessageTagCreator(messageProvider);
        this.mSessionTagCreatorRegistry.registerTagCreator("l", creator);
    }

    public ILookupCodeProvider getLookupProvider() {
        return this.lookupProvider;
    }

    public void setLookupProvider(ILookupCodeProvider provider) {
        this.lookupProvider = provider;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getManifest() {
        return this.manifest;
    }

    public void setManifest(String manifest) {
        this.manifest = manifest;
    }

    public String getLabelSeparator() {
        return this.labelSeparator;
    }

    public void setLabelSeparator(String labelSeparator) {
        this.labelSeparator = labelSeparator;
    }

    public String getRadioSeparator() {
        return this.radioSeparator;
    }

    public void setRadioSeparator(String radioSeparator) {
        this.radioSeparator = radioSeparator;
    }

    public int getDefaultPageSize() {
        return this.defaultPageSize;
    }

    public void setDefaultPageSize(int size) {
        this.defaultPageSize = size;
    }
}

