/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation;

import java.util.Map;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.util.template.TextTemplate;

public class ViewContext {
    public static final String KEY_TEMPLATE = "__view_template";
    CompositeMap model;
    CompositeMap view;
    CompositeMap context_map = new CompositeMap();
    TextTemplate view_template;

    public ViewContext() {
    }

    public ViewContext(CompositeMap model, CompositeMap view) {
        this();
        this.model = model;
        this.view = view;
    }

    public Map getMap() {
        return this.context_map;
    }

    public CompositeMap getContextMap() {
        return this.context_map;
    }

    public TextTemplate getTemplate() {
        if (this.view_template == null) {
            return (TextTemplate)this.context_map.get(KEY_TEMPLATE);
        }
        return this.view_template;
    }

    public void setTemplate(TextTemplate template) {
        this.view_template = template;
    }

    public CompositeMap getModel() {
        return this.model;
    }

    public CompositeMap getView() {
        return this.view;
    }

    public void transferAttribute(String view_attrib_name, String context_attrib_name, boolean parse_tag) {
        String value = this.view.getString(view_attrib_name);
        if (value != null && parse_tag) {
            value = this.parseString(value);
        }
        this.context_map.put(context_attrib_name, value);
    }

    public void transferAttribute(String name, boolean parse_tag) {
        this.transferAttribute(name, name, parse_tag);
    }

    public String parseString(String content) {
        return TextParser.parse(content, this.model);
    }

    public String parseString(String content, CompositeMap map) {
        return TextParser.parse(content, map);
    }

    public Object getInstance(Class type) {
        return this.context_map.get(type.getName());
    }

    public void setInstance(Class type, Object instance) {
        this.context_map.put(type.getName(), instance);
    }
}

