/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std;

import aurora.presentation.BuildSession;
import aurora.presentation.IFreeMarkerTemplateProvider;
import aurora.presentation.IViewBuilder;
import aurora.presentation.ViewContext;
import aurora.presentation.ViewCreationException;
import freemarker.template.Template;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import uncertain.composite.CompositeLoader;
import uncertain.composite.CompositeMap;
import uncertain.ocm.IObjectRegistry;
import uncertain.ocm.ISingleton;

public class FreeMarkerTemplate
implements IViewBuilder,
ISingleton {
    public static final String PARSE = "parse";
    IObjectRegistry mObjectRegistry;

    public FreeMarkerTemplate(IObjectRegistry rg) {
        this.mObjectRegistry = rg;
    }

    @Override
    public void buildView(BuildSession session, ViewContext view_context) throws IOException, ViewCreationException {
        String str = "";
        Reader reader = null;
        Template t = null;
        StringWriter out = null;
        try {
            try {
                CompositeMap model = view_context.getModel();
                CompositeMap view = view_context.getView();
                boolean isParse = view.getBoolean(PARSE, true);
                IFreeMarkerTemplateProvider provider = (IFreeMarkerTemplateProvider)this.mObjectRegistry.getInstanceOfType(IFreeMarkerTemplateProvider.class);
                reader = new BufferedReader(new StringReader(view.getText()));
                t = new Template(view.getName(), reader, provider.getFreeMarkerConfiguration(), provider.getDefaultEncoding());
                out = new StringWriter();
                HashMap<String, CompositeMap> p = new HashMap<String, CompositeMap>();
                p.put("view", view);
                p.put("model", model);
                t.process(p, (Writer)out);
                out.flush();
                str = out.toString();
                if (isParse) {
                    String prefix;
                    StringBuffer sb = new StringBuffer();
                    HashMap<String, String> nsm = view.getRoot().getNamespaceMapping();
                    if (nsm == null) {
                        nsm = new HashMap<String, String>();
                    }
                    if ((prefix = (String)nsm.get("http://www.aurora-framework.org/application")) == null) {
                        prefix = view.getPrefix();
                        nsm.put("http://www.aurora-framework.org/application", prefix);
                    }
                    sb.append("<").append(prefix).append(":screen ");
                    Set ks = nsm.keySet();
                    for (String key : ks) {
                        String value = (String)nsm.get(key);
                        sb.append("xmlns:").append(value).append("=\"").append(key).append("\" ");
                    }
                    sb.append(">").append(str).append("</").append(view.getPrefix()).append(":screen>");
                    CompositeLoader cl = new CompositeLoader();
                    ArrayList<CompositeMap> list = new ArrayList<CompositeMap>();
                    CompositeMap c = cl.loadFromString(sb.toString(), provider.getDefaultEncoding());
                    list.add(c);
                    session.buildViews(model, list);
                } else {
                    Writer writer = session.getWriter();
                    writer.write(str);
                }
            }
            catch (Exception e) {
                throw new ViewCreationException(e.getMessage());
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    @Override
    public String[] getBuildSteps(ViewContext context) {
        return null;
    }
}

