/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std;

import aurora.presentation.BuildSession;
import aurora.presentation.ViewContext;
import aurora.presentation.component.std.Component;
import aurora.presentation.component.std.JSONFunction;
import aurora.presentation.component.std.config.EventConfig;
import aurora.presentation.component.std.config.GraphicConfig;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import uncertain.composite.CompositeMap;

public class Graphic
extends Component {
    @Override
    protected int getDefaultWidth() {
        return 600;
    }

    @Override
    protected int getDefaultHeight() {
        return 300;
    }

    @Override
    public void onPreparePageContent(BuildSession session, ViewContext context) throws IOException {
        super.onPreparePageContent(session, context);
        this.addJavaScript(session, context, "graphic/Graphics-min.js");
    }

    @Override
    public void onCreateViewContent(BuildSession session, ViewContext context) throws IOException {
        super.onCreateViewContent(session, context);
        Map map = context.getMap();
        CompositeMap view = context.getView();
        GraphicConfig gc = GraphicConfig.getInstance(view);
        if (gc.getDropTo() != null) {
            this.addConfig("dropto", gc.getDropTo());
        }
        if (gc.isMoveable()) {
            this.addConfig("moveable", new Boolean(gc.isMoveable()));
        }
        if (gc.isEditable()) {
            this.addConfig("editable", new Boolean(gc.isEditable()));
        }
        if (gc.getRenderer() != null) {
            this.addConfig("renderer", gc.getRenderer());
        }
        List childs = view.getChilds();
        StringBuffer create = new StringBuffer("");
        if (childs != null) {
            for (CompositeMap child : childs) {
                List list;
                if ("events".equalsIgnoreCase(child.getName())) continue;
                CompositeMap events = child.getChild("events");
                CompositeMap filters = child.getChild("filters");
                if (filters != null && (list = filters.getChilds()) != null) {
                    for (CompositeMap filter : list) {
                        child.put(filter.getName(), this.toJson(filter));
                    }
                }
                if (events != null && (list = events.getChilds()) != null) {
                    Iterator it2 = list.iterator();
                    JSONObject listeners = new JSONObject();
                    while (it2.hasNext()) {
                        CompositeMap event = (CompositeMap)it2.next();
                        EventConfig eventConfig = EventConfig.getInstance(event);
                        String eventName = eventConfig.getEventName();
                        String handler = eventConfig.getHandler();
                        if ("".equals(eventName) || "".equals(handler)) continue;
                        try {
                            listeners.put(eventName, new JSONFunction(handler));
                        }
                        catch (JSONException jSONException) {
                            // empty catch block
                        }
                    }
                    child.put("listeners", listeners);
                }
                create.append(".createGElement('");
                create.append(child.getName());
                create.append("',");
                JSONObject object = new JSONObject(child);
                create.append(object.toString());
                create.append(")");
            }
            map.put("creates", create.toString());
        }
        map.put("config", this.getConfigString());
    }

    private JSONObject toJson(CompositeMap filter) {
        List list = filter.getChilds();
        if (list != null) {
            for (CompositeMap child : list) {
                JSONArray o = (JSONArray)filter.get(child.getName());
                if (o == null) {
                    o = new JSONArray();
                    filter.put(child.getName(), o);
                }
                o.put(this.toJson(child));
            }
        }
        return new JSONObject(filter);
    }
}

