/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std;

import aurora.presentation.BuildSession;
import aurora.presentation.IViewBuilder;
import aurora.presentation.ViewContext;
import aurora.presentation.ViewCreationException;
import aurora.presentation.component.std.Component;
import aurora.presentation.component.std.IDGenerator;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import uncertain.composite.CompositeMap;
import uncertain.ocm.ISingleton;

public class GridLayout
extends Component
implements IViewBuilder,
ISingleton {
    public static final String ROWS = "row";
    public static final String COLUMNS = "column";
    protected static final int UNLIMITED = -1;
    protected static final String PROPERTITY_CELLPADDING = "cellpadding";
    protected static final String PROPERTITY_CELLSPACING = "cellspacing";
    protected static final String PROPERTITY_VALIDALIGN = "validalign";
    protected static final String PROPERTITY_PADDING = "padding";
    protected static final String TITLE_CLASS = "layout-title";
    protected static final String DEFAULT_TABLE_CLASS = "layout-table";
    protected static final String DEFAULT_TD_CELL = "layout-td-cell";
    protected static final String DEFAULT_TD_CONTAINER = "layout-td-con";

    @Override
    protected int getDefaultWidth() {
        return 0;
    }

    @Override
    protected int getDefaultHeight() {
        return 0;
    }

    protected int getRows(CompositeMap view) {
        int rows = view.getInt(ROWS, -1);
        return rows;
    }

    protected int getColumns(CompositeMap view) {
        int columns = view.getInt(COLUMNS, -1);
        return columns;
    }

    private void buildCell(BuildSession session, CompositeMap model, CompositeMap view, CompositeMap field) throws Exception {
        Writer out = session.getWriter();
        int padding = view.getInt(PROPERTITY_PADDING, 3);
        IViewBuilder builder = session.getPresentationManager().getViewBuilder(field);
        if (builder instanceof GridLayout) {
            this.beforeBuildCell(session, model, view, field);
            out.write("<td class='layout-td-con' style='padding:" + padding + "px'>");
        } else {
            this.beforeBuildCell(session, model, view, field);
            out.write("<td class='layout-td-cell' style='padding:" + padding + "px'>");
        }
        session.buildView(model, field);
        boolean cfr_ignored_0 = builder instanceof GridLayout;
        out.write("</td>");
    }

    protected void beforeBuildCell(BuildSession session, CompositeMap model, CompositeMap view, CompositeMap field) throws Exception {
    }

    protected void afterBuildCell(BuildSession session, CompositeMap model, CompositeMap field) throws Exception {
    }

    protected void buildHead(BuildSession session, CompositeMap model, CompositeMap view, int rows, int columns) throws Exception {
    }

    protected void buildFoot(BuildSession session, CompositeMap model, CompositeMap view) throws Exception {
    }

    protected void afterBuildTop(BuildSession session, CompositeMap model, CompositeMap view) throws Exception {
    }

    private void buildRows(BuildSession session, CompositeMap model, CompositeMap view, Iterator it) throws Exception {
        Writer out = session.getWriter();
        while (it.hasNext()) {
            out.write("<tr>");
            CompositeMap field = (CompositeMap)it.next();
            this.buildCell(session, model, view, field);
            out.write("</tr>");
        }
    }

    private void buildColumns(BuildSession session, CompositeMap model, CompositeMap view, Iterator it) throws Exception {
        Writer out = session.getWriter();
        out.write("<tr>");
        while (it.hasNext()) {
            CompositeMap field = (CompositeMap)it.next();
            this.buildCell(session, model, view, field);
        }
        out.write("</tr>");
    }

    protected void buildTop(BuildSession session, CompositeMap model, CompositeMap view, Map map, int rows, int columns, String id) throws Exception {
        Writer out = session.getWriter();
        String cls = view.getString("classname", "");
        String style = view.getString("style", "");
        int cellspacing = view.getInt(PROPERTITY_CELLSPACING, 0);
        int cellpadding = view.getInt(PROPERTITY_CELLPADDING, 0);
        boolean showBorder = view.getBoolean("showborder", false);
        int width = this.getComponentWidth(model, view, map);
        int height = this.getComponentHeight(model, view, map);
        String className = DEFAULT_TABLE_CLASS;
        className = String.valueOf(className) + " " + cls;
        if (showBorder) {
            cellspacing = 1;
            className = String.valueOf(className) + " layout-border";
        }
        out.write("<table border=0 class='" + className + "' id='" + id + "'");
        if (width != 0) {
            out.write(" width=" + width);
        }
        if (height != 0) {
            out.write(" height=" + height);
        }
        if (!"".equals(style)) {
            out.write(" style='" + style + "'");
        }
        out.write(" cellpadding=" + cellpadding + " cellspacing=" + cellspacing + ">");
        this.buildHead(session, model, view, rows, columns);
        this.afterBuildTop(session, model, view);
    }

    protected void buildBottom(BuildSession session, CompositeMap model, CompositeMap view) throws Exception {
        this.buildFoot(session, model, view);
        Writer out = session.getWriter();
        out.write("</tbody>");
        out.write("</table>");
    }

    @Override
    public void buildView(BuildSession session, ViewContext view_context) throws IOException, ViewCreationException {
        List children;
        CompositeMap view = view_context.getView();
        CompositeMap model = view_context.getModel();
        Map map = view_context.getMap();
        String id = view.getString("id", "");
        if ("".equals(id)) {
            id = IDGenerator.getInstance().generate();
        }
        Writer out = session.getWriter();
        Iterator it = view.getChildIterator();
        int rows = this.getRows(view);
        int columns = this.getColumns(view);
        if (rows == -1 && columns == -1) {
            rows = -1;
            columns = 1;
        } else if (rows == -1 && columns != -1) {
            children = view.getChilds();
            rows = children != null ? (int)Math.ceil((double)view.getChilds().size() / (double)columns) : 1;
        } else if (rows != -1 && columns == -1) {
            children = view.getChilds();
            columns = children != null ? (int)Math.ceil((double)view.getChilds().size() / (double)rows) : 1;
        }
        try {
            this.buildTop(session, model, view, map, rows, columns, id);
            if (it != null) {
                if (rows == -1) {
                    this.buildRows(session, model, view, it);
                } else if (columns == -1) {
                    this.buildColumns(session, model, view, it);
                } else {
                    int n = 0;
                    while (n < rows) {
                        out.write("<tr>");
                        int k = 0;
                        while (k < columns) {
                            if (it.hasNext()) {
                                CompositeMap field = (CompositeMap)it.next();
                                this.buildCell(session, model, view, field);
                            } else {
                                out.write("<th class='layout-th'></th><td class='layout-td-cell'></td>");
                            }
                            ++k;
                        }
                        out.write("</tr>");
                        ++n;
                    }
                }
            }
            this.buildBottom(session, model, view);
        }
        catch (Exception e) {
            throw new ViewCreationException(e);
        }
    }

    @Override
    public String[] getBuildSteps(ViewContext context) {
        return null;
    }
}

