/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std;

import aurora.presentation.BuildSession;
import aurora.presentation.ViewContext;
import aurora.presentation.component.std.Component;
import aurora.presentation.component.std.IDGenerator;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;

public class Tab
extends Component {
    private static final String DEFAULT_CLASS = "item-tab";
    private static final String VALID_SCRIPT = "validscript";
    private static final String TABS = "tabs";
    protected static final String PROPERTITY_TAB = "tab";
    protected static final String PROPERTITY_TAB_CLASS = "tabclassname";
    protected static final String PROPERTITY_TAB_STYLE = "tabstyle";
    protected static final String PROPERTITY_BODY_CLASS = "bodyclassname";
    protected static final String PROPERTITY_BODY_STYLE = "bodystyle";
    protected static final String PROPERTITY_REF = "ref";
    protected static final String PROPERTITY_SELECTED = "selected";
    protected static final String PROPERTITY_CLOSEABLE = "closeable";
    protected static final String PROPERTITY_DISABLED = "disabled";

    @Override
    public void onPreparePageContent(BuildSession session, ViewContext context) throws IOException {
        super.onPreparePageContent(session, context);
        this.addStyleSheet(session, context, "tab/Tab-min.css");
        this.addJavaScript(session, context, "tab/Tab-min.js");
    }

    @Override
    protected String getDefaultClass(BuildSession session, ViewContext context) {
        return DEFAULT_CLASS;
    }

    @Override
    public void onCreateViewContent(BuildSession session, ViewContext context) throws IOException {
        super.onCreateViewContent(session, context);
        Map map = context.getMap();
        StringBuffer sb = new StringBuffer();
        Integer bodyWidth = new Integer((Integer)map.get("width") - 2);
        Integer bodyHeight = new Integer((Integer)map.get("height") - 25);
        map.put("bodywidth", bodyWidth);
        map.put("headwidth", new Integer(bodyWidth - 36));
        map.put("bodyheight", bodyHeight);
        map.put("strips", this.createTabStrips(session, context, sb));
        map.put("bodys", this.createTabBodys(session, context));
        if ((Integer)map.get("stripswidth") <= bodyWidth - 36) {
            map.put("display", "none");
        }
        map.put(VALID_SCRIPT, sb.toString());
        map.put("config", this.getConfigString());
    }

    private String createTabBodys(BuildSession session, ViewContext context) throws IOException {
        List childs;
        CompositeMap view = context.getView();
        CompositeMap model = context.getModel();
        Map map = context.getMap();
        StringBuffer sb = new StringBuffer();
        CompositeMap tabs = view.getChild(TABS);
        if (tabs != null && (childs = tabs.getChilds()) != null) {
            for (CompositeMap tab : childs) {
                List tabchilds;
                Integer bodywidth = (Integer)map.get("bodywidth");
                Integer bodyheight = (Integer)map.get("bodyheight");
                String ref = tab.getString(PROPERTITY_REF, "");
                String bodyClass = tab.getString(PROPERTITY_BODY_CLASS, "");
                String bodyStyle = tab.getString(PROPERTITY_BODY_STYLE, "");
                sb.append("<div class='tab " + bodyClass + "' style='width:" + bodywidth + "px;height:" + bodyheight + "px;" + bodyStyle + "'>");
                if ("".equals(ref) && (tabchilds = tab.getChilds()) != null) {
                    for (CompositeMap tabchild : tabchilds) {
                        try {
                            sb.append(session.buildViewAsString(model, tabchild));
                        }
                        catch (Exception e) {
                            throw new IOException(e.getMessage());
                        }
                    }
                }
                sb.append("</div>");
            }
        }
        return sb.toString();
    }

    private String createTabStrips(BuildSession session, ViewContext context, StringBuffer st) {
        List childs;
        CompositeMap view = context.getView();
        Map map = context.getMap();
        CompositeMap model = context.getModel();
        JSONArray jsons = new JSONArray();
        StringBuffer sb = new StringBuffer();
        CompositeMap tabs = view.getChild(TABS);
        int stripswidth = 0;
        if (tabs != null && (childs = tabs.getChilds()) != null) {
            Iterator it = childs.iterator();
            int i = 0;
            while (it.hasNext()) {
                String selected;
                CompositeMap tab = (CompositeMap)it.next();
                String prompt = tab.getString("prompt", "");
                prompt = session.getLocalizedPrompt(prompt);
                int width = tab.getInt("width", 60);
                stripswidth += width + 6;
                String id = tab.getString("id", "");
                String target = tab.getString("bindtarget", "");
                if (!"".equals(target)) {
                    if ("".equals(id)) {
                        id = IDGenerator.getInstance().generate();
                    }
                    String[] ts = target.split(",");
                    int b = 0;
                    while (b < ts.length) {
                        String tid = ts[b];
                        st.append("$('" + tid + "').on('valid',function(ds, record, name, valid){if(!valid && !Ext.get('" + id + "').hasActiveFx()) Ext.get('" + id + "').frame('ff0000', 3, { duration: 1 })});\n");
                        ++b;
                    }
                }
                if ("true".equals(selected = tab.getString(PROPERTITY_SELECTED, ""))) {
                    map.put(PROPERTITY_SELECTED, new Integer(i));
                    this.addConfig(PROPERTITY_SELECTED, new Integer(i));
                }
                String tabClass = tab.getString(PROPERTITY_TAB_CLASS, "");
                String tabStyle = tab.getString(PROPERTITY_TAB_STYLE, "");
                boolean closeable = tab.getBoolean(PROPERTITY_CLOSEABLE, false);
                boolean disabled = tab.getBoolean(PROPERTITY_DISABLED, false);
                if (!"".equals(tabStyle)) {
                    tabStyle = "style='" + tabStyle + "'";
                }
                sb.append("<div class='strip unactive");
                if (disabled) {
                    sb.append(" scroll-disabled");
                }
                sb.append("' " + tabStyle + " unselectable='on' " + (!"".equals(id) ? "id='" + id + "'" : "") + " onselectstart='return false;'><div style='height:26px;width:" + (width + 6) + "px'>");
                sb.append("<div class='strip-left " + tabClass + "'></div>");
                sb.append("<div class='strip-center " + tabClass + "' style='width:" + width + "px;'>");
                if (closeable) {
                    sb.append("<div class='tab-close'></div>");
                }
                sb.append(String.valueOf(prompt) + "</div>");
                sb.append("<div class='strip-right " + tabClass + "'></div>");
                sb.append("</div></div>");
                tab.putBoolean(PROPERTITY_SELECTED, tab.getBoolean(PROPERTITY_SELECTED, false));
                String ref = tab.getString(PROPERTITY_REF, "");
                ref = TextParser.parse(ref, model);
                tab.putString(PROPERTITY_REF, ref);
                JSONObject json = new JSONObject(tab);
                jsons.put(json);
                ++i;
            }
        }
        map.put("stripswidth", new Integer(stripswidth));
        this.addConfig("items", jsons);
        map.put("items", jsons.toString());
        return sb.toString();
    }
}

