/*
 * Decompiled with CFR 0.152.
 */
package uncertain.cache;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import uncertain.cache.CacheMapping;
import uncertain.cache.CacheWrapper;
import uncertain.cache.ICache;
import uncertain.cache.ICacheFactory;
import uncertain.cache.ICacheManager;
import uncertain.cache.ICacheReader;
import uncertain.cache.ICacheWriter;
import uncertain.cache.INamedCacheFactory;
import uncertain.composite.CompositeLoader;
import uncertain.composite.CompositeMap;
import uncertain.core.ConfigurationError;
import uncertain.core.DirectoryConfig;
import uncertain.core.ILifeCycle;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.IObjectRegistry;
import uncertain.ocm.OCManager;
import uncertain.util.FilePatternFilter;
import uncertain.util.FileUtil;

public class CacheFactoryConfig
implements INamedCacheFactory,
ILifeCycle {
    private static final CacheWrapper NOT_ENABLED_CACHE = new CacheWrapper();
    String mName;
    String cacheConfig = "cacheConfig";
    INamedCacheFactory mDefaultCacheFactory;
    String mDefaultCacheFactoryName;
    INamedCacheFactory[] mNamedCacheFactoryArray;
    CacheMapping[] mCacheMappingArray;
    Map mCacheFactoryMap = new HashMap();
    Map mPredefinedCacheMap = new HashMap();
    IObjectRegistry mRegistry;
    ILogger mLogger;
    Set<ICacheManager> mCacheManagerSet = new HashSet<ICacheManager>();

    public static ICache getNamedCache(IObjectRegistry reg, String name) {
        INamedCacheFactory fact = (INamedCacheFactory)reg.getInstanceOfType(INamedCacheFactory.class);
        if (fact != null) {
            if (!fact.isCacheEnabled(name)) {
                return null;
            }
            return fact.getNamedCache(name);
        }
        return null;
    }

    public CacheFactoryConfig() {
    }

    public CacheFactoryConfig(IObjectRegistry reg) {
        this.mRegistry = reg;
        reg.registerInstance(INamedCacheFactory.class, this);
        reg.registerInstance(ICacheFactory.class, this);
    }

    public String getDefaultCacheFactory() {
        return this.mDefaultCacheFactoryName;
    }

    public void setDefaultCacheFactory(String mDefaultCacheFactory) {
        this.mDefaultCacheFactoryName = mDefaultCacheFactory;
    }

    @Override
    public ICacheReader getCacheReader() {
        return this.mDefaultCacheFactory == null ? null : this.mDefaultCacheFactory.getCacheReader();
    }

    @Override
    public ICacheWriter getCacheWriter() {
        return this.mDefaultCacheFactory == null ? null : this.mDefaultCacheFactory.getCacheWriter();
    }

    @Override
    public ICache getCache() {
        return this.mDefaultCacheFactory == null ? null : this.mDefaultCacheFactory.getCache();
    }

    @Override
    public String getName() {
        return this.mName;
    }

    public void setName(String name) {
        this.mName = name;
    }

    @Override
    public ICache getNamedCache(String name) {
        Object o = this.mPredefinedCacheMap.get(name);
        if (o == null) {
            return this.mDefaultCacheFactory == null ? null : this.mDefaultCacheFactory.getNamedCache(name);
        }
        if (NOT_ENABLED_CACHE.equals(o)) {
            return null;
        }
        return ((INamedCacheFactory)o).getNamedCache(name);
    }

    public void addCacheFactories(INamedCacheFactory[] factories) {
        this.mNamedCacheFactoryArray = factories;
    }

    public void addCacheMappings(CacheMapping[] mappings) {
        this.mCacheMappingArray = mappings;
    }

    @Override
    public boolean startup() {
        DirectoryConfig dcfg;
        File cacheConfigDir;
        this.mLogger = LoggingContext.getLogger(this.getClass().getCanonicalName(), this.mRegistry);
        int i = 0;
        while (i < this.mNamedCacheFactoryArray.length) {
            this.mCacheFactoryMap.put(this.mNamedCacheFactoryArray[i].getName(), this.mNamedCacheFactoryArray[i]);
            ++i;
        }
        i = 0;
        while (i < this.mCacheMappingArray.length) {
            CacheMapping cm = this.mCacheMappingArray[i];
            INamedCacheFactory fact = (INamedCacheFactory)this.mCacheFactoryMap.get(cm.getCacheFactory());
            if (fact == null) {
                throw new ConfigurationError("Can't find cache factory named " + cm.getCacheFactory());
            }
            if (!cm.getEnabled()) {
                this.mPredefinedCacheMap.put(cm.getName(), NOT_ENABLED_CACHE);
            } else {
                this.mPredefinedCacheMap.put(cm.getName(), fact);
            }
            ++i;
        }
        if (this.mDefaultCacheFactoryName != null) {
            this.mDefaultCacheFactory = (INamedCacheFactory)this.mCacheFactoryMap.get(this.mDefaultCacheFactoryName);
            if (this.mDefaultCacheFactory == null) {
                throw new ConfigurationError("Can't find cache factory named " + this.mDefaultCacheFactoryName);
            }
        }
        if (this.cacheConfig != null && (cacheConfigDir = new File((dcfg = (DirectoryConfig)this.mRegistry.getInstanceOfType(DirectoryConfig.class)).getConfigDirectory(), this.cacheConfig)).exists()) {
            this.scanConfigFiles(cacheConfigDir, ".*\\.config");
        }
        return true;
    }

    @Override
    public boolean isCacheEnabled(String name) {
        Object o = this.mPredefinedCacheMap.get(name);
        if (o == null) {
            return this.mDefaultCacheFactory == null ? false : this.mDefaultCacheFactory.isCacheEnabled(name);
        }
        return !NOT_ENABLED_CACHE.equals(o);
    }

    @Override
    public void shutdown() {
        if (this.mNamedCacheFactoryArray == null) {
            return;
        }
        int i = 0;
        while (i < this.mNamedCacheFactoryArray.length) {
            INamedCacheFactory o = this.mNamedCacheFactoryArray[i];
            if (o instanceof ILifeCycle) {
                ILifeCycle s = (ILifeCycle)((Object)o);
                s.shutdown();
            }
            ++i;
        }
        for (ICacheManager cm : this.mCacheManagerSet) {
            if (!(cm instanceof ILifeCycle)) continue;
            ((ILifeCycle)((Object)cm)).shutdown();
        }
    }

    @Override
    public void setNamedCache(String name, ICache cache) {
        Object o = this.mPredefinedCacheMap.get(name);
        if (o == null) {
            if (this.mDefaultCacheFactory != null) {
                this.mDefaultCacheFactory.setNamedCache(name, cache);
            }
        } else {
            if (NOT_ENABLED_CACHE.equals(o)) {
                return;
            }
            ((INamedCacheFactory)o).setNamedCache(name, cache);
        }
    }

    public String getCacheConfig() {
        return this.cacheConfig;
    }

    public void setCacheConfig(String cacheConfig) {
        this.cacheConfig = cacheConfig;
    }

    private void scanConfigFiles(File dir, String file_pattern) {
        CompositeLoader compositeLoader = CompositeLoader.createInstanceForOCM();
        OCManager ocm = (OCManager)this.mRegistry.getInstanceOfType(OCManager.class);
        FilePatternFilter filter = new FilePatternFilter(file_pattern);
        File[] cfg_files = dir.listFiles(filter);
        List<File> file_list = FileUtil.getSortedList(cfg_files);
        if (cfg_files.length > 0) {
            ListIterator<File> fit = file_list.listIterator(cfg_files.length);
            while (fit.hasPrevious()) {
                File file = fit.previous();
                String file_path = file.getAbsolutePath();
                this.mLogger.log("Loading cache config file " + file_path);
                CompositeMap config_map = null;
                try {
                    config_map = compositeLoader.loadByFullFilePath(file_path);
                }
                catch (Exception ex) {
                    throw BuiltinExceptionFactory.createResourceLoadException(null, file_path, ex);
                }
                Object inst = ocm.createObject(config_map);
                if (inst instanceof ILifeCycle) {
                    ((ILifeCycle)inst).startup();
                }
                if (inst == null) {
                    throw BuiltinExceptionFactory.createCannotCreateInstanceFromConfigException(null, file_path);
                }
                if (!(inst instanceof ICacheManager)) {
                    throw BuiltinExceptionFactory.createInstanceTypeWrongException(file_path, ICacheManager.class, inst.getClass());
                }
                this.mCacheManagerSet.add((ICacheManager)inst);
            }
        }
    }

    public void onInitialize() {
        for (ICacheManager cacheApp : this.mCacheManagerSet) {
            cacheApp.initialize();
        }
    }
}

