/*
 * Decompiled with CFR 0.152.
 */
package uncertain.composite;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import uncertain.composite.CompositeLoader;
import uncertain.composite.CompositeMap;
import uncertain.composite.NameProcessor;

public class CompositeMapParser
extends DefaultHandler {
    public static final String INCLUDE_INSTRUCTION = "include";
    public static final String XINCLUDE_URI = "http://www.w3.org/2001/XInclude";
    public static final String KEY_HREF = "href";
    CompositeMap current_node = null;
    LinkedList node_stack = new LinkedList();
    Map uri_mapping = new HashMap();
    Map saved_uri_mapping;
    Map namespace_mapping = new HashMap();
    NameProcessor name_processor;
    CompositeLoader composite_loader;
    Locator locator;
    static SAXParserFactory parser_factory = SAXParserFactory.newInstance();

    static {
        try {
            parser_factory.setNamespaceAware(true);
            parser_factory.setValidating(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public CompositeMapParser(CompositeLoader composite_loader) {
        this.composite_loader = composite_loader;
    }

    void push(CompositeMap node) {
        this.node_stack.addFirst(node);
    }

    CompositeMap pop() {
        CompositeMap node = (CompositeMap)this.node_stack.getFirst();
        this.node_stack.removeFirst();
        return node;
    }

    void addAttribs(CompositeMap node, Attributes attribs) {
        int i = 0;
        while (i < attribs.getLength()) {
            String attrib_name = attribs.getQName(i);
            if (this.name_processor != null) {
                attrib_name = this.name_processor.getAttributeName(attrib_name);
            }
            node.put(attrib_name, attribs.getValue(i));
            ++i;
        }
    }

    @Override
    public void startDocument() {
        this.current_node = null;
        this.node_stack.clear();
        this.uri_mapping.clear();
        this.name_processor = this.getCompositeLoader().getNameProcessor();
    }

    @Override
    public void startElement(String namespaceURI, String localName, String rawName, Attributes atts) throws SAXException {
        if (this.composite_loader.getSupportXInclude() && localName.equals(INCLUDE_INSTRUCTION) && namespaceURI != null && namespaceURI.equals(XINCLUDE_URI)) {
            CompositeMap included;
            String href_target = atts.getValue(KEY_HREF);
            if (href_target == null) {
                throw new SAXException("No 'href' attribute set for an XInclude instruction");
            }
            try {
                included = this.getCompositeLoader().load(href_target);
            }
            catch (IOException ex) {
                throw new SAXException(ex);
            }
            if (this.current_node == null) {
                this.current_node = included;
            } else {
                this.current_node.addChild(included);
            }
            return;
        }
        if (this.name_processor != null) {
            localName = this.name_processor.getElementName(localName);
        }
        CompositeMap node = null;
        node = this.getCompositeLoader() != null ? this.getCompositeLoader().createCompositeMap((String)this.uri_mapping.get(namespaceURI), namespaceURI, localName) : new CompositeMap((String)this.uri_mapping.get(namespaceURI), namespaceURI, localName);
        node.getLocationNotNull().setStartPoint(this.locator.getLineNumber(), this.locator.getColumnNumber());
        this.addAttribs(node, atts);
        if (this.current_node == null) {
            this.current_node = node;
        } else {
            this.current_node.addChild(node);
            this.push(this.current_node);
            this.current_node = node;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.current_node.getLocationNotNull().setEndPoint(this.locator.getLineNumber(), this.locator.getColumnNumber());
        if (this.getCompositeLoader().getSupportXInclude() && localName.equals(INCLUDE_INSTRUCTION) && uri != null && uri.equals(XINCLUDE_URI)) {
            return;
        }
        if (this.node_stack.size() > 0) {
            this.current_node = this.pop();
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (prefix == null) {
            return;
        }
        if (prefix.length() == 0) {
            return;
        }
        this.uri_mapping.put(uri, prefix);
        this.namespace_mapping.put(prefix, uri);
        if (this.getCompositeLoader().getSaveNamespaceMapping()) {
            if (this.saved_uri_mapping == null) {
                this.saved_uri_mapping = new HashMap();
            }
            this.saved_uri_mapping.put(uri, prefix);
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this.uri_mapping.remove(prefix);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (ch == null) {
            return;
        }
        if (length == 0) {
            return;
        }
        if (this.current_node != null) {
            String t = this.current_node.getText();
            t = t != null ? String.valueOf(t) + new String(ch, start, length) : new String(ch, start, length);
            this.current_node.setText(t);
        }
    }

    public CompositeMap getRoot() {
        return this.current_node;
    }

    public void setCompositeLoader(CompositeLoader loader) {
        this.composite_loader = loader;
    }

    public CompositeLoader getCompositeLoader() {
        return this.composite_loader;
    }

    public CompositeMap parseStream(InputStream stream) throws SAXException, IOException {
        SAXParser parser = null;
        try {
            parser = parser_factory.newSAXParser();
        }
        catch (ParserConfigurationException ex) {
            throw new SAXException("error when creating SAXParser", ex);
        }
        parser.parse(stream, (DefaultHandler)this);
        CompositeMap root = this.getRoot();
        if (this.getCompositeLoader().getSaveNamespaceMapping()) {
            root.setNamespaceMapping(this.saved_uri_mapping);
        }
        return root;
    }

    public void clear() {
        this.current_node = null;
        if (this.node_stack != null) {
            this.node_stack.clear();
        }
        if (this.uri_mapping != null) {
            this.uri_mapping.clear();
        }
        this.name_processor = null;
        this.composite_loader = null;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
        super.setDocumentLocator(locator);
    }
}

